/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.java.security.action.GetPropertyAction;
import gnu.java.security.x509.X509CertPath;
import gnu.javax.net.ssl.NullManagerParameters;
import gnu.javax.net.ssl.StaticTrustAnchors;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509TrustManager;

public class X509TrustManagerFactory
extends TrustManagerFactorySpi {
    private static final String sep = AccessController.doPrivileged(new GetPropertyAction("file.separator"));
    private static final String JSSE_CERTS = AccessController.doPrivileged(new GetPropertyAction("java.home")) + sep + "lib" + sep + "security" + sep + "jssecerts";
    private static final String CA_CERTS = AccessController.doPrivileged(new GetPropertyAction("java.home")) + sep + "lib" + sep + "security" + sep + "cacerts";
    private Manager current;

    protected TrustManager[] engineGetTrustManagers() {
        if (this.current == null) {
            throw new IllegalStateException("not initialized");
        }
        return new TrustManager[]{this.current};
    }

    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        if (managerFactoryParameters instanceof StaticTrustAnchors) {
            this.current = new Manager(((StaticTrustAnchors)managerFactoryParameters).getCertificates());
        } else if (managerFactoryParameters instanceof NullManagerParameters) {
            this.current = new Manager(new X509Certificate[0]);
        } else {
            throw new InvalidAlgorithmParameterException();
        }
    }

    protected void engineInit(KeyStore keyStore) throws KeyStoreException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (keyStore == null) {
            object4 = new GetPropertyAction("javax.net.ssl.trustStoreType");
            object3 = (String)AccessController.doPrivileged(object4);
            if (object3 == null) {
                object3 = KeyStore.getDefaultType();
            }
            keyStore = KeyStore.getInstance((String)object3);
            try {
                object3 = AccessController.doPrivileged(((GetPropertyAction)object4).setParameters("javax.net.ssl.trustStore"));
                object2 = null;
                if (object3 == null) {
                    try {
                        object2 = new FileInputStream(JSSE_CERTS);
                    }
                    catch (IOException iOException) {
                        object2 = new FileInputStream(CA_CERTS);
                    }
                } else {
                    object2 = new FileInputStream((String)object3);
                }
                keyStore.load((InputStream)object2, (object = AccessController.doPrivileged(((GetPropertyAction)object4).setParameters("javax.net.ssl.trustStorePassword"))) != null ? ((String)object).toCharArray() : null);
            }
            catch (IOException iOException) {
                throw new KeyStoreException(iOException);
            }
            catch (CertificateException certificateException) {
                throw new KeyStoreException(certificateException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new KeyStoreException(noSuchAlgorithmException);
            }
        }
        object4 = new LinkedList();
        object3 = keyStore.aliases();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            if (!keyStore.isCertificateEntry((String)object2) || !((object = keyStore.getCertificate((String)object2)) instanceof X509Certificate)) continue;
            ((LinkedList)object4).add((X509Certificate)object);
        }
        this.current = new Manager((X509Certificate[])((LinkedList)object4).toArray((S[])new X509Certificate[((LinkedList)object4).size()]));
    }

    private class Manager
    implements X509TrustManager {
        private final Set<TrustAnchor> anchors = new HashSet<TrustAnchor>();

        Manager(X509Certificate[] x509CertificateArray) {
            if (x509CertificateArray != null) {
                for (X509Certificate x509Certificate : x509CertificateArray) {
                    this.anchors.add(new TrustAnchor(x509Certificate, null));
                }
            }
        }

        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this.checkTrusted(x509CertificateArray, string);
        }

        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this.checkTrusted(x509CertificateArray, string);
        }

        public X509Certificate[] getAcceptedIssuers() {
            return this.anchors.toArray(new X509Certificate[this.anchors.size()]);
        }

        private void checkTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            CertPathValidator certPathValidator = null;
            try {
                certPathValidator = CertPathValidator.getInstance("PKIX");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new CertificateException(noSuchAlgorithmException);
            }
            X509CertPath x509CertPath = new X509CertPath(Arrays.asList(x509CertificateArray));
            PKIXParameters pKIXParameters = null;
            try {
                pKIXParameters = new PKIXParameters(this.anchors);
                pKIXParameters.setRevocationEnabled(false);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new CertificateException(invalidAlgorithmParameterException);
            }
            try {
                certPathValidator.validate(x509CertPath, pKIXParameters);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertificateException(certPathValidatorException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new CertificateException(invalidAlgorithmParameterException);
            }
        }
    }
}

