/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class X500PrincipalList
implements Iterable<X500Principal> {
    private final ByteBuffer buffer;
    private int modCount;

    public X500PrincipalList(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
        this.modCount = 0;
    }

    public int size() {
        return this.buffer.getShort(0) & 0xFFFF;
    }

    public int count() {
        int n;
        int n2 = this.size();
        int n3 = 0;
        int n4 = 2;
        while (n4 < n2 && (n = this.buffer.getShort(n4) & 0xFFFF) != 0) {
            n4 += n + 2;
            ++n3;
        }
        return n3;
    }

    public X500Principal get(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("negative index");
        }
        int n2 = this.size();
        int n3 = 0;
        int n4 = 2;
        while (n4 < n2) {
            int n5 = this.buffer.getShort(n4) & 0xFFFF;
            if (n5 == 0) {
                throw new IndexOutOfBoundsException("zero-length name encountered");
            }
            if (n3 == n) {
                byte[] byArray = new byte[n5];
                this.buffer.position(n4 + 2);
                this.buffer.get(byArray);
                return new X500Principal(byArray);
            }
            n4 += 2 + n5;
            ++n3;
        }
        throw new IndexOutOfBoundsException("limit: " + n3 + "; requested: " + n);
    }

    public void put(int n, X500Principal x500Principal) {
        this.put(n, x500Principal.getEncoded());
    }

    public void put(int n, byte[] byArray) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("negative index");
        }
        int n2 = this.size();
        int n3 = 0;
        int n4 = 2;
        while (n4 < n2) {
            int n5 = this.buffer.getShort(n4) & 0xFFFF;
            if (n3 == n) {
                this.buffer.putShort(n4, (short)byArray.length);
                this.buffer.position(n4 + 2);
                this.buffer.put(byArray);
                ++this.modCount;
                return;
            }
            n4 += 2 + n5;
            ++n3;
        }
        throw new IndexOutOfBoundsException("limit: " + (n3 - 1) + "; requested: " + n);
    }

    public void setSize(int n, int n2) {
        if (n < 1) {
            throw new IllegalArgumentException("must have at least one name");
        }
        int n3 = n * 2 + n2;
        if (n3 < 3 || n3 > this.buffer.capacity() || n3 > 65535) {
            throw new IllegalArgumentException("size out of range; maximum: " + Math.min(this.buffer.capacity(), 65535));
        }
        this.buffer.putShort(0, (short)n3);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("[");
        printWriter.print(this.count());
        printWriter.println("] {");
        Iterator iterator = new Iterator();
        while (iterator.hasNext()) {
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.print("  ");
            printWriter.println(iterator.next());
        }
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("};");
        return stringWriter.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof X500PrincipalList)) {
            return false;
        }
        X500PrincipalList x500PrincipalList = (X500PrincipalList)object;
        if (this.size() != x500PrincipalList.size()) {
            return false;
        }
        Iterator iterator = new Iterator();
        Iterator iterator2 = x500PrincipalList.new Iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            if (iterator.next().equals(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public java.util.Iterator<X500Principal> iterator() {
        return new Iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Iterator
    implements ListIterator<X500Principal> {
        private final int modCount;
        private int index;
        private final int count;

        public Iterator() {
            this.modCount = X500PrincipalList.this.modCount;
            this.index = 0;
            this.count = X500PrincipalList.this.count();
        }

        @Override
        public void add(X500Principal x500Principal) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public X500Principal next() throws NoSuchElementException {
            if (this.modCount != X500PrincipalList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                return X500PrincipalList.this.get(this.index++);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            if (this.hasNext()) {
                return this.index + 1;
            }
            return -1;
        }

        @Override
        public X500Principal previous() throws NoSuchElementException {
            if (this.index == 0) {
                throw new NoSuchElementException();
            }
            if (this.modCount != X500PrincipalList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                return X500PrincipalList.this.get(--this.index);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(X500Principal x500Principal) {
            throw new UnsupportedOperationException();
        }
    }
}

