/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.java.lang.CPStringBuilder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;

public final class Util {
    static final String HEX = "0123456789abcdef";

    private Util() {
    }

    public static Object wrapBuffer(ByteBuffer byteBuffer) {
        return Util.wrapBuffer(byteBuffer, "");
    }

    public static Object wrapBuffer(ByteBuffer byteBuffer, String string) {
        return new WrappedBuffer(byteBuffer, string);
    }

    public static byte[] toByteArray(String string) {
        string = string.toLowerCase();
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(Character.digit(string.charAt(n++), 16) << 4 | Character.digit(string.charAt(n++), 16));
        }
        return byArray;
    }

    public static String toHexString(byte[] byArray, int n, int n2) {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        for (int i = 0; i < n2; ++i) {
            cPStringBuilder.append(HEX.charAt(byArray[i + n] >>> 4 & 0xF));
            cPStringBuilder.append(HEX.charAt(byArray[i + n] & 0xF));
        }
        return cPStringBuilder.toString();
    }

    public static String toHexString(byte[] byArray) {
        return Util.toHexString(byArray, 0, byArray.length);
    }

    public static String toHexString(byte[] byArray, int n, int n2, char c) {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        for (int i = 0; i < n2; ++i) {
            cPStringBuilder.append(HEX.charAt(byArray[i + n] >>> 4 & 0xF));
            cPStringBuilder.append(HEX.charAt(byArray[i + n] & 0xF));
            if (i >= n2 - 1) continue;
            cPStringBuilder.append(c);
        }
        return cPStringBuilder.toString();
    }

    public static String toHexString(byte[] byArray, char c) {
        return Util.toHexString(byArray, 0, byArray.length, c);
    }

    public static String hexDump(byte[] byArray, int n, int n2, String string) {
        String string2 = Util.getProperty("line.separator");
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        for (int i = 0; i < n2; i += 16) {
            int n3;
            if (string != null) {
                cPStringBuilder.append(string);
            }
            cPStringBuilder.append(Util.formatInt(i + n, 16, 8));
            cPStringBuilder.append("  ");
            String string3 = Util.toHexString(byArray, i + n, Math.min(16, n2 - i), ' ');
            cPStringBuilder.append(string3);
            for (n3 = string3.length(); n3 < 49; ++n3) {
                cPStringBuilder.append(" ");
            }
            for (n3 = 0; n3 < Math.min(16, n2 - i); ++n3) {
                if ((byArray[i + n + n3] & 0xFF) < 32 || (byArray[i + n + n3] & 0xFF) > 126) {
                    cPStringBuilder.append('.');
                    continue;
                }
                cPStringBuilder.append((char)(byArray[i + n + n3] & 0xFF));
            }
            cPStringBuilder.append(string2);
        }
        return cPStringBuilder.toString();
    }

    public static String hexDump(ByteBuffer byteBuffer) {
        return Util.hexDump(byteBuffer, null);
    }

    public static String hexDump(ByteBuffer byteBuffer, String string) {
        byteBuffer = byteBuffer.duplicate();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        int n = byteBuffer.remaining();
        byte[] byArray = new byte[16];
        for (int i = 0; i < n; i += 16) {
            int n2;
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.print(Util.formatInt(i, 16, 8));
            printWriter.print("  ");
            int n3 = Math.min(16, n - i);
            byteBuffer.get(byArray, 0, n3);
            String string2 = Util.toHexString(byArray, 0, n3, ' ');
            printWriter.print(string2);
            for (n2 = string2.length(); n2 < 49; ++n2) {
                printWriter.print(' ');
            }
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = byArray[n2] & 0xFF;
                if (n4 < 32 || n4 > 126) {
                    printWriter.print('.');
                    continue;
                }
                printWriter.print((char)n4);
            }
            printWriter.println();
        }
        return stringWriter.toString();
    }

    public static String hexDump(byte[] byArray, int n, int n2) {
        return Util.hexDump(byArray, n, n2, "");
    }

    public static String hexDump(byte[] byArray, String string) {
        return Util.hexDump(byArray, 0, byArray.length, string);
    }

    public static String hexDump(byte[] byArray) {
        return Util.hexDump(byArray, 0, byArray.length);
    }

    public static String formatInt(int n, int n2, int n3) {
        String string = Integer.toString(n, n2);
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        for (int i = 0; i < n3 - string.length(); ++i) {
            cPStringBuilder.append("0");
        }
        cPStringBuilder.append(string);
        return cPStringBuilder.toString();
    }

    public static byte[] concat(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static byte[] trim(byte[] byArray, int n) {
        return Util.trim(byArray, 0, n);
    }

    public static byte[] trim(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n > byArray.length) {
            throw new IndexOutOfBoundsException("max=" + byArray.length + " off=" + n + " len=" + n2);
        }
        if (n == 0 && n2 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, Math.min(n2, byArray.length - n));
        return byArray2;
    }

    public static byte[] trim(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0 && !bigInteger.equals(BigInteger.ZERO)) {
            return Util.trim(byArray, 1, byArray.length - 1);
        }
        return byArray;
    }

    public static int unixTime() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    static Object[] transform(Object[] objectArray, Class clazz, String string, Object[] objectArray2) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        int n;
        if (objectArray2 == null) {
            objectArray2 = new Object[]{};
        }
        Object[] objectArray3 = (Object[])Array.newInstance(clazz, objectArray.length);
        Class[] classArray = new Class[objectArray2.length];
        for (n = 0; n < objectArray2.length; ++n) {
            classArray[n] = objectArray2[n].getClass();
        }
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n] == null) {
                objectArray3[n] = null;
                continue;
            }
            Class<? extends Object> clazz2 = objectArray[n].getClass();
            Method method = clazz2.getMethod(string, classArray);
            Object object = method.invoke(objectArray[n], objectArray2);
            if (!clazz.isAssignableFrom(object.getClass())) {
                throw new ClassCastException();
            }
            objectArray3[n] = object;
        }
        return objectArray3;
    }

    @Deprecated
    static String getProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    @Deprecated
    static String getSecurityProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty(string);
            }
        });
    }

    private static class WrappedBuffer {
        private final ByteBuffer buffer;
        private final String prefix;

        WrappedBuffer(ByteBuffer byteBuffer, String string) {
            this.buffer = byteBuffer;
            this.prefix = string;
        }

        public String toString() {
            return Util.hexDump(this.buffer, this.prefix);
        }
    }
}

