/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.Extension;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrustedAuthorities
extends Extension.Value
implements Iterable<TrustedAuthority> {
    private final ByteBuffer buffer;

    public TrustedAuthorities(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer.duplicate().order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public int length() {
        return 2 + (this.buffer.getShort(0) & 0xFFFF);
    }

    @Override
    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().limit(this.length());
    }

    public int size() {
        int n = this.buffer.getShort(0) & 0xFFFF;
        int n2 = 0;
        for (int i = 2; i < n; ++i) {
            TrustedAuthority trustedAuthority = new TrustedAuthority((ByteBuffer)this.buffer.duplicate().position(i));
            i += trustedAuthority.length();
            ++n2;
        }
        return n2;
    }

    public TrustedAuthority get(int n) {
        TrustedAuthority trustedAuthority;
        int n2 = this.buffer.getShort(0) & 0xFFFF;
        int n3 = 0;
        for (int i = 2; i < n2 && n3 <= n; i += trustedAuthority.length(), ++n3) {
            trustedAuthority = new TrustedAuthority((ByteBuffer)this.buffer.duplicate().position(i));
            if (n3 != n) continue;
            return trustedAuthority;
        }
        throw new IndexOutOfBoundsException();
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("struct {");
        String string2 = "  ";
        if (string != null) {
            string2 = string + string2;
        }
        for (TrustedAuthority trustedAuthority : this) {
            printWriter.println(trustedAuthority);
        }
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("} TrustedAuthorities;");
        return stringWriter.toString();
    }

    @Override
    public Iterator<TrustedAuthority> iterator() {
        return new AuthoritiesIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IdentifierType {
        PRE_AGREED(0),
        KEY_SHA1_HASH(1),
        X509_NAME(2),
        CERT_SHA1_HASH(3);

        private final int value;

        private IdentifierType(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class TrustedAuthority
    implements Constructed {
        private final ByteBuffer buffer;

        public TrustedAuthority(ByteBuffer byteBuffer) {
            this.buffer = byteBuffer;
        }

        public int length() {
            switch (this.type().getValue()) {
                case 0: {
                    return 1;
                }
                case 1: 
                case 3: {
                    return 21;
                }
                case 2: {
                    return 3 + (this.buffer.getShort(1) & 0xFFFF);
                }
            }
            throw new IllegalArgumentException("unknown authority type");
        }

        public byte[] sha1Hash() {
            IdentifierType identifierType = this.type();
            if (identifierType != IdentifierType.CERT_SHA1_HASH && identifierType != IdentifierType.KEY_SHA1_HASH) {
                throw new IllegalArgumentException((Object)((Object)identifierType) + " does not have a hash value");
            }
            byte[] byArray = new byte[20];
            ((ByteBuffer)this.buffer.duplicate().position(1)).get(byArray);
            return byArray;
        }

        public X500Principal name() {
            int n = this.buffer.getShort(1) & 0xFFFF;
            byte[] byArray = new byte[n];
            ((ByteBuffer)this.buffer.duplicate().position(3)).get(byArray);
            return new X500Principal(byArray);
        }

        public IdentifierType type() {
            switch (this.buffer.get(0)) {
                case 0: {
                    return IdentifierType.PRE_AGREED;
                }
                case 1: {
                    return IdentifierType.KEY_SHA1_HASH;
                }
                case 2: {
                    return IdentifierType.X509_NAME;
                }
                case 3: {
                    return IdentifierType.CERT_SHA1_HASH;
                }
            }
            throw new IllegalArgumentException("invalid IdentifierType");
        }

        public String toString() {
            return this.toString(null);
        }

        public String toString(String string) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.println("struct {");
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.print("  identifier_type = ");
            printWriter.print((Object)this.type());
            printWriter.println(";");
            switch (this.type().getValue()) {
                case 0: {
                    break;
                }
                case 1: 
                case 3: {
                    if (string != null) {
                        printWriter.print(string);
                    }
                    printWriter.print("  sha1_hash = ");
                    printWriter.print(Util.toHexString(this.sha1Hash(), ':'));
                    printWriter.println(";");
                    break;
                }
                case 2: {
                    if (string != null) {
                        printWriter.print(string);
                    }
                    printWriter.print("  name = ");
                    printWriter.print(this.name());
                    printWriter.println(";");
                }
            }
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.print("} TrustedAuthority;");
            return stringWriter.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AuthoritiesIterator
    implements Iterator<TrustedAuthority> {
        private int index = 0;

        @Override
        public TrustedAuthority next() throws NoSuchElementException {
            try {
                return TrustedAuthorities.this.get(this.index++);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < TrustedAuthorities.this.size();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

