/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.java.security.hash.IMessageDigest;
import gnu.javax.crypto.mac.HMac;
import java.security.InvalidKeyException;
import java.util.Map;

class TLSHMac
extends HMac {
    private static final byte IPAD_BYTE = 54;
    private static final byte OPAD_BYTE = 92;

    TLSHMac(IMessageDigest iMessageDigest) {
        super(iMessageDigest);
    }

    public void init(Map map) throws InvalidKeyException, IllegalStateException {
        int n;
        Integer n2 = (Integer)map.get("gnu.crypto.mac.truncated.size");
        int n3 = this.truncatedSize = n2 == null ? this.macSize : n2;
        if (this.truncatedSize < this.macSize / 2) {
            throw new IllegalArgumentException("Truncated size too small");
        }
        if (this.truncatedSize < 10) {
            throw new IllegalArgumentException("Truncated size less than 80 bits");
        }
        byte[] byArray = (byte[])map.get("gnu.crypto.mac.key.material");
        if (byArray == null) {
            if (this.ipadHash == null) {
                throw new InvalidKeyException("Null key");
            }
            this.underlyingHash = (IMessageDigest)this.ipadHash.clone();
            return;
        }
        if (byArray.length > this.blockSize) {
            this.underlyingHash.update(byArray, 0, byArray.length);
            byArray = this.underlyingHash.digest();
        }
        if (byArray.length < this.blockSize) {
            n = byArray.length > this.blockSize ? this.blockSize : byArray.length;
            byte[] byArray2 = new byte[this.blockSize];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            byArray = byArray2;
        }
        this.underlyingHash.reset();
        this.opadHash = (IMessageDigest)this.underlyingHash.clone();
        if (this.ipad == null) {
            this.ipad = new byte[this.blockSize];
        }
        for (n = 0; n < this.blockSize; ++n) {
            this.ipad[n] = (byte)(byArray[n] ^ 0x36);
        }
        for (n = 0; n < this.blockSize; ++n) {
            this.opadHash.update((byte)(byArray[n] ^ 0x5C));
        }
        this.underlyingHash.update(this.ipad, 0, this.blockSize);
        this.ipadHash = (IMessageDigest)this.underlyingHash.clone();
        byArray = null;
    }
}

