/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.KeyExchangeAlgorithm;
import gnu.javax.net.ssl.provider.ServerKeyExchangeParams;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public class ServerPSKParameters
implements Builder,
Constructed,
ServerKeyExchangeParams {
    private ByteBuffer buffer;

    public ServerPSKParameters(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer.duplicate().order(ByteOrder.BIG_ENDIAN);
    }

    public ServerPSKParameters(String string) {
        Charset charset = Charset.forName("UTF-8");
        ByteBuffer byteBuffer = charset.encode(string);
        this.buffer = ByteBuffer.allocate(2 + byteBuffer.remaining());
        this.buffer.putShort((short)byteBuffer.remaining());
        this.buffer.put(byteBuffer);
        this.buffer.rewind();
    }

    public KeyExchangeAlgorithm algorithm() {
        return KeyExchangeAlgorithm.PSK;
    }

    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().rewind().limit(this.length());
    }

    public int length() {
        return (this.buffer.getShort(0) & 0xFFFF) + 2;
    }

    public String identityHint() {
        Charset charset = Charset.forName("UTF-8");
        return charset.decode((ByteBuffer)this.buffer.duplicate().position(2).limit(this.length())).toString();
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("struct {");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("  identity_hint = ");
        printWriter.print(this.identityHint());
        printWriter.println(";");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("} ServerPSKParamaters;");
        return stringWriter.toString();
    }
}

