/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.Extension;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerNameList
extends Extension.Value
implements Iterable<ServerName> {
    private ByteBuffer buffer;

    public ServerNameList(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer.duplicate().order(ByteOrder.BIG_ENDIAN);
    }

    public ServerNameList(List<ServerName> list2) {
        int n = 2;
        for (ServerName serverName : list2) {
            n += serverName.length();
        }
        this.buffer = ByteBuffer.allocate(n);
        this.buffer.putShort((short)(n - 2));
        for (ServerName serverName : list2) {
            this.buffer.put(serverName.buffer());
        }
        this.buffer.rewind();
    }

    @Override
    public int length() {
        return (this.buffer.getShort(0) & 0xFFFF) + 2;
    }

    @Override
    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().limit(this.length());
    }

    public int size() {
        int n = 0;
        int n2 = this.length();
        int n3 = 2;
        while (n3 < n2) {
            short s = this.buffer.getShort(n3 + 1);
            n3 += s + 3;
            ++n;
        }
        return n;
    }

    public ServerName get(int n) {
        int n2;
        int n3 = this.length();
        if (n3 == 0) {
            throw new IndexOutOfBoundsException("0; " + n);
        }
        int n4 = 0;
        short s = this.buffer.getShort(3);
        for (n2 = 2; n2 < n3 && n4 < n; n2 += s + 3, ++n4) {
            s = this.buffer.getShort(n2 + 1);
        }
        if (n4 < n) {
            throw new IndexOutOfBoundsException(n4 + "; " + n);
        }
        ByteBuffer byteBuffer = ((ByteBuffer)this.buffer.duplicate().position(n2).limit(n2 + s + 3)).slice();
        return new ServerName(byteBuffer);
    }

    public void setLength(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("length must be between 0 and 65535");
        }
        this.buffer.putShort(0, (short)n);
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("ServerNameList {");
        String string2 = "  ";
        if (string != null) {
            string2 = string + string2;
        }
        for (ServerName serverName : this) {
            printWriter.println(serverName.toString(string2));
        }
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("};");
        return stringWriter.toString();
    }

    @Override
    public java.util.Iterator<ServerName> iterator() {
        return new Iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NameType {
        HOST_NAME(0);

        private final int value;

        private NameType(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class ServerName
    implements Constructed {
        private ByteBuffer buffer;

        public ServerName(ByteBuffer byteBuffer) {
            this.buffer = byteBuffer.duplicate().order(ByteOrder.BIG_ENDIAN);
        }

        public ServerName(NameType nameType, String string) {
            CharsetEncoder charsetEncoder = Charset.forName("UTF-8").newEncoder();
            ByteBuffer byteBuffer = null;
            try {
                byteBuffer = charsetEncoder.encode(CharBuffer.wrap(string));
            }
            catch (CharacterCodingException characterCodingException) {
                throw new IllegalArgumentException(characterCodingException);
            }
            int n = 3 + byteBuffer.remaining();
            this.buffer = ByteBuffer.allocate(n);
            this.buffer.put((byte)nameType.getValue());
            this.buffer.putShort((short)(n - 3));
            this.buffer.put(byteBuffer);
            this.buffer.rewind();
        }

        public int length() {
            return (this.buffer.getShort(1) & 0xFFFF) + 3;
        }

        public ByteBuffer buffer() {
            return (ByteBuffer)this.buffer.duplicate().limit(this.length());
        }

        public NameType type() {
            int n = this.buffer.get(0) & 0xFF;
            if (n == 0) {
                return NameType.HOST_NAME;
            }
            throw new IllegalArgumentException("illegal name type: " + n);
        }

        public String name() {
            int n = this.length();
            Charset charset = Charset.forName("UTF-8");
            return charset.decode((ByteBuffer)this.buffer.duplicate().position(3).limit(n)).toString();
        }

        public String toString() {
            return this.toString(null);
        }

        public String toString(String string) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.println("struct {");
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.print("  name_type = ");
            printWriter.print((Object)this.type());
            printWriter.println(";");
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.print("  server_name = ");
            printWriter.print(this.name());
            printWriter.println(";");
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.print("} ServerName;");
            return stringWriter.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Iterator
    implements java.util.Iterator<ServerName> {
        private int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < ServerNameList.this.size();
        }

        @Override
        public ServerName next() throws NoSuchElementException {
            try {
                return ServerNameList.this.get(this.index++);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

