/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.KeyExchangeAlgorithm;
import gnu.javax.net.ssl.provider.ServerKeyExchange;
import java.nio.ByteBuffer;

public class ServerKeyExchangeBuilder
extends ServerKeyExchange
implements Builder {
    public ServerKeyExchangeBuilder(CipherSuite cipherSuite) {
        super(ByteBuffer.allocate(1024), cipherSuite);
    }

    public ByteBuffer buffer() {
        return ((ByteBuffer)this.buffer.duplicate().position(0).limit(this.length())).slice();
    }

    public void setParams(ByteBuffer byteBuffer) {
        if (this.suite.keyExchangeAlgorithm() == KeyExchangeAlgorithm.NONE) {
            throw new IllegalArgumentException("key exchange algorithm is none");
        }
        this.ensureCapacity(byteBuffer.remaining());
        this.buffer.duplicate().put(byteBuffer);
    }

    public void setSignature(ByteBuffer byteBuffer) {
        if (this.suite.keyExchangeAlgorithm() == KeyExchangeAlgorithm.NONE) {
            throw new IllegalArgumentException("key exchange algorithm is none");
        }
        int n = this.params().length();
        this.ensureCapacity(n + byteBuffer.remaining());
        ((ByteBuffer)this.buffer.duplicate().position(n)).put(byteBuffer);
    }

    public void ensureCapacity(int n) {
        if (this.buffer.capacity() >= n) {
            return;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.duplicate().put(this.buffer);
        this.buffer = byteBuffer;
    }
}

