/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.CompressionMethod;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.ServerHello;
import java.nio.ByteBuffer;

public class ServerHelloBuilder
extends ServerHello
implements Builder {
    public ServerHelloBuilder() {
        super(ByteBuffer.allocate(70));
    }

    public ByteBuffer buffer() {
        return ((ByteBuffer)this.buffer.duplicate().position(0).limit(this.length())).slice();
    }

    public void setVersion(ProtocolVersion protocolVersion) {
        this.buffer.putShort(0, (short)protocolVersion.rawValue());
    }

    public void setSessionId(byte[] byArray) {
        this.setSessionId(byArray, 0, byArray.length);
    }

    public void setSessionId(byte[] byArray, int n, int n2) {
        if (n2 < 0 || n2 > 32) {
            throw new IllegalArgumentException("length must be between 0 and 32");
        }
        this.buffer.put(34, (byte)n2);
        ((ByteBuffer)this.buffer.duplicate().position(35)).put(byArray, n, n2);
    }

    public void setCipherSuite(CipherSuite cipherSuite) {
        int n = 34 + (this.buffer.get(34) & 0xFF) + 1;
        ((ByteBuffer)this.buffer.duplicate().position(n)).put(cipherSuite.id());
    }

    public void setCompressionMethod(CompressionMethod compressionMethod) {
        int n = 34 + (this.buffer.get(34) & 0xFF) + 3;
        this.buffer.put(n, (byte)compressionMethod.getValue());
    }

    public void setDisableExtensions(boolean bl) {
        this.disableExtensions = bl;
    }

    public void setExtensionsLength(int n) {
        if (n < 0 || n > 16384) {
            throw new IllegalArgumentException("length must be nonnegative and not exceed 16384");
        }
        int n2 = 35 + (this.buffer.get(34) & 0xFF) + 5 + n;
        if (this.buffer.capacity() < n2) {
            this.ensureCapacity(n2);
        }
        this.buffer.putShort(35 + (this.buffer.get(34) & 0xFF) + 3, (short)n);
    }

    public void setExtensions(ByteBuffer byteBuffer) {
        byteBuffer = (ByteBuffer)byteBuffer.duplicate().limit(byteBuffer.position() + this.extensionsLength());
        ((ByteBuffer)this.buffer.duplicate().position(35 + (this.buffer.get(34) & 0xFF))).put(byteBuffer);
    }

    public void ensureCapacity(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.put(this.buffer);
        byteBuffer.position(0);
        this.buffer = byteBuffer;
    }
}

