/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.SSLContextImpl;
import gnu.javax.net.ssl.provider.SSLEngineImpl;
import gnu.javax.net.ssl.provider.SSLSocketImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;

public class SSLSocketFactoryImpl
extends SSLSocketFactory {
    private final SSLContextImpl contextImpl;

    public SSLSocketFactoryImpl(SSLContextImpl sSLContextImpl) {
        this.contextImpl = sSLContextImpl;
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        return new SSLSocketImpl(this.contextImpl, string, n, socket, bl);
    }

    public String[] getDefaultCipherSuites() {
        return SSLEngineImpl.defaultSuites();
    }

    public String[] getSupportedCipherSuites() {
        return CipherSuite.availableSuiteNames().toArray(new String[0]);
    }

    public SSLSocketImpl createSocket(String string, int n) throws IOException, UnknownHostException {
        return this.createSocket(string, n, null, 0);
    }

    public SSLSocketImpl createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        SSLSocketImpl sSLSocketImpl = new SSLSocketImpl(this.contextImpl, string, n);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        sSLSocketImpl.bind(new InetSocketAddress(inetAddress, n2));
        sSLSocketImpl.connect(inetSocketAddress);
        return sSLSocketImpl;
    }

    public SSLSocketImpl createSocket(InetAddress inetAddress, int n) throws IOException {
        return this.createSocket(inetAddress, n, null, 0);
    }

    public SSLSocketImpl createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        SSLSocketImpl sSLSocketImpl = new SSLSocketImpl(this.contextImpl, inetAddress.getCanonicalHostName(), n);
        sSLSocketImpl.bind(new InetSocketAddress(inetAddress2, n2));
        sSLSocketImpl.connect(new InetSocketAddress(inetAddress, n));
        return sSLSocketImpl;
    }

    public Socket createSocket() throws IOException {
        return new SSLSocketImpl(this.contextImpl, null, -1, new Socket(), true);
    }
}

