/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.SSLContextImpl;
import gnu.javax.net.ssl.provider.SSLEngineImpl;
import gnu.javax.net.ssl.provider.SSLSocketImpl;
import java.io.IOException;
import javax.net.ssl.SSLServerSocket;

public class SSLServerSocketImpl
extends SSLServerSocket {
    private final SSLContextImpl contextImpl;
    private boolean enableSessionCreation;
    private String[] enabledCipherSuites;
    private String[] enabledProtocols;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private boolean clientMode;

    public SSLServerSocketImpl(SSLContextImpl sSLContextImpl) throws IOException {
        this.contextImpl = sSLContextImpl;
        this.enableSessionCreation = true;
        this.enabledCipherSuites = SSLEngineImpl.defaultSuites();
        this.enabledProtocols = new String[]{ProtocolVersion.SSL_3.toString(), ProtocolVersion.TLS_1.toString(), ProtocolVersion.TLS_1_1.toString()};
        this.needClientAuth = false;
        this.wantClientAuth = false;
        this.clientMode = false;
    }

    public boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public String[] getEnabledCipherSuites() {
        return (String[])this.enabledCipherSuites.clone();
    }

    public String[] getEnabledProtocols() {
        return (String[])this.enabledProtocols.clone();
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public String[] getSupportedCipherSuites() {
        return CipherSuite.availableSuiteNames().toArray(new String[0]);
    }

    public String[] getSupportedProtocols() {
        return new String[]{ProtocolVersion.SSL_3.toString(), ProtocolVersion.TLS_1.toString(), ProtocolVersion.TLS_1_1.toString()};
    }

    public boolean getUseClientMode() {
        return this.clientMode;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.enabledCipherSuites = (String[])stringArray.clone();
    }

    public void setEnabledProtocols(String[] stringArray) {
        this.enabledProtocols = (String[])stringArray.clone();
    }

    public void setNeedClientAuth(boolean bl) {
        this.needClientAuth = bl;
    }

    public void setUseClientMode(boolean bl) {
        this.clientMode = bl;
    }

    public void setWantClientAuth(boolean bl) {
        this.wantClientAuth = bl;
    }

    public SSLSocketImpl accept() throws IOException {
        SSLSocketImpl sSLSocketImpl = new SSLSocketImpl(this.contextImpl, null, -1);
        this.implAccept(sSLSocketImpl);
        sSLSocketImpl.setEnableSessionCreation(this.enableSessionCreation);
        sSLSocketImpl.setEnabledCipherSuites(this.enabledCipherSuites);
        sSLSocketImpl.setEnabledProtocols(this.enabledProtocols);
        sSLSocketImpl.setNeedClientAuth(this.needClientAuth);
        sSLSocketImpl.setUseClientMode(this.clientMode);
        sSLSocketImpl.setWantClientAuth(this.wantClientAuth);
        return sSLSocketImpl;
    }
}

