/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.SSLContextImpl;
import gnu.javax.net.ssl.provider.SSLEngineImpl;
import gnu.javax.net.ssl.provider.SSLServerSocketImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLServerSocketFactory;

public class SSLServerSocketFactoryImpl
extends SSLServerSocketFactory {
    private final SSLContextImpl contextImpl;

    public SSLServerSocketFactoryImpl(SSLContextImpl sSLContextImpl) {
        this.contextImpl = sSLContextImpl;
    }

    public String[] getDefaultCipherSuites() {
        return SSLEngineImpl.defaultSuites();
    }

    public String[] getSupportedCipherSuites() {
        return CipherSuite.availableSuiteNames().toArray(new String[0]);
    }

    public SSLServerSocketImpl createServerSocket(int n) throws IOException {
        SSLServerSocketImpl sSLServerSocketImpl = new SSLServerSocketImpl(this.contextImpl);
        sSLServerSocketImpl.bind(new InetSocketAddress(n));
        return sSLServerSocketImpl;
    }

    public SSLServerSocketImpl createServerSocket(int n, int n2) throws IOException {
        SSLServerSocketImpl sSLServerSocketImpl = new SSLServerSocketImpl(this.contextImpl);
        sSLServerSocketImpl.bind(new InetSocketAddress(n), n2);
        return sSLServerSocketImpl;
    }

    public SSLServerSocketImpl createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        SSLServerSocketImpl sSLServerSocketImpl = new SSLServerSocketImpl(this.contextImpl);
        sSLServerSocketImpl.bind(new InetSocketAddress(inetAddress, n), n2);
        return sSLServerSocketImpl;
    }
}

