/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.java.security.sig.rsa.RSA;
import gnu.javax.net.ssl.provider.Util;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.logging.Level;

public class SSLRSASignatureImpl
extends SignatureSpi {
    private static final SystemLogger logger = SystemLogger.SYSTEM;
    private RSAPublicKey pubkey;
    private RSAPrivateKey privkey;
    private final MessageDigest md5 = MessageDigest.getInstance("MD5");
    private final MessageDigest sha = MessageDigest.getInstance("SHA-1");
    private boolean initSign = false;
    private boolean initVerify = false;

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        try {
            this.pubkey = (RSAPublicKey)publicKey;
            this.initVerify = true;
            this.initSign = false;
            this.privkey = null;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidKeyException(classCastException);
        }
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        try {
            this.privkey = (RSAPrivateKey)privateKey;
            this.initSign = true;
            this.initVerify = false;
            this.pubkey = null;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidKeyException(classCastException);
        }
    }

    protected void engineUpdate(byte by) throws SignatureException {
        if (!this.initSign && !this.initVerify) {
            throw new IllegalStateException("not initialized");
        }
        logger.log((Level)Component.SSL_HANDSHAKE, "SSL/RSA update 0x{0}", Util.formatInt(by & 0xFF, 16, 2));
        this.md5.update(by);
        this.sha.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        if (!this.initSign && !this.initVerify) {
            throw new IllegalStateException("not initialized");
        }
        logger.log((Level)Component.SSL_HANDSHAKE, "SSL/RSA update\n{0}", Util.hexDump(byArray, n, n2, ">> "));
        this.md5.update(byArray, n, n2);
        this.sha.update(byArray, n, n2);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] byArray;
        if (!this.initSign) {
            throw new SignatureException("not initialized for signing");
        }
        int n = this.privkey.getModulus().bitLength() + 7 >>> 3;
        if (n - 11 < (byArray = Util.concat(this.md5.digest(), this.sha.digest())).length) {
            throw new SignatureException("message too long");
        }
        byte[] byArray2 = new byte[n];
        byArray2[0] = 0;
        byArray2[1] = 1;
        for (int i = 2; i < n - byArray.length - 1; ++i) {
            byArray2[i] = -1;
        }
        System.arraycopy(byArray, 0, byArray2, n - byArray.length, byArray.length);
        BigInteger bigInteger = new BigInteger(byArray2);
        BigInteger bigInteger2 = RSA.sign(this.privkey, bigInteger);
        return Util.trim(bigInteger2);
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (!this.initVerify) {
            throw new SignatureException("not initialized for verifying");
        }
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = RSA.verify(this.pubkey, bigInteger);
        int n = 0;
        byte[] byArray2 = bigInteger2.toByteArray();
        if (byArray2[0] == 0) {
            for (n = 0; n < byArray2.length && byArray2[n] == 0; ++n) {
            }
        } else if (byArray2[0] == 1) {
            for (n = 1; n < byArray2.length && byArray2[n] != 0; ++n) {
                if (byArray2[n] == -1) continue;
                throw new SignatureException("bad padding");
            }
            ++n;
        } else {
            throw new SignatureException("decryption failed");
        }
        byte[] byArray3 = Util.trim(byArray2, n, byArray2.length - n);
        byte[] byArray4 = Util.concat(this.md5.digest(), this.sha.digest());
        logger.logv(Component.SSL_HANDSHAKE, "SSL/RSA d1:{0} d2:{1}", Util.toHexString(byArray3, ':'), Util.toHexString(byArray4, ':'));
        return Arrays.equals(byArray3, byArray4);
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("parameters not supported");
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("parameters not supported");
    }
}

