/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.java.security.util.ByteBufferOutputStream;
import gnu.javax.net.ssl.SSLRecordHandler;
import gnu.javax.net.ssl.Session;
import gnu.javax.net.ssl.provider.AbstractHandshake;
import gnu.javax.net.ssl.provider.Alert;
import gnu.javax.net.ssl.provider.AlertException;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ClientHandshake;
import gnu.javax.net.ssl.provider.ClientHelloBuilder;
import gnu.javax.net.ssl.provider.ClientHelloV2;
import gnu.javax.net.ssl.provider.CompressionMethod;
import gnu.javax.net.ssl.provider.ContentType;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.InputSecurityParameters;
import gnu.javax.net.ssl.provider.MacException;
import gnu.javax.net.ssl.provider.OutputSecurityParameters;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Random;
import gnu.javax.net.ssl.provider.Record;
import gnu.javax.net.ssl.provider.SSLContextImpl;
import gnu.javax.net.ssl.provider.ServerHandshake;
import gnu.javax.net.ssl.provider.SessionImpl;
import gnu.javax.net.ssl.provider.Util;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.DataFormatException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public final class SSLEngineImpl
extends SSLEngine {
    final SSLContextImpl contextImpl;
    private SSLRecordHandler[] handlers;
    private static final SystemLogger logger = SystemLogger.SYSTEM;
    private SessionImpl session;
    private InputSecurityParameters insec;
    private OutputSecurityParameters outsec;
    private boolean inClosed;
    private boolean outClosed;
    private boolean createSessions;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private boolean initialHandshakeDone;
    private AbstractHandshake handshake;
    private Alert lastAlert;
    private SSLEngineResult.HandshakeStatus handshakeStatus;
    private boolean changeCipherSpec;
    private String[] enabledSuites;
    private String[] enabledProtocols;
    private final ByteBuffer alertBuffer;
    private Mode mode;

    SSLEngineImpl(SSLContextImpl sSLContextImpl, String string, int n) {
        super(string, n);
        this.contextImpl = sSLContextImpl;
        this.handlers = new SSLRecordHandler[256];
        this.session = new SessionImpl();
        this.session.suite = CipherSuite.TLS_NULL_WITH_NULL_NULL;
        this.session.version = ProtocolVersion.TLS_1_1;
        byte[] byArray = new byte[32];
        sSLContextImpl.random.nextBytes(byArray);
        this.session.setId(new Session.ID(byArray));
        this.session.setRandom(sSLContextImpl.random);
        logger.logv(Component.SSL_RECORD_LAYER, "generated session ID {0} with random {1}", this.session.id(), sSLContextImpl.random);
        this.insec = new InputSecurityParameters(null, null, null, this.session, CipherSuite.TLS_NULL_WITH_NULL_NULL);
        this.outsec = new OutputSecurityParameters(null, null, null, this.session, CipherSuite.TLS_NULL_WITH_NULL_NULL);
        this.inClosed = false;
        this.outClosed = false;
        this.needClientAuth = false;
        this.wantClientAuth = false;
        this.createSessions = true;
        this.initialHandshakeDone = false;
        this.alertBuffer = ByteBuffer.wrap(new byte[2]);
        this.mode = null;
        this.lastAlert = null;
        this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        this.changeCipherSpec = false;
        this.enabledProtocols = new String[]{ProtocolVersion.TLS_1_1.toString(), ProtocolVersion.TLS_1.toString(), ProtocolVersion.SSL_3.toString()};
        this.enabledSuites = SSLEngineImpl.defaultSuites();
    }

    static String[] defaultSuites() {
        return new String[]{CipherSuite.TLS_DHE_DSS_WITH_AES_256_CBC_SHA.toString(), CipherSuite.TLS_DHE_RSA_WITH_AES_256_CBC_SHA.toString(), CipherSuite.TLS_DH_DSS_WITH_AES_256_CBC_SHA.toString(), CipherSuite.TLS_DH_RSA_WITH_AES_256_CBC_SHA.toString(), CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA.toString(), CipherSuite.TLS_DHE_DSS_WITH_AES_128_CBC_SHA.toString(), CipherSuite.TLS_DHE_RSA_WITH_AES_128_CBC_SHA.toString(), CipherSuite.TLS_DH_DSS_WITH_AES_128_CBC_SHA.toString(), CipherSuite.TLS_DH_RSA_WITH_AES_128_CBC_SHA.toString(), CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA.toString(), CipherSuite.TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA.toString(), CipherSuite.TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA.toString(), CipherSuite.TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA.toString(), CipherSuite.TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA.toString(), CipherSuite.TLS_RSA_WITH_3DES_EDE_CBC_SHA.toString(), CipherSuite.TLS_RSA_WITH_RC4_128_MD5.toString(), CipherSuite.TLS_RSA_WITH_RC4_128_SHA.toString(), CipherSuite.TLS_DHE_DSS_WITH_DES_CBC_SHA.toString(), CipherSuite.TLS_DHE_RSA_WITH_DES_CBC_SHA.toString(), CipherSuite.TLS_DH_DSS_WITH_DES_CBC_SHA.toString(), CipherSuite.TLS_DH_RSA_WITH_DES_CBC_SHA.toString(), CipherSuite.TLS_RSA_WITH_DES_CBC_SHA.toString(), CipherSuite.TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA.toString(), CipherSuite.TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA.toString(), CipherSuite.TLS_RSA_EXPORT_WITH_DES40_CBC_SHA.toString(), CipherSuite.TLS_RSA_EXPORT_WITH_RC4_40_MD5.toString(), CipherSuite.TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA.toString(), CipherSuite.TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA.toString(), CipherSuite.TLS_RSA_WITH_NULL_MD5.toString(), CipherSuite.TLS_RSA_WITH_NULL_SHA.toString()};
    }

    public void beginHandshake() throws SSLException {
        logger.log((Level)Component.SSL_HANDSHAKE, "{0} handshake begins", (Object)this.mode);
        if (this.mode == null) {
            throw new IllegalStateException("setUseClientMode was never used");
        }
        switch (this.mode) {
            case SERVER: {
                if (this.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    throw new SSLException("handshake already in progress");
                }
                try {
                    this.handshake = new ServerHandshake(this.initialHandshakeDone, this);
                    break;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new SSLException(noSuchAlgorithmException);
                }
            }
            case CLIENT: {
                try {
                    this.handshake = new ClientHandshake(this);
                    break;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new SSLException(noSuchAlgorithmException);
                }
            }
        }
    }

    public void closeInbound() {
        this.inClosed = true;
    }

    public void closeOutbound() {
        this.lastAlert = new Alert(Alert.Level.WARNING, Alert.Description.CLOSE_NOTIFY);
    }

    public Runnable getDelegatedTask() {
        if (this.handshake == null) {
            return null;
        }
        return this.handshake.getTask();
    }

    public String[] getEnabledCipherSuites() {
        return (String[])this.enabledSuites.clone();
    }

    public String[] getEnabledProtocols() {
        return (String[])this.enabledProtocols.clone();
    }

    public boolean getEnableSessionCreation() {
        return this.createSessions;
    }

    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        if (this.handshake == null) {
            return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }
        return this.handshake.status();
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public SSLSession getSession() {
        return this.session;
    }

    public boolean getUseClientMode() {
        return this.mode == Mode.CLIENT;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public boolean isInboundDone() {
        return this.inClosed;
    }

    public boolean isOutboundDone() {
        return this.outClosed;
    }

    public void setEnableSessionCreation(boolean bl) {
        this.createSessions = bl;
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("need at least one suite");
        }
        this.enabledSuites = (String[])stringArray.clone();
    }

    public void setEnabledProtocols(String[] stringArray) {
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("need at least one protocol");
        }
        this.enabledProtocols = (String[])stringArray.clone();
    }

    public String[] getSupportedCipherSuites() {
        return CipherSuite.availableSuiteNames().toArray(new String[0]);
    }

    public String[] getSupportedProtocols() {
        return new String[]{ProtocolVersion.SSL_3.toString(), ProtocolVersion.TLS_1.toString(), ProtocolVersion.TLS_1_1.toString()};
    }

    public void setNeedClientAuth(boolean bl) {
        this.needClientAuth = bl;
    }

    public void setUseClientMode(boolean bl) {
        this.mode = bl ? Mode.CLIENT : Mode.SERVER;
    }

    public void setWantClientAuth(boolean bl) {
        this.wantClientAuth = bl;
    }

    public SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, int n, int n2) throws SSLException {
        Object[] objectArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.mode == null) {
            throw new IllegalStateException("setUseClientMode was never called");
        }
        if (this.inClosed) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, this.handshakeStatus, 0, 0);
        }
        if (byteBuffer.remaining() < 5) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, this.handshakeStatus, 0, 0);
        }
        Record record = null;
        boolean bl = false;
        if (!this.getUseClientMode() && (byteBuffer.get(byteBuffer.position()) & 0x80) == 128) {
            if (this.handshake == null) {
                this.beginHandshake();
            }
            int n3 = byteBuffer.getShort(byteBuffer.position()) & Short.MAX_VALUE;
            this.handshake.handleV2Hello(byteBuffer.slice());
            if (!this.insec.cipherSuite().equals(CipherSuite.TLS_NULL_WITH_NULL_NULL)) {
                throw new SSLException("received SSLv2 client hello in encrypted session; this is invalid.");
            }
            logger.log(Component.SSL_RECORD_LAYER, "converting SSLv2 client hello to version 3 hello");
            byteBuffer.getShort();
            object4 = new ClientHelloV2(byteBuffer.slice());
            logger.log((Level)Component.SSL_RECORD_LAYER, "v2 hello: {0}", object4);
            object3 = ((ClientHelloV2)object4).cipherSpecs();
            ClientHelloBuilder clientHelloBuilder = new ClientHelloBuilder();
            clientHelloBuilder.setVersion(((ClientHelloV2)object4).version());
            object2 = clientHelloBuilder.random();
            object = ((ClientHelloV2)object4).challenge();
            if (((byte[])object).length < 32) {
                objectArray = new byte[32];
                System.arraycopy(object, 0, objectArray, objectArray.length - ((byte[])object).length, ((byte[])object).length);
                object = objectArray;
            }
            ((Random)object2).setGmtUnixTime((object[0] & 0xFF) << 24 | (object[1] & 0xFF) << 16 | (object[2] & 0xFF) << 8 | object[3] & 0xFF);
            ((Random)object2).setRandomBytes((byte[])object, 4);
            objectArray = ((ClientHelloV2)object4).sessionId();
            clientHelloBuilder.setSessionId((byte[])objectArray, 0, objectArray.length);
            clientHelloBuilder.setCipherSuites((List<CipherSuite>)object3);
            ArrayList<CompressionMethod> arrayList = new ArrayList<CompressionMethod>(1);
            arrayList.add(CompressionMethod.NULL);
            clientHelloBuilder.setCompressionMethods(arrayList);
            record = new Record(ByteBuffer.allocate(clientHelloBuilder.length() + 9));
            record.setContentType(ContentType.HANDSHAKE);
            record.setVersion(((ClientHelloV2)object4).version());
            record.setLength(clientHelloBuilder.length() + 4);
            Handshake handshake = new Handshake(record.fragment());
            handshake.setLength(clientHelloBuilder.length());
            handshake.setType(Handshake.Type.CLIENT_HELLO);
            handshake.bodyBuffer().put(clientHelloBuilder.buffer());
            byteBuffer.position(byteBuffer.position() + n3);
            bl = true;
        } else {
            record = new Record(byteBuffer);
        }
        ContentType contentType = record.contentType();
        logger.log((Level)Component.SSL_RECORD_LAYER, "input record:\n{0}", record);
        if (record.length() > this.session.getPacketBufferSize() - 5) {
            this.lastAlert = new Alert(Alert.Level.FATAL, Alert.Description.RECORD_OVERFLOW);
            throw new AlertException(this.lastAlert);
        }
        object4 = null;
        object3 = null;
        int n4 = 0;
        try {
            if (record.contentType() == ContentType.APPLICATION_DATA) {
                n4 = this.insec.decrypt(record, byteBufferArray, n, n2);
            } else if (this.insec.cipherSuite() == CipherSuite.TLS_NULL_WITH_NULL_NULL) {
                object3 = record.fragment();
            } else {
                object4 = new ByteBufferOutputStream();
                this.insec.decrypt(record, (ByteBufferOutputStream)object4);
            }
            if (!bl) {
                byteBuffer.position(byteBuffer.position() + record.length() + 5);
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            logger.log((Level)Component.SSL_RECORD_LAYER, "buffer overflow when decrypting", bufferOverflowException);
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.handshakeStatus, 0, 0);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            this.lastAlert = new Alert(Alert.Level.FATAL, Alert.Description.BAD_RECORD_MAC);
            throw new AlertException(this.lastAlert, (Throwable)illegalBlockSizeException);
        }
        catch (DataFormatException dataFormatException) {
            this.lastAlert = new Alert(Alert.Level.FATAL, Alert.Description.DECOMPRESSION_FAILURE);
            throw new AlertException(this.lastAlert, (Throwable)dataFormatException);
        }
        catch (MacException macException) {
            this.lastAlert = new Alert(Alert.Level.FATAL, Alert.Description.BAD_RECORD_MAC);
            throw new AlertException(this.lastAlert, (Throwable)macException);
        }
        catch (ShortBufferException shortBufferException) {
            this.lastAlert = new Alert(Alert.Level.FATAL, Alert.Description.INTERNAL_ERROR);
            throw new AlertException(this.lastAlert, (Throwable)shortBufferException);
        }
        object2 = null;
        if (object4 != null) {
            logger.logv(Component.SSL_RECORD_LAYER, "sysmessage {0}", object4);
            object3 = ((ByteBufferOutputStream)object4).buffer();
        }
        if (contentType == ContentType.CHANGE_CIPHER_SPEC) {
            if (((Buffer)object3).remaining() == 0) {
                object2 = new SSLEngineResult(SSLEngineResult.Status.OK, this.handshakeStatus, record.length() + 5, 0);
            } else {
                byte by = ((ByteBuffer)object3).get();
                if (by != 1) {
                    throw new SSLException("unknown ChangeCipherSpec value: " + (by & 0xFF));
                }
                objectArray = this.handshake.getInputParams();
                logger.log((Level)Component.SSL_RECORD_LAYER, "switching to input security parameters {0}", objectArray.cipherSuite());
                this.insec = objectArray;
                object2 = new SSLEngineResult(SSLEngineResult.Status.OK, this.handshakeStatus, record.length() + 5, 0);
            }
        } else if (contentType == ContentType.ALERT) {
            int n5 = 0;
            if (this.alertBuffer.position() > 0) {
                this.alertBuffer.put(((ByteBuffer)object3).get());
                n5 = 1;
            }
            logger.logv(Component.SSL_RECORD_LAYER, "processing alerts {0}", Util.wrapBuffer((ByteBuffer)object3));
            objectArray = new Alert[n5 += ((Buffer)object3).remaining() / 2];
            int n6 = 0;
            if (this.alertBuffer.position() > 0) {
                this.alertBuffer.flip();
                objectArray[0] = new Alert(this.alertBuffer);
                ++n6;
            }
            while (n6 < objectArray.length) {
                objectArray[n6++] = new Alert(((ByteBuffer)object3).duplicate());
                ((Buffer)object3).position(((Buffer)object3).position() + 2);
            }
            logger.logv(Component.SSL_RECORD_LAYER, "alerts: {0}", objectArray.length);
            for (n6 = 0; n6 < objectArray.length; ++n6) {
                if (objectArray[n6].level() == Alert.Level.FATAL) {
                    throw new AlertException(objectArray[n6], false);
                }
                if (objectArray[n6].description() != Alert.Description.CLOSE_NOTIFY) {
                    logger.log(Level.WARNING, "received alert: {0}", objectArray[n6]);
                }
                if (objectArray[n6].description() != Alert.Description.CLOSE_NOTIFY) continue;
                this.inClosed = true;
            }
            if (((Buffer)object3).hasRemaining()) {
                this.alertBuffer.position(0).limit(2);
            }
            object2 = new SSLEngineResult(SSLEngineResult.Status.OK, this.handshakeStatus, record.length() + 5, 0);
        } else if (contentType == ContentType.HANDSHAKE) {
            if (this.handshake == null) {
                this.beginHandshake();
            }
            try {
                this.handshakeStatus = this.handshake.handleInput((ByteBuffer)object3);
            }
            catch (AlertException alertException) {
                this.lastAlert = alertException.alert();
                return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
            }
            logger.logv(Component.SSL_HANDSHAKE, "handshake status {0}", new Object[]{this.handshakeStatus});
            object2 = new SSLEngineResult(SSLEngineResult.Status.OK, this.handshakeStatus, record.length() + 5, 0);
            if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
                this.handshake = null;
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            }
        } else if (contentType == ContentType.APPLICATION_DATA) {
            object2 = new SSLEngineResult(SSLEngineResult.Status.OK, this.handshakeStatus, record.length() + 5, n4);
        } else {
            object = this.handlers[contentType.getValue()];
            if (object != null) {
                object2 = new SSLEngineResult(SSLEngineResult.Status.OK, this.handshakeStatus, record.length() + 5, 0);
            } else {
                throw new SSLException("unknown content type: " + (Object)((Object)contentType));
            }
        }
        logger.logv(Component.SSL_RECORD_LAYER, "return result: {0}", object2);
        return object2;
    }

    public SSLEngineResult wrap(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer byteBuffer) throws SSLException {
        if (this.mode == null) {
            throw new IllegalStateException("setUseClientMode was never called");
        }
        if (this.outClosed) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, this.handshakeStatus, 0, 0);
        }
        ContentType contentType = null;
        ByteBuffer byteBuffer2 = null;
        logger.logv(Component.SSL_RECORD_LAYER, "wrap {0} {1} {2} {3} / {4}", new Object[]{byteBufferArray, n, n2, byteBuffer, this.getHandshakeStatus()});
        if (this.lastAlert != null) {
            contentType = ContentType.ALERT;
            byteBuffer2 = ByteBuffer.allocate(2);
            Alert alert = new Alert(byteBuffer2);
            alert.setDescription(this.lastAlert.description());
            alert.setLevel(this.lastAlert.level());
            if (this.lastAlert.description() == Alert.Description.CLOSE_NOTIFY) {
                this.outClosed = true;
            }
        } else if (this.changeCipherSpec) {
            contentType = ContentType.CHANGE_CIPHER_SPEC;
            byteBuffer2 = ByteBuffer.allocate(1);
            byteBuffer2.put(0, (byte)1);
        } else if (this.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            if (this.outsec.suite() == CipherSuite.TLS_NULL_WITH_NULL_NULL) {
                int n3 = byteBuffer.position();
                byteBuffer.order(ByteOrder.BIG_ENDIAN);
                byteBuffer.put((byte)ContentType.HANDSHAKE.getValue());
                byteBuffer.putShort((short)this.session.version.rawValue());
                byteBuffer.putShort((short)0);
                this.handshakeStatus = this.handshake.handleOutput(byteBuffer);
                int n4 = byteBuffer.position() - n3;
                byteBuffer.putShort(n3 + 3, (short)(n4 - 5));
                logger.logv(Component.SSL_RECORD_LAYER, "emitting record:\n{0}", new Record((ByteBuffer)byteBuffer.duplicate().position(n3)));
                SSLEngineResult sSLEngineResult = new SSLEngineResult(SSLEngineResult.Status.OK, this.handshakeStatus, 0, n4);
                if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
                    this.handshake = null;
                    this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                }
                return sSLEngineResult;
            }
            byteBuffer2 = ByteBuffer.allocate(byteBuffer.remaining() - 2048);
            contentType = ContentType.HANDSHAKE;
            try {
                this.handshakeStatus = this.handshake.handleOutput(byteBuffer2);
            }
            catch (AlertException alertException) {
                this.lastAlert = alertException.alert();
                return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
            }
            byteBuffer2.flip();
            logger.logv(Component.SSL_HANDSHAKE, "handshake status {0}", new Object[]{this.handshakeStatus});
        }
        int n5 = 0;
        int n6 = 0;
        try {
            int n7 = byteBuffer.position();
            int[] nArray = null;
            if (byteBuffer2 != null) {
                logger.logv(Component.SSL_RECORD_LAYER, "encrypt system message {0} to {1}", byteBuffer2, byteBuffer);
                nArray = this.outsec.encrypt(new ByteBuffer[]{byteBuffer2}, 0, 1, contentType, byteBuffer);
                n5 = nArray[1];
            } else if (this.outsec.needToSplitPayload()) {
                nArray = this.outsec.encrypt(byteBufferArray, n, 1, ContentType.APPLICATION_DATA, byteBuffer);
                n6 = nArray[0];
                n5 = nArray[1];
                if (n2 > 1) {
                    nArray = this.outsec.encrypt(byteBufferArray, n + 1, n2 - 1, ContentType.APPLICATION_DATA, byteBuffer);
                    n6 += nArray[0];
                    n5 += nArray[1];
                }
            } else {
                nArray = this.outsec.encrypt(byteBufferArray, n, n2, ContentType.APPLICATION_DATA, byteBuffer);
                n6 = nArray[0];
                n5 = nArray[1];
            }
            logger.logv(Component.SSL_RECORD_LAYER, "emitting record:\n{0}", new Record((ByteBuffer)byteBuffer.duplicate().position(n7).limit(n5)));
        }
        catch (ShortBufferException shortBufferException) {
            this.lastAlert = new Alert(Alert.Level.FATAL, Alert.Description.INTERNAL_ERROR);
            return new SSLEngineResult(SSLEngineResult.Status.OK, this.handshakeStatus, 0, 0);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            this.lastAlert = new Alert(Alert.Level.FATAL, Alert.Description.INTERNAL_ERROR);
            return new SSLEngineResult(SSLEngineResult.Status.OK, this.handshakeStatus, 0, 0);
        }
        catch (DataFormatException dataFormatException) {
            this.lastAlert = new Alert(Alert.Level.FATAL, Alert.Description.INTERNAL_ERROR);
            return new SSLEngineResult(SSLEngineResult.Status.OK, this.handshakeStatus, 0, 0);
        }
        if (this.lastAlert != null && this.lastAlert.level() == Alert.Level.FATAL) {
            AlertException alertException = new AlertException(this.lastAlert);
            this.lastAlert = null;
            throw alertException;
        }
        if (this.changeCipherSpec) {
            this.outsec = this.handshake.getOutputParams();
            this.changeCipherSpec = false;
        }
        SSLEngineResult sSLEngineResult = new SSLEngineResult(this.outClosed ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK, this.handshakeStatus, n6, n5);
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.handshake = null;
            this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }
        return sSLEngineResult;
    }

    SessionImpl session() {
        return this.session;
    }

    void setSession(SessionImpl sessionImpl) {
        this.session = sessionImpl;
    }

    void changeCipherSpec() {
        this.changeCipherSpec = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        SERVER,
        CLIENT;

    }
}

