/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.java.security.action.GetSecurityPropertyAction;
import gnu.javax.net.ssl.AbstractSessionContext;
import gnu.javax.net.ssl.NullManagerParameters;
import gnu.javax.net.ssl.PreSharedKeyManager;
import gnu.javax.net.ssl.SRPTrustManager;
import gnu.javax.net.ssl.provider.SSLEngineImpl;
import gnu.javax.net.ssl.provider.SSLServerSocketFactoryImpl;
import gnu.javax.net.ssl.provider.SSLSocketFactoryImpl;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;

public final class SSLContextImpl
extends SSLContextSpi {
    AbstractSessionContext serverContext;
    AbstractSessionContext clientContext;
    PreSharedKeyManager pskManager;
    X509ExtendedKeyManager keyManager;
    X509TrustManager trustManager;
    SRPTrustManager srpTrustManager;
    SecureRandom random;

    protected SSLEngine engineCreateSSLEngine() {
        return this.engineCreateSSLEngine(null, -1);
    }

    protected SSLEngine engineCreateSSLEngine(String string, int n) {
        return new SSLEngineImpl(this, string, n);
    }

    protected synchronized SSLSessionContext engineGetClientSessionContext() {
        if (this.clientContext == null) {
            try {
                this.clientContext = AbstractSessionContext.newInstance();
            }
            catch (SSLException sSLException) {
                // empty catch block
            }
        }
        return this.clientContext;
    }

    protected synchronized SSLSessionContext engineGetServerSessionContext() {
        if (this.serverContext == null) {
            try {
                this.serverContext = AbstractSessionContext.newInstance();
            }
            catch (SSLException sSLException) {
                // empty catch block
            }
        }
        return this.serverContext;
    }

    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        return new SSLServerSocketFactoryImpl(this);
    }

    protected SSLSocketFactory engineGetSocketFactory() {
        return new SSLSocketFactoryImpl(this);
    }

    protected void engineInit(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
        int n;
        this.keyManager = null;
        this.trustManager = null;
        this.srpTrustManager = null;
        if (keyManagerArray != null) {
            for (n = 0; n < keyManagerArray.length; ++n) {
                if (keyManagerArray[n] instanceof X509ExtendedKeyManager && this.keyManager == null) {
                    this.keyManager = (X509ExtendedKeyManager)keyManagerArray[n];
                }
                if (!(keyManagerArray[n] instanceof PreSharedKeyManager) || this.pskManager != null) continue;
                this.pskManager = (PreSharedKeyManager)keyManagerArray[n];
            }
        }
        if (this.keyManager == null) {
            this.keyManager = this.defaultKeyManager();
        }
        if (trustManagerArray != null) {
            for (n = 0; n < trustManagerArray.length; ++n) {
                if (trustManagerArray[n] instanceof X509TrustManager) {
                    if (this.trustManager != null) continue;
                    this.trustManager = (X509TrustManager)trustManagerArray[n];
                    continue;
                }
                if (!(trustManagerArray[n] instanceof SRPTrustManager) || this.srpTrustManager != null) continue;
                this.srpTrustManager = (SRPTrustManager)trustManagerArray[n];
            }
        }
        if (this.trustManager == null && this.srpTrustManager == null) {
            this.trustManager = this.defaultTrustManager();
        }
        this.random = secureRandom != null ? secureRandom : this.defaultRandom();
    }

    private X509ExtendedKeyManager defaultKeyManager() throws KeyManagementException {
        KeyManagerFactory keyManagerFactory = null;
        try {
            keyManagerFactory = KeyManagerFactory.getInstance("JessieX509", "Jessie");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagementException(noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyManagementException(noSuchProviderException);
        }
        try {
            keyManagerFactory.init(null, null);
            return (X509ExtendedKeyManager)keyManagerFactory.getKeyManagers()[0];
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            keyManagerFactory.init(new NullManagerParameters());
            return (X509ExtendedKeyManager)keyManagerFactory.getKeyManagers()[0];
        }
        catch (Exception exception) {
            throw new Error(exception.toString());
        }
    }

    private X509TrustManager defaultTrustManager() throws KeyManagementException {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("JessieX509", "Jessie");
            trustManagerFactory.init((KeyStore)null);
            return (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagementException(noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyManagementException(noSuchProviderException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new KeyManagementException(keyStoreException);
        }
    }

    private SecureRandom defaultRandom() {
        GetSecurityPropertyAction getSecurityPropertyAction = new GetSecurityPropertyAction("gnu.javax.net.ssl.secureRandom");
        String string = AccessController.doPrivileged(getSecurityPropertyAction);
        if (string == null) {
            string = "Fortuna";
        }
        SecureRandom secureRandom = null;
        try {
            secureRandom = SecureRandom.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            secureRandom = new SecureRandom();
        }
        return secureRandom;
    }
}

