/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Random
implements Builder,
Constructed {
    static final int RANDOM_LENGTH = 28;
    private final ByteBuffer buffer;

    public Random(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer.duplicate().order(ByteOrder.BIG_ENDIAN);
    }

    public Random copy() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(32);
        byteBuffer.put((ByteBuffer)this.buffer.duplicate().position(0));
        return new Random(byteBuffer);
    }

    public int length() {
        return 32;
    }

    public ByteBuffer buffer() {
        return ((ByteBuffer)this.buffer.duplicate().position(0).limit(this.length())).slice();
    }

    public int gmtUnixTime() {
        return this.buffer.getInt(0);
    }

    public byte[] randomBytes() {
        byte[] byArray = new byte[28];
        this.buffer.position(4);
        this.buffer.get(byArray);
        return byArray;
    }

    public void setGmtUnixTime(int n) {
        this.buffer.putInt(0, n);
    }

    public void setRandomBytes(byte[] byArray) {
        this.setRandomBytes(byArray, 0);
    }

    public void setRandomBytes(byte[] byArray, int n) {
        if (byArray.length - n < 28) {
            throw new IllegalArgumentException("random value too short");
        }
        this.buffer.position(4);
        this.buffer.put(byArray, n, 28);
    }

    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("struct {");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("  gmt_unix_time: ");
        printWriter.print(this.gmtUnixTime());
        printWriter.println(";");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("  random_bytes:  ");
        printWriter.print(Util.toHexString(this.randomBytes(), ':'));
        printWriter.println(";");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("} Random;");
        return stringWriter.toString();
    }

    public String toString() {
        return this.toString(null);
    }
}

