/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.Extension;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionList
implements Builder,
Iterable<Extension> {
    private final ByteBuffer buffer;
    private int modCount;

    public ExtensionList(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer.duplicate().order(ByteOrder.BIG_ENDIAN);
        this.modCount = 0;
    }

    public ExtensionList(List<Extension> list2) {
        int n = 2;
        for (Extension extension : list2) {
            n += extension.length();
        }
        this.buffer = ByteBuffer.allocate(n);
        this.buffer.putShort((short)(n - 2));
        for (Extension extension : list2) {
            this.buffer.put(extension.buffer());
        }
        this.buffer.rewind();
    }

    @Override
    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().limit(this.length());
    }

    public Extension get(int n) {
        int n2;
        int n3;
        int n4 = this.length();
        int n5 = 0;
        for (n2 = 2; n2 < n4 && n5 < n; n2 += n3 + 4, ++n5) {
            n3 = this.buffer.getShort(n2 + 2) & 0xFFFF;
        }
        if (n5 < n) {
            throw new IndexOutOfBoundsException("no elemenet at " + n);
        }
        n3 = this.buffer.getShort(n2 + 2) & 0xFFFF;
        ByteBuffer byteBuffer = (ByteBuffer)this.buffer.duplicate().position(n2).limit(n2 + n3 + 4);
        return new Extension(byteBuffer.slice());
    }

    public int size() {
        int n = this.length();
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        int n3 = 2;
        while (n3 < n) {
            int n4 = this.buffer.getShort(n3 + 2) & 0xFFFF;
            n3 += n4 + 4;
            ++n2;
        }
        return n2;
    }

    @Override
    public int length() {
        return (this.buffer.getShort(0) & 0xFFFF) + 2;
    }

    public void set(int n, Extension extension) {
        int n2;
        int n3;
        int n4 = this.length();
        int n5 = 0;
        for (n2 = 2; n2 < n4 && n5 < n; n2 += n3 + 4, ++n5) {
            n3 = this.buffer.getShort(n2 + 2) & 0xFFFF;
        }
        if (n5 < n) {
            throw new IllegalArgumentException("nothing set at index " + (n - 1) + " or insufficient space");
        }
        if (n2 + extension.length() + 2 > n4) {
            throw new IllegalArgumentException("adding this element will exceed the list length");
        }
        this.buffer.putShort(n2, (short)extension.type().getValue());
        this.buffer.putShort(n2 + 2, (short)extension.length());
        ((ByteBuffer)this.buffer.duplicate().position(n2 + 4)).put(extension.valueBuffer());
        ++this.modCount;
    }

    public void set(int n, Extension.Type type, int n2) {
        int n3;
        int n4;
        int n5 = this.length();
        int n6 = 0;
        for (n3 = 2; n3 < n5 && n6 < n; n3 += n4 + 4, ++n6) {
            n4 = this.buffer.getShort(n3 + 2) & 0xFFFF;
        }
        if (n6 < n) {
            throw new IllegalArgumentException("nothing set at index " + (n - 1) + " or insufficient space");
        }
        if (n3 + n2 + 2 > n5) {
            throw new IllegalArgumentException("adding this element will exceed the list length");
        }
        this.buffer.putShort(n3, (short)type.getValue());
        this.buffer.putShort(n3 + 2, (short)n2);
        ++this.modCount;
    }

    public void setLength(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("invalid length");
        }
        this.buffer.putShort(0, (short)n);
        ++this.modCount;
    }

    @Override
    public Iterator<Extension> iterator() {
        return new ExtensionsIterator();
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("ExtensionList {");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("  length = ");
        printWriter.print(this.length());
        printWriter.println(";");
        String string2 = "  ";
        if (string != null) {
            string2 = string + string2;
        }
        for (Extension extension : this) {
            printWriter.println(extension.toString(string2));
        }
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("};");
        return stringWriter.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ExtensionsIterator
    implements ListIterator<Extension> {
        private final int modCount;
        private int index;
        private final int size;

        public ExtensionsIterator() {
            this.modCount = ExtensionList.this.modCount;
            this.index = 0;
            this.size = ExtensionList.this.size();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public Extension next() throws NoSuchElementException {
            if (this.modCount != ExtensionList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return ExtensionList.this.get(this.index++);
        }

        @Override
        public Extension previous() throws NoSuchElementException {
            if (this.modCount != ExtensionList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return ExtensionList.this.get(--this.index);
        }

        @Override
        public int nextIndex() {
            if (this.hasNext()) {
                return this.index + 1;
            }
            return this.index;
        }

        @Override
        public int previousIndex() {
            if (this.hasPrevious()) {
                return this.index - 1;
            }
            return -1;
        }

        @Override
        public void add(Extension extension) {
            throw new UnsupportedOperationException("cannot add items to this iterator");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("cannot remove items from this iterator");
        }

        @Override
        public void set(Extension extension) {
            ExtensionList.this.set(this.index, extension);
        }
    }
}

