/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.ExchangeKeys;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;

public final class EncryptedPreMasterSecret
extends ExchangeKeys
implements Builder {
    private final ProtocolVersion version;

    public EncryptedPreMasterSecret(ByteBuffer byteBuffer, ProtocolVersion protocolVersion) {
        super(byteBuffer);
        protocolVersion.getClass();
        this.version = protocolVersion;
    }

    public EncryptedPreMasterSecret(byte[] byArray, ProtocolVersion protocolVersion) {
        this(ByteBuffer.allocate(protocolVersion == ProtocolVersion.SSL_3 ? byArray.length : byArray.length + 2), protocolVersion);
        ByteBuffer byteBuffer = this.buffer.duplicate();
        if (protocolVersion != ProtocolVersion.SSL_3) {
            byteBuffer.putShort((short)byArray.length);
        }
        byteBuffer.put(byArray);
    }

    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().rewind();
    }

    public byte[] encryptedSecret() {
        byte[] byArray;
        if (this.version == ProtocolVersion.SSL_3) {
            this.buffer.position(0);
            byArray = new byte[this.buffer.limit()];
            this.buffer.get(byArray);
        } else {
            int n = this.buffer.getShort(0) & 0xFFFF;
            byArray = new byte[n];
            this.buffer.position(2);
            this.buffer.get(byArray);
        }
        return byArray;
    }

    public void setEncryptedSecret(byte[] byArray, int n, int n2) {
        if (this.version == ProtocolVersion.SSL_3) {
            this.buffer.position(0);
            this.buffer.put(byArray, n, n2);
            this.buffer.rewind();
        } else {
            this.buffer.putShort(0, (short)n2);
            this.buffer.position(2);
            this.buffer.put(byArray, n, n2);
            this.buffer.rewind();
        }
    }

    public int length() {
        if (this.version == ProtocolVersion.SSL_3) {
            return this.buffer.capacity();
        }
        return (this.buffer.getShort(0) & 0xFFFF) + 2;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("struct {");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("  pre_master_secret = ");
        printWriter.print(Util.hexDump(this.encryptedSecret(), string != null ? string + "    " : "    "));
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("} EncryptedPreMasterSecret;");
        return stringWriter.toString();
    }
}

