/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CompressionMethod;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompressionMethodList
implements Iterable<CompressionMethod> {
    private final ByteBuffer buffer;
    private int modCount;

    public CompressionMethodList(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
        this.modCount = 0;
    }

    public int size() {
        return this.buffer.get(0) & 0xFF;
    }

    public CompressionMethod get(int n) {
        int n2 = this.size();
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException("limit: " + n2 + "; requested: " + n);
        }
        return CompressionMethod.getInstance(this.buffer.get(1 + n));
    }

    public void put(int n, CompressionMethod compressionMethod) {
        int n2 = this.size();
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException("limit: " + n2 + "; requested: " + n);
        }
        this.buffer.position(1 + n);
        this.buffer.put((byte)compressionMethod.getValue());
        ++this.modCount;
    }

    public void setSize(int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("size must be between 0 and 255");
        }
        if (n + 1 > this.buffer.capacity()) {
            throw new IllegalArgumentException("limit: " + this.buffer.capacity() + "; requested: " + n);
        }
        this.buffer.put(0, (byte)n);
        ++this.modCount;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("[");
        printWriter.print(this.size());
        printWriter.println("] {");
        Iterator iterator = new Iterator();
        while (iterator.hasNext()) {
            CompressionMethod compressionMethod = iterator.next();
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.print("  ");
            printWriter.print((Object)compressionMethod);
            if (iterator.hasNext()) {
                printWriter.print(",");
            }
            printWriter.println();
        }
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("};");
        return stringWriter.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof CompressionMethodList)) {
            return false;
        }
        CompressionMethodList compressionMethodList = (CompressionMethodList)object;
        if (this.size() != compressionMethodList.size()) {
            return false;
        }
        Iterator iterator = new Iterator();
        Iterator iterator2 = compressionMethodList.new Iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            if (iterator.next().equals((Object)iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public java.util.Iterator<CompressionMethod> iterator() {
        return new Iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Iterator
    implements ListIterator<CompressionMethod> {
        private int index = 0;
        private final int modCount;

        Iterator() {
            this.modCount = CompressionMethodList.this.modCount;
        }

        @Override
        public void add(CompressionMethod compressionMethod) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < CompressionMethodList.this.size();
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public CompressionMethod next() throws NoSuchElementException {
            if (this.modCount != CompressionMethodList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                return CompressionMethodList.this.get(this.index++);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            if (this.hasNext()) {
                return this.index + 1;
            }
            return -1;
        }

        @Override
        public CompressionMethod previous() throws NoSuchElementException {
            if (this.index == 0) {
                throw new NoSuchElementException();
            }
            if (this.modCount != CompressionMethodList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                return CompressionMethodList.this.get(--this.index);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(CompressionMethod compressionMethod) {
            CompressionMethodList.this.put(this.index, compressionMethod);
        }
    }
}

