/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClientHelloV2
implements Constructed {
    private final ByteBuffer buffer;

    ClientHelloV2(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer.duplicate().order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public int length() {
        return 9 + this.cipherSpecsLength() + this.sessionIdLength() + this.challengeLength();
    }

    ProtocolVersion version() {
        return ProtocolVersion.getInstance(this.buffer.getShort(1));
    }

    int cipherSpecsLength() {
        return this.buffer.getShort(3) & 0xFFFF;
    }

    int sessionIdLength() {
        return this.buffer.getShort(5) & 0xFFFF;
    }

    int challengeLength() {
        return this.buffer.getShort(7) & 0xFFFF;
    }

    public List<CipherSuite> cipherSpecs() {
        int n = this.cipherSpecsLength();
        ArrayList<CipherSuite> arrayList = new ArrayList<CipherSuite>(n / 3);
        ByteBuffer byteBuffer = (ByteBuffer)this.buffer.duplicate().position(9);
        for (int i = 0; i < n; i += 3) {
            if (byteBuffer.get() == 0) {
                arrayList.add(CipherSuite.forValue(byteBuffer.getShort()).resolve());
                continue;
            }
            byteBuffer.getShort();
        }
        return arrayList;
    }

    byte[] sessionId() {
        byte[] byArray = new byte[this.sessionIdLength()];
        ((ByteBuffer)this.buffer.duplicate().position(9 + this.cipherSpecsLength())).get(byArray);
        return byArray;
    }

    byte[] challenge() {
        byte[] byArray = new byte[this.challengeLength()];
        ((ByteBuffer)this.buffer.duplicate().position(9 + this.cipherSpecsLength() + this.sessionIdLength())).get(byArray);
        return byArray;
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("CLIENT-HELLO-MSG");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("  version: ");
        printWriter.println(this.version());
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("  suites: ");
        printWriter.println(this.cipherSpecs());
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("  sessionId: ");
        printWriter.println(Util.toHexString(this.sessionId(), ':'));
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("  challenge: ");
        printWriter.println(Util.toHexString(this.challenge(), ':'));
        return stringWriter.toString();
    }
}

