/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.ExchangeKeys;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class ClientDiffieHellmanPublic
extends ExchangeKeys
implements Builder {
    public ClientDiffieHellmanPublic(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    public ClientDiffieHellmanPublic(BigInteger bigInteger) {
        super(ClientDiffieHellmanPublic.wrap(bigInteger));
    }

    private static ByteBuffer wrap(BigInteger bigInteger) {
        byte[] byArray = Util.trim(bigInteger);
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length + 2);
        byteBuffer.putShort((short)byArray.length);
        byteBuffer.put(byArray);
        return (ByteBuffer)byteBuffer.rewind();
    }

    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().rewind().limit(this.length());
    }

    public BigInteger publicValue() {
        int n = this.length() - 2;
        byte[] byArray = new byte[n];
        this.buffer.position(2);
        this.buffer.get(byArray);
        this.buffer.rewind();
        return new BigInteger(1, byArray);
    }

    public void setPublicValue(BigInteger bigInteger) {
        byte[] byArray = Util.trim(bigInteger);
        if (this.buffer.capacity() < byArray.length + 2) {
            this.buffer = ByteBuffer.allocate(byArray.length + 2);
        }
        this.buffer.putShort((short)byArray.length);
        this.buffer.put(byArray);
        this.buffer.rewind();
    }

    public int length() {
        return (this.buffer.getShort(0) & 0xFFFF) + 2;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("struct {");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("  dh_Yc = ");
        printWriter.print(this.publicValue().toString(16));
        printWriter.println(';');
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("} ClientDiffieHellmanPublic;");
        return stringWriter.toString();
    }
}

