/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CertificateRequest;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientCertificateTypeList
implements Iterable<CertificateRequest.ClientCertificateType> {
    private final ByteBuffer buffer;
    private int modCount;

    public ClientCertificateTypeList(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
        this.modCount = 0;
    }

    public int size() {
        return this.buffer.get(0) & 0xFF;
    }

    public CertificateRequest.ClientCertificateType get(int n) {
        int n2 = this.size();
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException("limit: " + n2 + "; requested: " + n);
        }
        return CertificateRequest.ClientCertificateType.forValue(this.buffer.get(n + 1) & 0xFF);
    }

    @Override
    public java.util.Iterator<CertificateRequest.ClientCertificateType> iterator() {
        return new Iterator();
    }

    public void put(int n, CertificateRequest.ClientCertificateType clientCertificateType) {
        int n2 = this.size();
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException("limit: " + n2 + "; requested: " + n);
        }
        this.buffer.put(n + 1, (byte)clientCertificateType.getValue());
        ++this.modCount;
    }

    public void setSize(int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("size must be between 0 and 255");
        }
        if (n + 1 > this.buffer.capacity()) {
            throw new IllegalArgumentException("limit: " + (this.buffer.capacity() - 1) + "; requested: " + n);
        }
        this.buffer.put(0, (byte)n);
        ++this.modCount;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("[");
        printWriter.print(this.size());
        printWriter.println("] {");
        Iterator iterator = new Iterator();
        while (iterator.hasNext()) {
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.print("  ");
            printWriter.print((Object)iterator.next());
            if (iterator.hasNext()) {
                printWriter.print(",");
            }
            printWriter.println();
        }
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("};");
        return stringWriter.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClientCertificateTypeList)) {
            return false;
        }
        ClientCertificateTypeList clientCertificateTypeList = (ClientCertificateTypeList)object;
        if (this.size() != clientCertificateTypeList.size()) {
            return false;
        }
        Iterator iterator = new Iterator();
        Iterator iterator2 = clientCertificateTypeList.new Iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            if (iterator.next().equals((Object)iterator2.next())) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Iterator
    implements ListIterator<CertificateRequest.ClientCertificateType> {
        private int index = 0;
        private final int modCount;

        Iterator() {
            this.modCount = ClientCertificateTypeList.this.modCount;
        }

        @Override
        public void add(CertificateRequest.ClientCertificateType clientCertificateType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < ClientCertificateTypeList.this.size();
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public CertificateRequest.ClientCertificateType next() throws NoSuchElementException {
            if (this.modCount != ClientCertificateTypeList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                return ClientCertificateTypeList.this.get(this.index++);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            if (this.hasNext()) {
                return this.index + 1;
            }
            return -1;
        }

        @Override
        public CertificateRequest.ClientCertificateType previous() throws NoSuchElementException {
            if (this.index == 0) {
                throw new NoSuchElementException();
            }
            if (this.modCount != ClientCertificateTypeList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                return ClientCertificateTypeList.this.get(--this.index);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(CertificateRequest.ClientCertificateType clientCertificateType) {
            ClientCertificateTypeList.this.put(this.index, clientCertificateType);
        }
    }
}

