/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CertificateStatusType;
import gnu.javax.net.ssl.provider.Extension;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateStatusRequest
extends Extension.Value
implements Iterable<byte[]> {
    private ByteBuffer buffer;

    public CertificateStatusRequest(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
    }

    public CertificateStatusRequest(CertificateStatusType certificateStatusType, List<byte[]> list2, byte[] byArray) {
        if (certificateStatusType != CertificateStatusType.OCSP) {
            throw new IllegalArgumentException();
        }
        int n = 3;
        int n2 = 0;
        for (byte[] byArray2 : list2) {
            n += 2 + byArray2.length;
            n2 += 2 + byArray2.length;
        }
        this.buffer = ByteBuffer.allocate(n += 2 + byArray.length);
        this.buffer.put((byte)1);
        this.buffer.putShort((short)n2);
        for (byte[] byArray2 : list2) {
            this.buffer.putShort((short)byArray2.length).put(byArray2);
        }
        this.buffer.putShort((short)byArray.length);
        this.buffer.put(byArray);
        this.buffer.rewind();
    }

    @Override
    public int length() {
        int n = 3 + (this.buffer.getShort(1) & 0xFFFF);
        return n + (this.buffer.getShort(n) & 0xFFFF) + 2;
    }

    @Override
    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().limit(this.length());
    }

    public CertificateStatusType statusType() {
        int n = this.buffer.get(0) & 0xFF;
        if (n == 1) {
            return CertificateStatusType.OCSP;
        }
        throw new IllegalArgumentException("invalid type: " + n);
    }

    public int size() {
        int n = this.buffer.getShort(1) & 0xFFFF;
        int n2 = 0;
        int n3 = 3;
        while (n3 < n) {
            short s = this.buffer.getShort(n3);
            n3 += s + 2;
            ++n2;
        }
        return n2;
    }

    public byte[] responderId(int n) {
        int n2;
        int n3 = this.buffer.getShort(1) & 0xFFFF;
        int n4 = 0;
        for (int i = 3; i < n3 && n4 <= n; i += n2 + 2, ++n4) {
            n2 = this.buffer.getShort(i) & 0xFFFF;
            if (n4 != n) continue;
            byte[] byArray = new byte[n2];
            ((ByteBuffer)this.buffer.duplicate().position(i + 2)).get(byArray);
            return byArray;
        }
        throw new IndexOutOfBoundsException();
    }

    public byte[] requestExtensions() {
        int n = 2 + (this.buffer.getShort(0) & 0xFFFF);
        int n2 = this.buffer.getShort(n) & 0xFFFF;
        byte[] byArray = new byte[n2];
        ((ByteBuffer)this.buffer.duplicate().position(n2 + 2)).get(byArray);
        return byArray;
    }

    public void setStatusType(CertificateStatusType certificateStatusType) {
        this.buffer.put(0, (byte)certificateStatusType.value);
    }

    public void setRequestIdListLength(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("length out of range");
        }
        this.buffer.putShort(1, (short)n);
    }

    public void putRequestId(int n, byte[] byArray) {
        int n2;
        int n3;
        if (byArray.length > 65535) {
            throw new IllegalArgumentException("request ID too large");
        }
        int n4 = this.buffer.getShort(1) & 0xFFFF;
        int n5 = 0;
        for (n2 = 3; n2 < n4 && n5 < n; n2 += n3 + 2, ++n5) {
            n3 = this.buffer.getShort(n2) & 0xFFFF;
        }
        if (n5 < n) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer.putShort(n2, (short)byArray.length);
        ((ByteBuffer)this.buffer.duplicate().position(n2)).put(byArray);
    }

    public void setRequestExtensions(int n, byte[] byArray) {
        if (byArray.length > 65535) {
            throw new IllegalArgumentException("exceptions too large");
        }
        int n2 = 3 + (this.buffer.getShort(1) & 0xFFFF);
        this.buffer.putShort(n2, (short)byArray.length);
        ((ByteBuffer)this.buffer.duplicate().position(n2 + 2)).put(byArray);
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new ResponderIdIterator();
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("struct {");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("  status_type = ");
        printWriter.print((Object)this.statusType());
        printWriter.println(";");
        String string2 = "    ";
        if (string != null) {
            string2 = string + string2;
        }
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("  responder_id_list = {");
        for (byte[] byArray : this) {
            printWriter.print(Util.hexDump(byArray, string2));
        }
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("  };");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("  request_extensions =");
        printWriter.print(Util.hexDump(this.requestExtensions(), string2));
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("} CertificateStatus;");
        return stringWriter.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ResponderIdIterator
    implements Iterator<byte[]> {
        private int index = 0;

        @Override
        public byte[] next() throws NoSuchElementException {
            try {
                return CertificateStatusRequest.this.responderId(this.index++);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < CertificateStatusRequest.this.size();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

