/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.CertificateRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateRequestBuilder
extends CertificateRequest
implements Builder {
    public CertificateRequestBuilder() {
        super(ByteBuffer.allocate(1024));
    }

    @Override
    public ByteBuffer buffer() {
        return ((ByteBuffer)this.buffer.duplicate().limit(this.length())).slice();
    }

    public void setTypes(List<CertificateRequest.ClientCertificateType> list2) {
        this.ensureCapacity(list2.size() + 3);
        this.buffer.put(0, (byte)list2.size());
        ByteBuffer byteBuffer = (ByteBuffer)this.buffer.duplicate().position(1);
        for (CertificateRequest.ClientCertificateType clientCertificateType : list2) {
            byteBuffer.put((byte)clientCertificateType.getValue());
        }
    }

    public void setAuthorities(List<X500Principal> list2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        for (X500Principal x500Principal : list2) {
            byte[] byArray = x500Principal.getEncoded();
            byteArrayOutputStream.write(byArray.length >>> 8 & 0xFF);
            byteArrayOutputStream.write(byArray.length & 0xFF);
            try {
                byteArrayOutputStream.write(byArray);
            }
            catch (IOException iOException) {}
        }
        Object object = byteArrayOutputStream.toByteArray();
        int n = 1 + (this.buffer.get(0) & 0xFF);
        int n2 = n + ((Object)object).length + 2;
        this.ensureCapacity(n2);
        this.buffer.putShort(n, (short)((Object)object).length);
        ((ByteBuffer)this.buffer.duplicate().position(n + 2)).put((byte[])object);
    }

    public void ensureCapacity(int n) {
        if (this.buffer.capacity() >= n) {
            return;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.duplicate().put(this.buffer);
        this.buffer = byteBuffer;
    }
}

