/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.Certificate;
import gnu.javax.net.ssl.provider.CertificateType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.CertificateException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateBuilder
extends Certificate
implements Builder {
    public CertificateBuilder(CertificateType certificateType) {
        super(ByteBuffer.allocate(1024), certificateType);
    }

    @Override
    public ByteBuffer buffer() {
        return ((ByteBuffer)this.buffer.duplicate().position(0).limit(this.length())).slice();
    }

    public void setCertificates(List<? extends java.security.cert.Certificate> list2) throws CertificateException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        for (java.security.cert.Certificate certificate : list2) {
            byte[] byArray = certificate.getEncoded();
            byteArrayOutputStream.write(byArray.length >>> 16 & 0xFF);
            byteArrayOutputStream.write(byArray.length >>> 8 & 0xFF);
            byteArrayOutputStream.write(byArray.length & 0xFF);
            try {
                byteArrayOutputStream.write(byArray);
            }
            catch (IOException iOException) {}
        }
        Object object = byteArrayOutputStream.toByteArray();
        if (this.buffer.capacity() < ((Object)object).length + 3) {
            this.buffer = ByteBuffer.allocate(((Object)object).length + 3);
        }
        this.buffer.put(0, (byte)(((Object)object).length >>> 16));
        this.buffer.putShort(1, (short)((Object)object).length);
        ((ByteBuffer)this.buffer.duplicate().position(3)).put((byte[])object);
    }
}

