/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.java.security.action.GetSecurityPropertyAction;
import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.util.ByteArray;
import gnu.javax.net.ssl.provider.CipherAlgorithm;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.CompressionMethod;
import gnu.javax.net.ssl.provider.DelegatedTask;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.InputSecurityParameters;
import gnu.javax.net.ssl.provider.MacAlgorithm;
import gnu.javax.net.ssl.provider.OutputSecurityParameters;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Random;
import gnu.javax.net.ssl.provider.SSLEngineImpl;
import gnu.javax.net.ssl.provider.SSLRandom;
import gnu.javax.net.ssl.provider.SessionImpl;
import gnu.javax.net.ssl.provider.SignatureAlgorithm;
import gnu.javax.net.ssl.provider.TLSRandom;
import gnu.javax.net.ssl.provider.Util;
import gnu.javax.security.auth.callback.CertificateCallback;
import gnu.javax.security.auth.callback.DefaultCallbackHandler;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ConfirmationCallback;

public abstract class AbstractHandshake {
    protected static final SystemLogger logger = SystemLogger.SYSTEM;
    protected static final byte[] SERVER_FINISHED = new byte[]{115, 101, 114, 118, 101, 114, 32, 102, 105, 110, 105, 115, 104, 101, 100};
    protected static final byte[] CLIENT_FINISHED = new byte[]{99, 108, 105, 101, 110, 116, 32, 102, 105, 110, 105, 115, 104, 101, 100};
    private static final byte[] KEY_EXPANSION = new byte[]{107, 101, 121, 32, 101, 120, 112, 97, 110, 115, 105, 111, 110};
    private static final byte[] MASTER_SECRET = new byte[]{109, 97, 115, 116, 101, 114, 32, 115, 101, 99, 114, 101, 116};
    private static final byte[] CLIENT_WRITE_KEY = new byte[]{99, 108, 105, 101, 110, 116, 32, 119, 114, 105, 116, 101, 32, 107, 101, 121};
    private static final byte[] SERVER_WRITE_KEY = new byte[]{115, 101, 114, 118, 101, 114, 32, 119, 114, 105, 116, 101, 32, 107, 101, 121};
    private static final byte[] IV_BLOCK = new byte[]{73, 86, 32, 98, 108, 111, 99, 107};
    private static final byte[] SENDER_CLIENT = new byte[]{67, 76, 78, 84};
    private static final byte[] SENDER_SERVER = new byte[]{83, 82, 86, 82};
    protected static final byte[] PAD1 = new byte[48];
    protected static final byte[] PAD2 = new byte[48];
    protected ByteBuffer handshakeBuffer;
    protected int handshakeOffset;
    protected MessageDigest sha;
    protected MessageDigest md5;
    protected final SSLEngineImpl engine;
    protected KeyAgreement keyAgreement;
    protected byte[] preMasterSecret;
    protected InputSecurityParameters inParams;
    protected OutputSecurityParameters outParams;
    protected LinkedList<DelegatedTask> tasks;
    protected Random serverRandom;
    protected Random clientRandom;
    protected CompressionMethod compression;

    protected AbstractHandshake(SSLEngineImpl sSLEngineImpl) throws NoSuchAlgorithmException {
        this.engine = sSLEngineImpl;
        this.sha = MessageDigest.getInstance("SHA-1");
        this.md5 = MessageDigest.getInstance("MD5");
        this.tasks = new LinkedList();
    }

    public final SSLEngineResult.HandshakeStatus handleInput(ByteBuffer byteBuffer) throws SSLException {
        if (!this.tasks.isEmpty()) {
            return SSLEngineResult.HandshakeStatus.NEED_TASK;
        }
        SSLEngineResult.HandshakeStatus handshakeStatus = this.status();
        if (handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            return handshakeStatus;
        }
        if (!this.pollHandshake(byteBuffer)) {
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        while (this.hasMessage() && handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            int n = this.handshakeOffset;
            handshakeStatus = this.implHandleInput();
            int n2 = this.handshakeOffset - n;
            if (n2 == 0 || !this.doHash()) continue;
            logger.logv(Component.SSL_HANDSHAKE, "hashing output\n{0}", Util.hexDump((ByteBuffer)this.handshakeBuffer.duplicate().position(n).limit(n + n2), " >> "));
            this.sha.update((ByteBuffer)this.handshakeBuffer.duplicate().position(n).limit(n + n2));
            this.md5.update((ByteBuffer)this.handshakeBuffer.duplicate().position(n).limit(n + n2));
        }
        return handshakeStatus;
    }

    protected abstract SSLEngineResult.HandshakeStatus implHandleInput() throws SSLException;

    public final SSLEngineResult.HandshakeStatus handleOutput(ByteBuffer byteBuffer) throws SSLException {
        if (!this.tasks.isEmpty()) {
            return SSLEngineResult.HandshakeStatus.NEED_TASK;
        }
        int n = byteBuffer.position();
        SSLEngineResult.HandshakeStatus handshakeStatus = this.implHandleOutput(byteBuffer);
        if (this.doHash()) {
            logger.logv(Component.SSL_HANDSHAKE, "hashing output:\n{0}", Util.hexDump((ByteBuffer)byteBuffer.duplicate().flip().position(n), " >> "));
            this.sha.update((ByteBuffer)byteBuffer.duplicate().flip().position(n));
            this.md5.update((ByteBuffer)byteBuffer.duplicate().flip().position(n));
        }
        return handshakeStatus;
    }

    protected abstract SSLEngineResult.HandshakeStatus implHandleOutput(ByteBuffer var1) throws SSLException;

    final InputSecurityParameters getInputParams() throws SSLException {
        this.checkKeyExchange();
        return this.inParams;
    }

    final OutputSecurityParameters getOutputParams() throws SSLException {
        this.checkKeyExchange();
        return this.outParams;
    }

    final Runnable getTask() {
        if (this.tasks.isEmpty()) {
            return null;
        }
        return this.tasks.removeFirst();
    }

    abstract SSLEngineResult.HandshakeStatus status();

    abstract void checkKeyExchange() throws SSLException;

    abstract void handleV2Hello(ByteBuffer var1) throws SSLException;

    protected boolean pollHandshake(ByteBuffer byteBuffer) {
        if (this.handshakeBuffer == null || this.handshakeBuffer.remaining() < byteBuffer.remaining()) {
            int n = this.handshakeBuffer == null ? 0 : this.handshakeBuffer.position() - this.handshakeOffset;
            this.reallocateBuffer(n += byteBuffer.remaining());
        }
        logger.logv(Component.SSL_HANDSHAKE, "inserting {0} into {1}", byteBuffer, this.handshakeBuffer);
        this.handshakeBuffer.put(byteBuffer);
        return this.hasMessage();
    }

    protected boolean doHash() {
        return true;
    }

    protected boolean hasMessage() {
        if (this.handshakeBuffer == null) {
            return false;
        }
        ByteBuffer byteBuffer = this.handshakeBuffer.duplicate();
        byteBuffer.flip();
        byteBuffer.position(this.handshakeOffset);
        logger.logv(Component.SSL_HANDSHAKE, "current buffer: {0}; test buffer {1}", this.handshakeBuffer, byteBuffer);
        if (byteBuffer.remaining() < 4) {
            return false;
        }
        Handshake handshake = new Handshake(byteBuffer.slice());
        logger.logv(Component.SSL_HANDSHAKE, "handshake len:{0} remaining:{1}", handshake.length(), byteBuffer.remaining());
        return handshake.length() <= byteBuffer.remaining() - 4;
    }

    private void reallocateBuffer(int n) {
        int n2;
        int n3 = n2 = this.handshakeBuffer == null ? -1 : this.handshakeBuffer.capacity() - (this.handshakeBuffer.limit() - this.handshakeOffset);
        if (n2 >= n) {
            if (this.handshakeOffset > 0) {
                this.handshakeBuffer.flip().position(this.handshakeOffset);
                this.handshakeBuffer.compact();
                this.handshakeOffset = 0;
            }
            return;
        }
        for (n2 = 1024; n2 < n; n2 <<= 1) {
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        if (this.handshakeBuffer != null) {
            this.handshakeBuffer.flip();
            this.handshakeBuffer.position(this.handshakeOffset);
            byteBuffer.put(this.handshakeBuffer);
        }
        this.handshakeBuffer = byteBuffer;
        this.handshakeOffset = 0;
    }

    protected byte[] genV3CertificateVerify(MessageDigest messageDigest, MessageDigest messageDigest2, SessionImpl sessionImpl) {
        byte[] byArray;
        byte[] byArray2 = null;
        if (sessionImpl.suite.signatureAlgorithm() == SignatureAlgorithm.RSA) {
            messageDigest.update(sessionImpl.privateData.masterSecret);
            messageDigest.update(PAD1, 0, 48);
            byArray = messageDigest.digest();
            messageDigest.reset();
            messageDigest.update(sessionImpl.privateData.masterSecret);
            messageDigest.update(PAD2, 0, 48);
            messageDigest.update(byArray);
            byArray2 = messageDigest.digest();
        }
        messageDigest2.update(sessionImpl.privateData.masterSecret);
        messageDigest2.update(PAD1, 0, 40);
        byArray = messageDigest2.digest();
        messageDigest2.reset();
        messageDigest2.update(sessionImpl.privateData.masterSecret);
        messageDigest2.update(PAD2, 0, 40);
        messageDigest2.update(byArray);
        byte[] byArray3 = messageDigest2.digest();
        if (byArray2 != null) {
            return Util.concat(byArray2, byArray3);
        }
        return byArray3;
    }

    protected byte[][] generateKeys(Random random, Random random2, SessionImpl sessionImpl) {
        Object object;
        Object object2;
        int n = 20;
        if (sessionImpl.suite.macAlgorithm() == MacAlgorithm.MD5) {
            n = 16;
        }
        int n2 = 0;
        if (sessionImpl.suite.cipherAlgorithm() == CipherAlgorithm.DES || sessionImpl.suite.cipherAlgorithm() == CipherAlgorithm.DESede) {
            n2 = 8;
        }
        if (sessionImpl.suite.cipherAlgorithm() == CipherAlgorithm.AES) {
            n2 = 16;
        }
        int n3 = sessionImpl.suite.keyLength();
        byte[][] byArrayArray = new byte[][]{new byte[n], new byte[n], new byte[n3], new byte[n3], new byte[n2], new byte[n2]};
        IRandom iRandom = null;
        if (sessionImpl.version == ProtocolVersion.SSL_3) {
            object2 = new byte[random.length() + random2.length()];
            random2.buffer().get((byte[])object2, 0, random2.length());
            random.buffer().get((byte[])object2, random2.length(), random.length());
            iRandom = new SSLRandom();
            object = new HashMap<String, byte[]>(2);
            ((HashMap)object).put("jessie.sslprng.secret", sessionImpl.privateData.masterSecret);
            ((HashMap)object).put("jessie.sslprng.seed", object2);
            iRandom.init((Map)object);
        } else {
            object2 = new byte[KEY_EXPANSION.length + random.length() + random2.length()];
            System.arraycopy(KEY_EXPANSION, 0, object2, 0, KEY_EXPANSION.length);
            random2.buffer().get((byte[])object2, KEY_EXPANSION.length, random2.length());
            random.buffer().get((byte[])object2, KEY_EXPANSION.length + random2.length(), random.length());
            iRandom = new TLSRandom();
            object = new HashMap(2);
            ((HashMap)object).put("jessie.tls.prng.secret", sessionImpl.privateData.masterSecret);
            ((HashMap)object).put("jessie.tls.prng.seed", object2);
            iRandom.init((Map)object);
        }
        try {
            iRandom.nextBytes(byArrayArray[0], 0, byArrayArray[0].length);
            iRandom.nextBytes(byArrayArray[1], 0, byArrayArray[1].length);
            iRandom.nextBytes(byArrayArray[2], 0, byArrayArray[2].length);
            iRandom.nextBytes(byArrayArray[3], 0, byArrayArray[3].length);
            if (sessionImpl.suite.isExportable()) {
                if (sessionImpl.version == ProtocolVersion.SSL_3) {
                    object2 = MessageDigest.getInstance("MD5");
                    ((MessageDigest)object2).update(random.buffer());
                    ((MessageDigest)object2).update(random2.buffer());
                    object = ((MessageDigest)object2).digest();
                    System.arraycopy(object, 0, byArrayArray[4], 0, byArrayArray[4].length);
                    ((MessageDigest)object2).reset();
                    ((MessageDigest)object2).update(random2.buffer());
                    ((MessageDigest)object2).update(random.buffer());
                    object = ((MessageDigest)object2).digest();
                    System.arraycopy(object, 0, byArrayArray[5], 0, byArrayArray[5].length);
                    ((MessageDigest)object2).reset();
                    ((MessageDigest)object2).update(byArrayArray[2]);
                    ((MessageDigest)object2).update(random.buffer());
                    ((MessageDigest)object2).update(random2.buffer());
                    byArrayArray[2] = Util.trim(((MessageDigest)object2).digest(), 8);
                    ((MessageDigest)object2).reset();
                    ((MessageDigest)object2).update(byArrayArray[3]);
                    ((MessageDigest)object2).update(random2.buffer());
                    ((MessageDigest)object2).update(random.buffer());
                    byArrayArray[3] = Util.trim(((MessageDigest)object2).digest(), 8);
                } else {
                    object2 = new TLSRandom();
                    object = new HashMap(2);
                    ((HashMap)object).put("jessie.tls.prng.secret", byArrayArray[2]);
                    byte[] byArray = new byte[CLIENT_WRITE_KEY.length + random.length() + random2.length()];
                    System.arraycopy(CLIENT_WRITE_KEY, 0, byArray, 0, CLIENT_WRITE_KEY.length);
                    random.buffer().get(byArray, CLIENT_WRITE_KEY.length, random.length());
                    random2.buffer().get(byArray, CLIENT_WRITE_KEY.length + random.length(), random2.length());
                    ((HashMap)object).put("jessie.tls.prng.seed", byArray);
                    ((TLSRandom)object2).init((Map)object);
                    byArrayArray[2] = new byte[8];
                    ((TLSRandom)object2).nextBytes(byArrayArray[2], 0, byArrayArray[2].length);
                    ((HashMap)object).put("jessie.tls.prng.secret", byArrayArray[3]);
                    byArray = new byte[SERVER_WRITE_KEY.length + random2.length() + random.length()];
                    System.arraycopy(SERVER_WRITE_KEY, 0, byArray, 0, SERVER_WRITE_KEY.length);
                    random2.buffer().get(byArray, SERVER_WRITE_KEY.length, random2.length());
                    random.buffer().get(byArray, SERVER_WRITE_KEY.length + random2.length(), random.length());
                    ((HashMap)object).put("jessie.tls.prng.seed", byArray);
                    ((TLSRandom)object2).init((Map)object);
                    byArrayArray[3] = new byte[8];
                    ((TLSRandom)object2).nextBytes(byArrayArray[3], 0, byArrayArray[3].length);
                    ((HashMap)object).put("jessie.tls.prng.secret", new byte[0]);
                    byArray = new byte[IV_BLOCK.length + random.length() + random2.length()];
                    System.arraycopy(IV_BLOCK, 0, byArray, 0, IV_BLOCK.length);
                    random.buffer().get(byArray, IV_BLOCK.length, random.length());
                    random2.buffer().get(byArray, IV_BLOCK.length + random.length(), random2.length());
                    ((HashMap)object).put("jessie.tls.prng.seed", byArray);
                    ((TLSRandom)object2).init((Map)object);
                    ((TLSRandom)object2).nextBytes(byArrayArray[4], 0, byArrayArray[4].length);
                    ((TLSRandom)object2).nextBytes(byArrayArray[5], 0, byArrayArray[5].length);
                }
            } else {
                iRandom.nextBytes(byArrayArray[4], 0, byArrayArray[4].length);
                iRandom.nextBytes(byArrayArray[5], 0, byArrayArray[5].length);
            }
        }
        catch (LimitReachedException limitReachedException) {
            throw new Error(limitReachedException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error(noSuchAlgorithmException);
        }
        logger.logv(Component.SSL_KEY_EXCHANGE, "keys generated;\n  [0]: {0}\n  [1]: {1}\n  [2]: {2}\n  [3]: {3}\n  [4]: {4}\n  [5]: {5}", Util.toHexString(byArrayArray[0], ':'), Util.toHexString(byArrayArray[1], ':'), Util.toHexString(byArrayArray[2], ':'), Util.toHexString(byArrayArray[3], ':'), Util.toHexString(byArrayArray[4], ':'), Util.toHexString(byArrayArray[5], ':'));
        return byArrayArray;
    }

    protected ByteBuffer generateFinished(MessageDigest messageDigest, MessageDigest messageDigest2, boolean bl, SessionImpl sessionImpl) {
        ByteBuffer byteBuffer = null;
        if (sessionImpl.version.compareTo(ProtocolVersion.TLS_1) >= 0) {
            byteBuffer = ByteBuffer.allocate(12);
            TLSRandom tLSRandom = new TLSRandom();
            byte[] byArray = messageDigest.digest();
            byte[] byArray2 = messageDigest2.digest();
            logger.logv(Component.SSL_HANDSHAKE, "finished md5:{0} sha:{1}", Util.toHexString(byArray, ':'), Util.toHexString(byArray2, ':'));
            byte[] byArray3 = new byte[CLIENT_FINISHED.length + byArray.length + byArray2.length];
            if (bl) {
                System.arraycopy(CLIENT_FINISHED, 0, byArray3, 0, CLIENT_FINISHED.length);
            } else {
                System.arraycopy(SERVER_FINISHED, 0, byArray3, 0, SERVER_FINISHED.length);
            }
            System.arraycopy(byArray, 0, byArray3, CLIENT_FINISHED.length, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, CLIENT_FINISHED.length + byArray.length, byArray2.length);
            HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>(2);
            hashMap.put("jessie.tls.prng.secret", sessionImpl.privateData.masterSecret);
            hashMap.put("jessie.tls.prng.seed", byArray3);
            tLSRandom.init(hashMap);
            byte[] byArray4 = new byte[12];
            tLSRandom.nextBytes(byArray4, 0, byArray4.length);
            byteBuffer.put(byArray4).position(0);
        } else {
            byteBuffer = ByteBuffer.allocate(36);
            messageDigest.update(bl ? SENDER_CLIENT : SENDER_SERVER);
            messageDigest.update(sessionImpl.privateData.masterSecret);
            messageDigest.update(PAD1);
            byte[] byArray = messageDigest.digest();
            messageDigest.reset();
            messageDigest.update(sessionImpl.privateData.masterSecret);
            messageDigest.update(PAD2);
            messageDigest.update(byArray);
            byteBuffer.put(messageDigest.digest());
            messageDigest2.update(bl ? SENDER_CLIENT : SENDER_SERVER);
            messageDigest2.update(sessionImpl.privateData.masterSecret);
            messageDigest2.update(PAD1, 0, 40);
            byArray = messageDigest2.digest();
            messageDigest2.reset();
            messageDigest2.update(sessionImpl.privateData.masterSecret);
            messageDigest2.update(PAD2, 0, 40);
            messageDigest2.update(byArray);
            byteBuffer.put(messageDigest2.digest()).position(0);
        }
        return byteBuffer;
    }

    protected void initDiffieHellman(DHPrivateKey dHPrivateKey, SecureRandom secureRandom) throws SSLException {
        try {
            this.keyAgreement = KeyAgreement.getInstance("DH");
            this.keyAgreement.init((Key)dHPrivateKey, secureRandom);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SSLException(invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SSLException(noSuchAlgorithmException);
        }
    }

    protected void generateMasterSecret(Random random, Random random2, SessionImpl sessionImpl) throws SSLException {
        Object object;
        Object object2;
        assert (random != null);
        assert (random2 != null);
        assert (sessionImpl != null);
        logger.logv(Component.SSL_KEY_EXCHANGE, "preMasterSecret:\n{0}", new ByteArray(this.preMasterSecret));
        if (sessionImpl.version == ProtocolVersion.SSL_3) {
            try {
                object2 = MessageDigest.getInstance("MD5");
                object = MessageDigest.getInstance("SHA");
                sessionImpl.privateData.masterSecret = new byte[48];
                ((MessageDigest)object).update((byte)65);
                ((MessageDigest)object).update(this.preMasterSecret);
                ((MessageDigest)object).update(random.buffer());
                ((MessageDigest)object).update(random2.buffer());
                ((MessageDigest)object2).update(this.preMasterSecret);
                ((MessageDigest)object2).update(((MessageDigest)object).digest());
                ((MessageDigest)object2).digest(sessionImpl.privateData.masterSecret, 0, 16);
                ((MessageDigest)object).update((byte)66);
                ((MessageDigest)object).update((byte)66);
                ((MessageDigest)object).update(this.preMasterSecret);
                ((MessageDigest)object).update(random.buffer());
                ((MessageDigest)object).update(random2.buffer());
                ((MessageDigest)object2).update(this.preMasterSecret);
                ((MessageDigest)object2).update(((MessageDigest)object).digest());
                ((MessageDigest)object2).digest(sessionImpl.privateData.masterSecret, 16, 16);
                ((MessageDigest)object).update((byte)67);
                ((MessageDigest)object).update((byte)67);
                ((MessageDigest)object).update((byte)67);
                ((MessageDigest)object).update(this.preMasterSecret);
                ((MessageDigest)object).update(random.buffer());
                ((MessageDigest)object).update(random2.buffer());
                ((MessageDigest)object2).update(this.preMasterSecret);
                ((MessageDigest)object2).update(((MessageDigest)object).digest());
                ((MessageDigest)object2).digest(sessionImpl.privateData.masterSecret, 32, 16);
            }
            catch (DigestException digestException) {
                throw new SSLException(digestException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SSLException(noSuchAlgorithmException);
            }
        } else {
            object2 = new byte[random.length() + random2.length() + MASTER_SECRET.length];
            System.arraycopy(MASTER_SECRET, 0, object2, 0, MASTER_SECRET.length);
            random.buffer().get((byte[])object2, MASTER_SECRET.length, random.length());
            random2.buffer().get((byte[])object2, MASTER_SECRET.length + random.length(), random2.length());
            object = new TLSRandom();
            HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
            hashMap.put("jessie.tls.prng.secret", this.preMasterSecret);
            hashMap.put("jessie.tls.prng.seed", object2);
            ((TLSRandom)object).init(hashMap);
            sessionImpl.privateData.masterSecret = new byte[48];
            ((TLSRandom)object).nextBytes(sessionImpl.privateData.masterSecret, 0, 48);
        }
        logger.log((Level)Component.SSL_KEY_EXCHANGE, "master_secret: {0}", new ByteArray(sessionImpl.privateData.masterSecret));
        for (int i = 0; i < this.preMasterSecret.length; ++i) {
            this.preMasterSecret[i] = 0;
        }
    }

    protected void setupSecurityParameters(byte[][] byArray, boolean bl, SSLEngineImpl sSLEngineImpl, CompressionMethod compressionMethod) throws SSLException {
        assert (byArray.length == 6);
        assert (sSLEngineImpl != null);
        assert (compressionMethod != null);
        try {
            CipherSuite cipherSuite = sSLEngineImpl.session().suite;
            Cipher cipher = cipherSuite.cipher();
            Mac mac = cipherSuite.mac(sSLEngineImpl.session().version);
            Inflater inflater = compressionMethod == CompressionMethod.ZLIB ? new Inflater() : null;
            cipher.init(2, (Key)new SecretKeySpec(byArray[bl ? 3 : 2], cipherSuite.cipherAlgorithm().toString()), new IvParameterSpec(byArray[bl ? 5 : 4]));
            mac.init(new SecretKeySpec(byArray[bl ? 1 : 0], mac.getAlgorithm()));
            this.inParams = new InputSecurityParameters(cipher, mac, inflater, sSLEngineImpl.session(), cipherSuite);
            Cipher cipher2 = cipherSuite.cipher();
            Mac mac2 = cipherSuite.mac(sSLEngineImpl.session().version);
            Deflater deflater = compressionMethod == CompressionMethod.ZLIB ? new Deflater() : null;
            cipher2.init(1, (Key)new SecretKeySpec(byArray[bl ? 2 : 3], cipherSuite.cipherAlgorithm().toString()), new IvParameterSpec(byArray[bl ? 4 : 5]));
            mac2.init(new SecretKeySpec(byArray[bl ? 0 : 1], mac2.getAlgorithm()));
            this.outParams = new OutputSecurityParameters(cipher2, mac2, deflater, sSLEngineImpl.session(), cipherSuite);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SSLException(invalidAlgorithmParameterException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SSLException(invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SSLException(noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new SSLException(noSuchPaddingException);
        }
    }

    protected void generatePSKSecret(String string, byte[] byArray, boolean bl) throws SSLException {
        Object object;
        Key key = null;
        try {
            key = this.engine.contextImpl.pskManager.getKey(string);
        }
        catch (KeyManagementException keyManagementException) {
            // empty catch block
        }
        if (key != null) {
            object = key.getEncoded();
            if (byArray == null) {
                byArray = new byte[((byte[])object).length];
            }
            this.preMasterSecret = new byte[byArray.length + ((byte[])object).length + 4];
            this.preMasterSecret[0] = (byte)(byArray.length >>> 8);
            this.preMasterSecret[1] = (byte)byArray.length;
            System.arraycopy(byArray, 0, this.preMasterSecret, 2, byArray.length);
            this.preMasterSecret[byArray.length + 2] = (byte)(((byte[])object).length >>> 8);
            this.preMasterSecret[byArray.length + 3] = (byte)((byte[])object).length;
            System.arraycopy(object, 0, this.preMasterSecret, byArray.length + 4, ((byte[])object).length);
        } else {
            this.preMasterSecret = new byte[8];
            this.preMasterSecret[1] = 2;
            this.preMasterSecret[5] = 2;
            this.preMasterSecret[6] = (byte)this.engine.session().random().nextInt();
            this.preMasterSecret[7] = (byte)this.engine.session().random().nextInt();
        }
        logger.logv(Component.SSL_KEY_EXCHANGE, "PSK identity {0} key {1}", string, key);
        this.generateMasterSecret(this.clientRandom, this.serverRandom, this.engine.session());
        object = this.generateKeys(this.clientRandom, this.serverRandom, this.engine.session());
        this.setupSecurityParameters((byte[][])object, bl, this.engine, this.compression);
    }

    static {
        Arrays.fill(PAD1, (byte)54);
        Arrays.fill(PAD2, (byte)92);
    }

    protected class DHE_PSKGen
    extends DelegatedTask {
        private final DHPublicKey dhKey;
        private final SecretKey psKey;
        private final boolean isClient;

        protected DHE_PSKGen(DHPublicKey dHPublicKey, SecretKey secretKey, boolean bl) {
            this.dhKey = dHPublicKey;
            this.psKey = secretKey;
            this.isClient = bl;
        }

        protected void implRun() throws Throwable {
            AbstractHandshake.this.keyAgreement.doPhase(this.dhKey, true);
            byte[] byArray = AbstractHandshake.this.keyAgreement.generateSecret();
            byte[] byArray2 = null;
            if (this.psKey != null) {
                byArray2 = this.psKey.getEncoded();
            } else {
                byArray2 = new byte[8];
                AbstractHandshake.this.engine.session().random().nextBytes(byArray2);
            }
            AbstractHandshake.this.preMasterSecret = new byte[byArray.length + byArray2.length + 4];
            AbstractHandshake.this.preMasterSecret[0] = (byte)(byArray.length >>> 8);
            AbstractHandshake.this.preMasterSecret[1] = (byte)byArray.length;
            System.arraycopy(byArray, 0, AbstractHandshake.this.preMasterSecret, 2, byArray.length);
            AbstractHandshake.this.preMasterSecret[byArray.length + 2] = (byte)(byArray2.length >>> 8);
            AbstractHandshake.this.preMasterSecret[byArray.length + 3] = (byte)byArray2.length;
            System.arraycopy(byArray2, 0, AbstractHandshake.this.preMasterSecret, byArray.length + 4, byArray2.length);
            AbstractHandshake.this.generateMasterSecret(AbstractHandshake.this.clientRandom, AbstractHandshake.this.serverRandom, AbstractHandshake.this.engine.session());
            byte[][] byArray3 = AbstractHandshake.this.generateKeys(AbstractHandshake.this.clientRandom, AbstractHandshake.this.serverRandom, AbstractHandshake.this.engine.session());
            AbstractHandshake.this.setupSecurityParameters(byArray3, this.isClient, AbstractHandshake.this.engine, AbstractHandshake.this.compression);
        }
    }

    protected class CertVerifier
    extends DelegatedTask {
        private final boolean clientSide;
        private final X509Certificate[] chain;
        private boolean verified;

        protected CertVerifier(boolean bl, X509Certificate[] x509CertificateArray) {
            this.clientSide = bl;
            this.chain = x509CertificateArray;
        }

        boolean verified() {
            return this.verified;
        }

        protected void implRun() {
            X509TrustManager x509TrustManager = AbstractHandshake.this.engine.contextImpl.trustManager;
            if (this.clientSide) {
                try {
                    x509TrustManager.checkServerTrusted(this.chain, null);
                    this.verified = true;
                }
                catch (CertificateException certificateException) {
                    Object object;
                    logger.log((Level)Component.SSL_DELEGATED_TASK, "cert verify", certificateException);
                    CallbackHandler callbackHandler = new DefaultCallbackHandler();
                    GetSecurityPropertyAction getSecurityPropertyAction = new GetSecurityPropertyAction("jessie.certificate.handler");
                    String string = AccessController.doPrivileged(getSecurityPropertyAction);
                    try {
                        object = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                            @Override
                            public ClassLoader run() throws Exception {
                                return ClassLoader.getSystemClassLoader();
                            }
                        });
                        callbackHandler = (CallbackHandler)((ClassLoader)object).loadClass(string).newInstance();
                    }
                    catch (Exception exception) {
                        logger.log((Level)Component.SSL_DELEGATED_TASK, "callback handler loading", exception);
                    }
                    object = new CertificateCallback(this.chain[0], "The server's certificate could not be verified. There is no proof that this server is who it claims to be, or that their certificate is valid. Do you wish to continue connecting? ");
                    try {
                        callbackHandler.handle(new Callback[]{object});
                        this.verified = ((ConfirmationCallback)object).getSelectedIndex() == 0;
                    }
                    catch (Exception exception) {
                        logger.log((Level)Component.SSL_DELEGATED_TASK, "callback handler exception", exception);
                        this.verified = false;
                    }
                }
            } else {
                try {
                    x509TrustManager.checkClientTrusted(this.chain, null);
                }
                catch (CertificateException certificateException) {
                    this.verified = false;
                }
            }
            if (this.verified) {
                AbstractHandshake.this.engine.session().setPeerVerified(true);
            }
        }
    }

    protected class DHPhase
    extends DelegatedTask {
        private final DHPublicKey key;
        private final boolean full;

        protected DHPhase(DHPublicKey dHPublicKey) {
            this(dHPublicKey, true);
        }

        protected DHPhase(DHPublicKey dHPublicKey, boolean bl) {
            this.key = dHPublicKey;
            this.full = bl;
        }

        protected void implRun() throws InvalidKeyException, SSLException {
            AbstractHandshake.this.keyAgreement.doPhase(this.key, true);
            AbstractHandshake.this.preMasterSecret = AbstractHandshake.this.keyAgreement.generateSecret();
            if (this.full) {
                AbstractHandshake.this.generateMasterSecret(AbstractHandshake.this.clientRandom, AbstractHandshake.this.serverRandom, AbstractHandshake.this.engine.session());
                byte[][] byArray = AbstractHandshake.this.generateKeys(AbstractHandshake.this.clientRandom, AbstractHandshake.this.serverRandom, AbstractHandshake.this.engine.session());
                AbstractHandshake.this.setupSecurityParameters(byArray, AbstractHandshake.this.engine.getUseClientMode(), AbstractHandshake.this.engine, AbstractHandshake.this.compression);
            }
        }
    }
}

