/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl;

import gnu.java.security.Requires;
import gnu.javax.net.ssl.Session;
import gnu.javax.net.ssl.SessionStoreException;
import gnu.javax.net.ssl.provider.SimpleSessionContext;
import java.util.Enumeration;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSessionContext
implements SSLSessionContext {
    protected long timeout;
    private static Class<? extends AbstractSessionContext> implClass = SimpleSessionContext.class;

    public static AbstractSessionContext newInstance() throws SSLException {
        try {
            return implClass.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SSLException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new SSLException(instantiationException);
        }
    }

    @Requires(permissionClass=SSLPermission.class, target="gnu.javax.net.ssl.AbstractSessionContext", action="setImplClass")
    public static synchronized void setImplClass(Class<? extends AbstractSessionContext> clazz) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SSLPermission("gnu.javax.net.ssl.AbstractSessionContext", "setImplClass"));
        }
        implClass = clazz;
    }

    protected AbstractSessionContext(int n) {
        this.setSessionTimeout(n);
    }

    @Override
    public final SSLSession getSession(byte[] byArray) {
        Session session = this.implGet(byArray);
        if (session != null && System.currentTimeMillis() - session.getLastAccessedTime() > this.timeout) {
            this.remove(byArray);
            return null;
        }
        return session;
    }

    public final SSLSession getSession(String string, int n) {
        Enumeration enumeration = this.getIds();
        while (enumeration.hasMoreElements()) {
            int n2;
            byte[] byArray = (byte[])enumeration.nextElement();
            SSLSession sSLSession = this.getSession(byArray);
            if (sSLSession == null) continue;
            String string2 = sSLSession.getPeerHost();
            if ((string != null ? !string.equals(string2) : string2 != null) || n != (n2 = sSLSession.getPeerPort())) continue;
            return sSLSession;
        }
        return null;
    }

    protected abstract Session implGet(byte[] var1);

    @Override
    public int getSessionTimeout() {
        return (int)(this.timeout / 1000L);
    }

    public abstract void load(char[] var1) throws SessionStoreException;

    public abstract void put(Session var1);

    public abstract void remove(byte[] var1);

    @Override
    public final void setSessionTimeout(int n) {
        if (this.timeout < 0L) {
            throw new IllegalArgumentException("timeout may not be negative");
        }
        this.timeout = (long)n * 1000L;
    }

    public abstract void store(char[] var1) throws SessionStoreException;
}

