/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.naming.ictxImpl.trans;

import gnu.java.lang.CPStringBuilder;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public class GnuName
implements Name {
    private static final long serialVersionUID = -3617482732056931635L;
    int hash;
    String[] content;
    int from;
    int length;

    protected GnuName() {
    }

    public GnuName(String[] stringArray) {
        this(stringArray, 0, stringArray.length);
    }

    public GnuName(String[] stringArray, int n, int n2) {
        this.content = stringArray;
        this.from = n;
        this.length = n2;
    }

    public Name add(int n, String string) throws InvalidNameException {
        String[] stringArray = new String[this.content.length + 1];
        System.arraycopy(this.content, this.from, stringArray, 0, n);
        stringArray[n] = string;
        System.arraycopy(this.content, this.from + n, stringArray, n + 1, this.length - n);
        this.content = stringArray;
        this.from = 0;
        this.length = this.content.length;
        this.hash = 0;
        return this;
    }

    public Name add(String string) throws InvalidNameException {
        String[] stringArray = new String[this.content.length + 1];
        System.arraycopy(this.content, this.from, stringArray, 0, this.length);
        stringArray[stringArray.length - 1] = string;
        this.content = stringArray;
        this.from = 0;
        this.length = this.content.length;
        this.hash = 0;
        return this;
    }

    public Name addAll(int n, Name name) throws InvalidNameException {
        String[] stringArray = new String[this.length + name.size()];
        System.arraycopy(this.content, this.from, stringArray, 0, n);
        int n2 = n;
        for (int i = 0; i < name.size(); ++i) {
            stringArray[n2] = name.get(i);
            ++n2;
        }
        System.arraycopy(this.content, this.from + n, stringArray, n2, this.length - n);
        this.length += name.size();
        this.hash = 0;
        this.content = stringArray;
        return this;
    }

    public Name addAll(Name name) throws InvalidNameException {
        String[] stringArray = new String[this.length + name.size()];
        System.arraycopy(this.content, this.from, stringArray, 0, this.length);
        int n = this.length;
        int n2 = 0;
        while (n < stringArray.length) {
            stringArray[n] = name.get(n2);
            ++n;
            ++n2;
        }
        this.length += name.size();
        this.hash = 0;
        this.content = stringArray;
        return this;
    }

    public int compareTo(Object object) {
        Name name = (Name)object;
        int n = Math.min(this.length, name.size());
        for (int i = 0; i < n; ++i) {
            int n2 = this.content[this.from + i].compareTo(name.get(i));
            if (n2 == 0) continue;
            return n2;
        }
        return this.length - name.size();
    }

    public boolean endsWith(Name name) {
        if (name.size() > this.length) {
            return false;
        }
        int n = this.length - name.size() + this.from;
        int n2 = 0;
        while (n2 < name.size()) {
            if (!this.content[n].equals(name.get(n2))) {
                return false;
            }
            ++n2;
            ++n;
        }
        return true;
    }

    public String get(int n) {
        return this.content[this.from + n];
    }

    public Enumeration getAll() {
        return new GnuNameEnum(0);
    }

    public Name getPrefix(int n) {
        return new GnuName(this.content, this.from, n);
    }

    public Name getSuffix(int n) {
        return new GnuName(this.content, this.from + n, this.length - n);
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public Object remove(int n) throws InvalidNameException {
        if (this.length == 0) {
            throw new InvalidNameException("negative size");
        }
        --this.length;
        if (n == 0) {
            ++this.from;
        } else if (n < this.length) {
            String[] stringArray = new String[this.length];
            System.arraycopy(this.content, this.from, stringArray, 0, n);
            System.arraycopy(this.content, this.from + n + 1, stringArray, n, this.length - n);
            this.content = stringArray;
            this.from = 0;
        }
        this.hash = 0;
        return this;
    }

    public int size() {
        return this.length;
    }

    public boolean startsWith(Name name) {
        if (name.size() > this.length) {
            return false;
        }
        for (int i = 0; i < name.size(); ++i) {
            if (this.content[this.from + i].equals(name.get(i))) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        return new GnuName(this.content, this.from, this.length);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Name) {
            Name name = (Name)object;
            if (this.length != name.size()) {
                return false;
            }
            for (int i = 0; i < this.length; ++i) {
                if (this.content[this.from + i].equals(name.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0 && this.length > 0) {
            int n = 0;
            for (int i = this.from; i < this.from + this.length; ++i) {
                n ^= this.content[i].hashCode();
            }
            this.hash = n;
        }
        return this.hash;
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        for (int i = 0; i < this.length; ++i) {
            cPStringBuilder.append(this.get(i));
            if (i >= this.length - 1) continue;
            cPStringBuilder.append('/');
        }
        return cPStringBuilder.toString();
    }

    class GnuNameEnum
    implements Enumeration {
        int nxt;

        GnuNameEnum(int n) {
            this.nxt = GnuName.this.from + n;
        }

        public boolean hasMoreElements() {
            return this.nxt >= 0;
        }

        public Object nextElement() {
            if (this.nxt < 0) {
                throw new NoSuchElementException();
            }
            String string = GnuName.this.content[this.nxt++];
            if (this.nxt - GnuName.this.from == GnuName.this.length) {
                this.nxt = -1;
            }
            return string;
        }
    }
}

