/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.management;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.management.JMX;
import javax.management.MBeanServerInvocationHandler;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Translator {
    public static final Object[] fromJava(Object[] objectArray, Method method) throws Throwable {
        Type[] typeArray = method.getGenericParameterTypes();
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = Translator.fromJava(objectArray[i], typeArray[i]);
        }
        return objectArray2;
    }

    public static final Object fromJava(Object object, Type type) throws Throwable {
        if (object == null) {
            return null;
        }
        Class<? extends Object> clazz = object.getClass();
        if (OpenType.ALLOWED_CLASSNAMES_LIST.contains(clazz.getName())) {
            return object;
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2.isPrimitive()) {
                return object;
            }
            if (OpenType.ALLOWED_CLASSNAMES_LIST.contains(clazz2.getName())) {
                return object;
            }
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = Translator.fromJava(objectArray[i], objectArray[i].getClass());
            }
            return Translator.makeArraySpecific(objectArray2);
        }
        String string = Translator.getTypeName(type);
        if (object instanceof List || object instanceof Set || object instanceof SortedSet) {
            Object object2;
            if (object instanceof SortedSet) {
                object2 = (ParameterizedType)type;
                Class clazz3 = (Class)object2.getActualTypeArguments()[0];
                if (!Comparable.class.isAssignableFrom(clazz3)) {
                    throw new IllegalArgumentException(object + " has a " + "non-comparable element " + "type, " + clazz3);
                }
                if (((SortedSet)object).comparator() != null) {
                    throw new IllegalArgumentException(object + " does not " + "use natural ordering.");
                }
            }
            object2 = (Collection)object;
            int n = object2.size();
            Object[] objectArray = new Object[n];
            Iterator iterator = object2.iterator();
            for (int i = 0; i < n; ++i) {
                Object e = iterator.next();
                objectArray[i] = Translator.fromJava(e, e.getClass());
            }
            return Translator.makeArraySpecific(objectArray);
        }
        if (object instanceof Enum) {
            return ((Enum)object).name();
        }
        if (object instanceof Map || object instanceof SortedMap) {
            Serializable serializable;
            int n = string.indexOf("<");
            int n2 = string.indexOf(",", n);
            int n3 = string.indexOf(">", n2);
            String string2 = string.substring(n + 1, n2).trim();
            String string3 = string.substring(n2 + 1, n3).trim();
            String string4 = null;
            if (object instanceof Map) {
                string4 = "java.util.Map" + string.substring(n);
            } else {
                serializable = Class.forName(string2);
                if (!Comparable.class.isAssignableFrom((Class<?>)serializable)) {
                    throw new IllegalArgumentException(object + " has a " + "non-comparable element " + "type, " + serializable);
                }
                if (((SortedMap)object).comparator() != null) {
                    throw new IllegalArgumentException(object + " does not " + "use natural ordering.");
                }
                string4 = "java.util.SortedMap" + string.substring(n);
            }
            serializable = Translator.translate(string2).getOpenType();
            OpenType<?> openType = Translator.translate(string3).getOpenType();
            CompositeType compositeType = new CompositeType(string4, string4, new String[]{"key", "value"}, new String[]{"Map key", "Map value"}, new OpenType[]{serializable, openType});
            TabularType tabularType = new TabularType(string4, string4, compositeType, new String[]{"key"});
            TabularDataSupport tabularDataSupport = new TabularDataSupport(tabularType);
            for (Map.Entry entry : ((Map)object).entrySet()) {
                try {
                    tabularDataSupport.put(new CompositeDataSupport(compositeType, new String[]{"key", "value"}, new Object[]{entry.getKey(), entry.getValue()}));
                }
                catch (OpenDataException openDataException) {
                    throw (InternalError)new InternalError("A problem occurred converting the map to a composite data structure.").initCause(openDataException);
                }
            }
            return tabularDataSupport;
        }
        if (JMX.isMXBeanInterface(clazz)) {
            try {
                MBeanServerInvocationHandler mBeanServerInvocationHandler = (MBeanServerInvocationHandler)Proxy.getInvocationHandler(object);
                return mBeanServerInvocationHandler.getObjectName();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("For a MXBean to be translated to an open type, it must be a proxy.", illegalArgumentException);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("For a MXBean to be translated to an open type, it must have a MBeanServerInvocationHandler.", classCastException);
            }
        }
        throw new IllegalArgumentException("The type, " + object + ", is not convertible.");
    }

    public static final Object toJava(Object object, Method method) throws Throwable {
        Object object2;
        Object object3;
        Class<?> clazz = method.getReturnType();
        if (clazz.isEnum()) {
            object3 = (Object[])object;
            for (Object object4 : object2 = (Enum[])clazz.getEnumConstants()) {
                if (!((Enum)object4).name().equals(object3)) continue;
                return object4;
            }
        }
        if (List.class.isAssignableFrom(clazz)) {
            object3 = (Object[])object;
            object2 = new ArrayList(((Object[])object3).length);
            for (Object object4 : object3) {
                object2.add(object4);
            }
            return object2;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            object3 = (TabularData)object;
            object2 = new HashMap(object3.size());
            for (Object e : object3.values()) {
                CompositeData compositeData = (CompositeData)e;
                object2.put(compositeData.get("key"), compositeData.get("value"));
            }
            return object2;
        }
        try {
            object3 = clazz.getMethod("from", CompositeData.class);
            return ((Method)object3).invoke(null, (CompositeData)object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return object;
        }
    }

    private static final Object[] makeArraySpecific(Object[] objectArray) {
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray[0].getClass(), objectArray.length);
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        return objectArray2;
    }

    public static final OpenMBeanParameterInfo translate(String string) throws OpenDataException {
        Object object;
        Class<?> clazz;
        if (string.equals("boolean") || string.equals(Boolean.class.getName())) {
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", SimpleType.BOOLEAN, null, new Boolean[]{Boolean.TRUE, Boolean.FALSE});
        }
        if (string.equals("byte") || string.equals(Byte.class.getName())) {
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", SimpleType.BYTE, null, Byte.valueOf((byte)-128), Byte.valueOf((byte)127));
        }
        if (string.equals("char") || string.equals(Character.class.getName())) {
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", SimpleType.CHARACTER, null, Character.valueOf('\u0000'), Character.valueOf('\uffff'));
        }
        if (string.equals("double") || string.equals(Double.class.getName())) {
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", SimpleType.DOUBLE, null, Double.valueOf(Double.MIN_VALUE), Double.valueOf(Double.MAX_VALUE));
        }
        if (string.equals("float") || string.equals(Float.class.getName())) {
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", SimpleType.FLOAT, null, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
        }
        if (string.equals("int") || string.equals(Integer.class.getName())) {
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", SimpleType.INTEGER, null, Integer.valueOf(Integer.MIN_VALUE), Integer.valueOf(Integer.MAX_VALUE));
        }
        if (string.equals("long") || string.equals(Long.class.getName())) {
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", SimpleType.LONG, null, Long.valueOf(Long.MIN_VALUE), Long.valueOf(Long.MAX_VALUE));
        }
        if (string.equals("short") || string.equals(Short.class.getName())) {
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", SimpleType.SHORT, null, Short.valueOf((short)Short.MIN_VALUE), Short.valueOf((short)Short.MAX_VALUE));
        }
        if (string.equals(String.class.getName())) {
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", SimpleType.STRING);
        }
        if (string.equals("void")) {
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", SimpleType.VOID);
        }
        if (string.startsWith("java.util.Map")) {
            int n = string.indexOf("<");
            int n2 = string.indexOf(",", n);
            int n3 = string.indexOf(">", n2);
            String string2 = string.substring(n + 1, n2).trim();
            OpenType<?> openType = Translator.translate(string2).getOpenType();
            OpenType<?> openType2 = Translator.translate(string.substring(n2 + 1, n3).trim()).getOpenType();
            CompositeType compositeType = new CompositeType(Map.class.getName(), Map.class.getName(), new String[]{"key", "value"}, new String[]{"Map key", "Map value"}, new OpenType[]{openType, openType2});
            TabularType tabularType = new TabularType(string2, string2, compositeType, new String[]{"key"});
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", tabularType);
        }
        if (string.startsWith("java.util.List")) {
            int n = string.indexOf("<");
            int n4 = string.indexOf(">");
            OpenType<?> openType = Translator.translate(string.substring(n + 1, n4).trim()).getOpenType();
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", new ArrayType(1, openType));
        }
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw (InternalError)new InternalError("The class for a type used in a management bean could not be loaded.").initCause(classNotFoundException);
        }
        if (clazz.isEnum()) {
            ?[] objArray = clazz.getEnumConstants();
            String[] stringArray = new String[objArray.length];
            for (int i = 0; i < objArray.length; ++i) {
                stringArray[i] = objArray[i].toString();
            }
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", SimpleType.STRING, null, stringArray);
        }
        if (clazz.isArray()) {
            int n = 0;
            while (clazz.getName().charAt(n) == '[') {
                ++n;
            }
            OpenType<?> openType = Translator.getTypeFromClass(clazz.getComponentType());
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", new ArrayType(n, openType));
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < methodArray.length; ++i) {
            object = methodArray[i].getName();
            if (!Modifier.isPublic(methodArray[i].getModifiers())) continue;
            if (((String)object).startsWith("get")) {
                arrayList.add(((String)object).substring(3));
                arrayList2.add(Translator.getTypeFromClass(methodArray[i].getReturnType()));
                continue;
            }
            if (!((String)object).startsWith("is")) continue;
            arrayList.add(((String)object).substring(2));
            arrayList2.add(Translator.getTypeFromClass(methodArray[i].getReturnType()));
        }
        if (arrayList.isEmpty()) {
            throw new OpenDataException("The type used does not have an open type translation.");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        object = new CompositeType(clazz.getName(), clazz.getName(), stringArray, stringArray, arrayList2.toArray(new OpenType[arrayList2.size()]));
        return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", (OpenType<?>)object);
    }

    private static final OpenType<?> getTypeFromClass(Class<?> clazz) throws OpenDataException {
        return Translator.translate(clazz.getName()).getOpenType();
    }

    private static final String getTypeName(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                StringBuilder stringBuilder = new StringBuilder(clazz.getComponentType().getName());
                String string = clazz.getName();
                for (int i = 0; i < string.length() && string.charAt(i) == '['; ++i) {
                    stringBuilder.append("[]");
                }
                return stringBuilder.toString();
            }
            return clazz.getName();
        }
        return type.toString();
    }
}

