/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.management;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidApplicationException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanPermission;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MBeanTrustPermission;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.StandardMBean;
import javax.management.loading.ClassLoaderRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
implements MBeanServer {
    private static final ObjectName DELEGATE_NAME;
    private final ConcurrentHashMap<ObjectName, ServerInfo> beans = new ConcurrentHashMap();
    private final String defaultDomain;
    private final MBeanServer outer;
    private ClassLoaderRepository repository;
    private final MBeanServerDelegate delegate;
    private static final AtomicLong sequenceNumber;

    public Server(String string, MBeanServer mBeanServer, MBeanServerDelegate mBeanServerDelegate) {
        this.defaultDomain = string;
        this.outer = mBeanServer;
        this.delegate = mBeanServerDelegate;
        try {
            this.registerMBean(mBeanServerDelegate, DELEGATE_NAME);
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw (Error)new InternalError("The delegate bean is already registered.").initCause(instanceAlreadyExistsException);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw (Error)new InternalError("The delegate bean's preRegister methods threw an exception.").initCause(mBeanRegistrationException);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw (Error)new InternalError("The delegate bean is not compliant.").initCause(notCompliantMBeanException);
        }
    }

    private void checkSecurity(ObjectName objectName, String string, String string2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                MBeanInfo mBeanInfo = null;
                if (objectName != null) {
                    Object object = this.getBean(objectName);
                    Method method = object.getClass().getMethod("getMBeanInfo", new Class[0]);
                    mBeanInfo = (MBeanInfo)method.invoke(object, new Object[0]);
                }
                securityManager.checkPermission(new MBeanPermission(mBeanInfo == null ? null : mBeanInfo.getClassName(), string, objectName, string2));
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                throw (Error)new InternalError("Failed to get bean.").initCause(instanceNotFoundException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw (Error)new InternalError("Failed to get bean info.").initCause(noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw (Error)new InternalError("Failed to get bean info.").initCause(illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (Error)new InternalError("Failed to get bean info.").initCause(illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw (Error)new InternalError("Failed to get bean info.").initCause(invocationTargetException);
            }
        }
    }

    private Object getBean(ObjectName objectName) throws InstanceNotFoundException {
        ServerInfo serverInfo = this.beans.get(objectName);
        if (serverInfo == null) {
            throw new InstanceNotFoundException("The bean, " + objectName + ", was not found.");
        }
        return serverInfo.getObject();
    }

    @Override
    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        Object object2 = this.getBean(objectName);
        this.checkSecurity(objectName, null, "addNotificationListener");
        if (object2 instanceof NotificationBroadcaster) {
            NotificationBroadcaster notificationBroadcaster = (NotificationBroadcaster)object2;
            ServerNotificationListener serverNotificationListener = new ServerNotificationListener(object2, objectName, notificationListener);
            notificationBroadcaster.addNotificationListener(serverNotificationListener, notificationFilter, object);
            LazyListenersHolder.listeners.put(notificationListener, serverNotificationListener);
        }
    }

    @Override
    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        Object object2 = this.getBean(objectName2);
        if (!(object2 instanceof NotificationListener)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The supplied listener name does not correspond to a notification listener.");
            throw new RuntimeOperationsException(illegalArgumentException);
        }
        this.addNotificationListener(objectName, (NotificationListener)object2, notificationFilter, object);
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.createMBean(string, objectName, null, null);
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.registerMBean(this.instantiate(string, objectArray, stringArray), objectName);
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.createMBean(string, objectName, objectName2, null, null);
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.registerMBean(this.instantiate(string, objectName2, objectArray, stringArray), objectName);
    }

    @Override
    public ObjectInputStream deserialize(ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException {
        try {
            return new ServerInputStream(new ByteArrayInputStream(byArray), this.getClassLoaderFor(objectName));
        }
        catch (IOException iOException) {
            throw new OperationsException("An I/O error occurred: " + iOException);
        }
    }

    @Override
    public ObjectInputStream deserialize(String string, byte[] byArray) throws OperationsException, ReflectionException {
        try {
            Class<?> clazz = this.getClassLoaderRepository().loadClass(string);
            return new ServerInputStream(new ByteArrayInputStream(byArray), clazz.getClassLoader());
        }
        catch (IOException iOException) {
            throw new OperationsException("An I/O error occurred: " + iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException, "The class could not be found.");
        }
    }

    @Override
    public ObjectInputStream deserialize(String string, ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, ReflectionException, OperationsException {
        try {
            Class<?> clazz = this.getClassLoader(objectName).loadClass(string);
            return new ServerInputStream(new ByteArrayInputStream(byArray), clazz.getClassLoader());
        }
        catch (IOException iOException) {
            throw new OperationsException("An I/O error occurred: " + iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException, "The class could not be found.");
        }
    }

    @Override
    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        if (objectName == null || string == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("One of the supplied arguments was null.");
            throw new RuntimeOperationsException(illegalArgumentException);
        }
        Object object = this.getBean(objectName);
        this.checkSecurity(objectName, string, "getAttribute");
        if (object instanceof DynamicMBean) {
            return ((DynamicMBean)object).getAttribute(string);
        }
        try {
            return new StandardMBean(object, null).getAttribute(string);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw (Error)new InternalError("Failed to create dynamic bean.").initCause(notCompliantMBeanException);
        }
    }

    @Override
    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        if (objectName == null || stringArray == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("One of the supplied arguments was null.");
            throw new RuntimeOperationsException(illegalArgumentException);
        }
        Object object = this.getBean(objectName);
        this.checkSecurity(objectName, null, "getAttribute");
        AttributeList attributeList = new AttributeList(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object2;
            if (stringArray[i] == null) {
                object2 = new IllegalArgumentException("Argument " + i + " was null.");
                throw new RuntimeOperationsException((RuntimeException)object2);
            }
            this.checkSecurity(objectName, stringArray[i], "getAttribute");
            try {
                if (object instanceof DynamicMBean) {
                    object2 = ((DynamicMBean)object).getAttribute(stringArray[i]);
                } else {
                    try {
                        object2 = new StandardMBean(object, null).getAttribute(stringArray[i]);
                    }
                    catch (NotCompliantMBeanException notCompliantMBeanException) {
                        throw (Error)new InternalError("Failed to create dynamic bean.").initCause(notCompliantMBeanException);
                    }
                }
                attributeList.add(new Attribute(stringArray[i], object2));
                continue;
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                continue;
            }
            catch (MBeanException mBeanException) {
                // empty catch block
            }
        }
        return attributeList;
    }

    @Override
    public ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        if (objectName == null) {
            this.checkSecurity(null, null, "getClassLoader");
            return this.getClass().getClassLoader();
        }
        Object object = this.getBean(objectName);
        this.checkSecurity(objectName, null, "getClassLoader");
        return (ClassLoader)object;
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        Object object = this.getBean(objectName);
        this.checkSecurity(objectName, null, "getClassLoaderFor");
        return object.getClass().getClassLoader();
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        return this.repository;
    }

    @Override
    public String getDefaultDomain() {
        return this.defaultDomain;
    }

    @Override
    public String[] getDomains() {
        this.checkSecurity(null, null, "getDomains");
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<ObjectName> iterator = this.beans.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().getDomain();
            try {
                this.checkSecurity(new ObjectName(string + ":x=x"), null, "getDomains");
                hashSet.add(string);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {}
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    @Override
    public Integer getMBeanCount() {
        return this.beans.size();
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        Object object = this.getBean(objectName);
        this.checkSecurity(objectName, null, "getMBeanInfo");
        try {
            Method method = object.getClass().getMethod("getMBeanInfo", new Class[0]);
            return (MBeanInfo)method.invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                return new StandardMBean(object, null).getMBeanInfo();
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new IntrospectionException("An error occurred in executing getMBeanInfo on the bean: " + notCompliantMBeanException + ".");
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException, "Failed to call getMBeanInfo");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectionException(illegalArgumentException, "Failed to call getMBeanInfo");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ReflectionException(invocationTargetException, "The method threw an exception");
        }
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        ServerInfo serverInfo = this.beans.get(objectName);
        if (serverInfo == null) {
            throw new InstanceNotFoundException("The bean, " + objectName + ", was not found.");
        }
        return serverInfo.getInstance();
    }

    @Override
    public Object instantiate(String string) throws ReflectionException, MBeanException {
        return this.instantiate(string, null, null);
    }

    @Override
    public Object instantiate(String string, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException {
        this.checkSecurity(null, null, "instantiate");
        if (string == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The name was null.");
            throw new RuntimeOperationsException(illegalArgumentException);
        }
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            try {
                classArray[i] = this.repository.loadClass(stringArray[i]);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ReflectionException(classNotFoundException, "The class, " + classArray[i] + ", in the method signature " + "could not be loaded.");
            }
        }
        try {
            Constructor<?> constructor = this.repository.loadClass(string).getConstructor(classArray);
            return constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException, "The class, " + string + ", of the constructor " + "could not be loaded.");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException(noSuchMethodException, "The method, " + string + ", could not be found.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException, "Failed to instantiate the object");
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectionException(instantiationException, "Failed to instantiate the object");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new MBeanException((Exception)invocationTargetException.getCause(), "The constructor " + string + " threw an exception");
        }
    }

    @Override
    public Object instantiate(String string, ObjectName objectName) throws InstanceNotFoundException, ReflectionException, MBeanException {
        return this.instantiate(string, objectName);
    }

    @Override
    public Object instantiate(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, ReflectionException, MBeanException {
        this.checkSecurity(null, null, "instantiate");
        if (string == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The name was null.");
            throw new RuntimeOperationsException(illegalArgumentException);
        }
        ClassLoader classLoader = this.getClassLoader(objectName);
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                classArray[i] = Class.forName(stringArray[i], true, classLoader);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ReflectionException(classNotFoundException, "The class, " + stringArray[i] + ", in the method signature " + "could not be loaded.");
            }
        }
        try {
            Constructor<?> constructor = Class.forName(string, true, classLoader).getConstructor(classArray);
            return constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException, "The class, " + string + ", of the constructor " + "could not be loaded.");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException(noSuchMethodException, "The method, " + string + ", could not be found.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException, "Failed to instantiate the object");
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectionException(instantiationException, "Failed to instantiate the object");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new MBeanException((Exception)invocationTargetException.getCause(), "The constructor " + string + " threw an exception");
        }
    }

    @Override
    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (objectName == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The bean was null.");
            throw new RuntimeOperationsException(illegalArgumentException);
        }
        Object object = this.getBean(objectName);
        this.checkSecurity(objectName, string, "invoke");
        if (object instanceof DynamicMBean) {
            return ((DynamicMBean)object).invoke(string, objectArray, stringArray);
        }
        try {
            return new StandardMBean(object, null).invoke(string, objectArray, stringArray);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw (Error)new InternalError("Failed to create dynamic bean.").initCause(notCompliantMBeanException);
        }
    }

    @Override
    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        MBeanInfo mBeanInfo;
        Object object = this.getBean(objectName);
        this.checkSecurity(objectName, null, "isInstanceOf");
        if (object instanceof DynamicMBean) {
            mBeanInfo = ((DynamicMBean)object).getMBeanInfo();
        } else {
            try {
                mBeanInfo = new StandardMBean(object, null).getMBeanInfo();
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw (Error)new InternalError("Failed to create dynamic bean.").initCause(notCompliantMBeanException);
            }
        }
        if (mBeanInfo.getClassName().equals(string)) {
            return true;
        }
        Class<? extends Object> clazz = object.getClass();
        try {
            Class<? extends Object> clazz2 = Class.forName(string);
            return clazz.getClassLoader().equals(clazz2.getClassLoader()) && clazz2.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Override
    public boolean isRegistered(ObjectName objectName) {
        if (objectName == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The name was null.");
            throw new RuntimeOperationsException(illegalArgumentException);
        }
        return this.beans.containsKey(objectName);
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName objectName, QueryExp queryExp) {
        this.checkSecurity(objectName, null, "queryMBeans");
        HashSet<ObjectInstance> hashSet = new HashSet<ObjectInstance>();
        for (Map.Entry<ObjectName, ServerInfo> entry : this.beans.entrySet()) {
            ObjectName objectName2 = entry.getKey();
            this.checkSecurity(objectName, objectName2.toString(), "queryMBeans");
            try {
                if (objectName != null && !objectName.apply(objectName2) || queryExp != null && !queryExp.apply(objectName2)) continue;
                hashSet.add(entry.getValue().getInstance());
            }
            catch (BadStringOperationException badStringOperationException) {
            }
            catch (BadBinaryOpValueExpException badBinaryOpValueExpException) {
            }
            catch (BadAttributeValueExpException badAttributeValueExpException) {
            }
            catch (InvalidApplicationException invalidApplicationException) {}
        }
        return hashSet;
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName objectName, QueryExp queryExp) {
        this.checkSecurity(objectName, null, "queryNames");
        HashSet<ObjectName> hashSet = new HashSet<ObjectName>();
        for (ObjectName objectName2 : this.beans.keySet()) {
            this.checkSecurity(objectName, objectName2.toString(), "queryNames");
            try {
                if (objectName != null && !objectName.apply(objectName2) || queryExp != null && !queryExp.apply(objectName2)) continue;
                hashSet.add(objectName2);
            }
            catch (BadStringOperationException badStringOperationException) {
            }
            catch (BadBinaryOpValueExpException badBinaryOpValueExpException) {
            }
            catch (BadAttributeValueExpException badAttributeValueExpException) {
            }
            catch (InvalidApplicationException invalidApplicationException) {}
        }
        return hashSet;
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectInstance objectInstance;
        SecurityManager securityManager = System.getSecurityManager();
        Class<? extends Object> clazz = object.getClass();
        String string = clazz.getName();
        if (securityManager != null) {
            securityManager.checkPermission(new MBeanPermission(string, null, objectName, "registerMBean"));
            if (!clazz.getProtectionDomain().implies(new MBeanTrustPermission("register"))) {
                throw new SecurityException("The protection domain of the object's classdoes not imply the trust permission,register");
            }
        }
        if (object == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The object was null.");
            throw new RuntimeOperationsException(illegalArgumentException);
        }
        MBeanRegistration mBeanRegistration = null;
        if (object instanceof MBeanRegistration) {
            mBeanRegistration = (MBeanRegistration)object;
        }
        if (objectName == null && mBeanRegistration == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The name was null and the bean does not implement MBeanRegistration.");
            throw new RuntimeOperationsException(illegalArgumentException);
        }
        if (mBeanRegistration != null) {
            try {
                objectName = mBeanRegistration.preRegister(this, objectName);
                if (objectName == null) {
                    NullPointerException nullPointerException = new NullPointerException("The name returned by MBeanRegistration.preRegister() was null");
                    throw nullPointerException;
                }
                if (securityManager != null) {
                    securityManager.checkPermission(new MBeanPermission(string, null, objectName, "registerMBean"));
                }
            }
            catch (SecurityException securityException) {
                mBeanRegistration.postRegister(Boolean.FALSE);
                throw securityException;
            }
            catch (Exception exception) {
                mBeanRegistration.postRegister(Boolean.FALSE);
                throw new MBeanRegistrationException(exception, "Pre-registration failed.");
            }
        }
        if (this.beans.putIfAbsent(objectName, new ServerInfo(objectInstance = new ObjectInstance(objectName, string), object)) != null) {
            if (mBeanRegistration != null) {
                mBeanRegistration.postRegister(Boolean.FALSE);
            }
            throw new InstanceAlreadyExistsException(objectName + "is already registered.");
        }
        if (mBeanRegistration != null) {
            mBeanRegistration.postRegister(Boolean.TRUE);
        }
        this.notify(objectName, "JMX.mbean.registered");
        return objectInstance;
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        Object object = this.getBean(objectName);
        this.checkSecurity(objectName, null, "removeNotificationListener");
        if (object instanceof NotificationBroadcaster) {
            NotificationBroadcaster notificationBroadcaster = (NotificationBroadcaster)object;
            notificationBroadcaster.removeNotificationListener(notificationListener);
            LazyListenersHolder.listeners.remove(notificationListener);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        Object object2 = this.getBean(objectName);
        this.checkSecurity(objectName, null, "removeNotificationListener");
        if (object2 instanceof NotificationEmitter) {
            NotificationEmitter notificationEmitter = (NotificationEmitter)object2;
            notificationEmitter.removeNotificationListener(notificationListener, notificationFilter, object);
            LazyListenersHolder.listeners.remove(notificationListener);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException {
        Object object = this.getBean(objectName2);
        if (!(object instanceof NotificationListener)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The supplied listener name does not correspond to a notification listener.");
            throw new RuntimeOperationsException(illegalArgumentException);
        }
        this.removeNotificationListener(objectName, (NotificationListener)object);
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        Object object2 = this.getBean(objectName2);
        if (!(object2 instanceof NotificationListener)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The supplied listener name does not correspond to a notification listener.");
            throw new RuntimeOperationsException(illegalArgumentException);
        }
        this.removeNotificationListener(objectName, (NotificationListener)object2, notificationFilter, object);
    }

    @Override
    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null || objectName == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("One of the supplied arguments was null.");
            throw new RuntimeOperationsException(illegalArgumentException);
        }
        Object object = this.getBean(objectName);
        this.checkSecurity(objectName, attribute.getName(), "setAttribute");
        if (object instanceof DynamicMBean) {
            ((DynamicMBean)object).setAttribute(attribute);
        } else {
            try {
                new StandardMBean(object, null).setAttribute(attribute);
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw (Error)new InternalError("Failed to create dynamic bean.").initCause(notCompliantMBeanException);
            }
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        if (objectName == null || attributeList == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("One of the supplied arguments was null.");
            throw new RuntimeOperationsException(illegalArgumentException);
        }
        Object object = this.getBean(objectName);
        this.checkSecurity(objectName, null, "setAttribute");
        AttributeList attributeList2 = new AttributeList(attributeList.size());
        Iterator iterator = attributeList.iterator();
        while (iterator.hasNext()) {
            try {
                Attribute attribute = (Attribute)iterator.next();
                if (attribute == null) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("An attribute was null.");
                    throw new RuntimeOperationsException(illegalArgumentException);
                }
                this.checkSecurity(objectName, attribute.getName(), "setAttribute");
                if (object instanceof DynamicMBean) {
                    ((DynamicMBean)object).setAttribute(attribute);
                } else {
                    try {
                        new StandardMBean(object, null).setAttribute(attribute);
                    }
                    catch (NotCompliantMBeanException notCompliantMBeanException) {
                        throw (Error)new InternalError("Failed to create dynamic bean.").initCause(notCompliantMBeanException);
                    }
                }
                attributeList2.add(attribute);
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
            }
            catch (MBeanException mBeanException) {}
        }
        return attributeList2;
    }

    @Override
    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        if (objectName == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The name was null.");
            throw new RuntimeOperationsException(illegalArgumentException);
        }
        if (objectName.equals(DELEGATE_NAME)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The delegate can not be unregistered.");
            throw new RuntimeOperationsException(illegalArgumentException);
        }
        Object object = this.getBean(objectName);
        this.checkSecurity(objectName, null, "unregisterMBean");
        MBeanRegistration mBeanRegistration = null;
        if (object instanceof MBeanRegistration) {
            mBeanRegistration = (MBeanRegistration)object;
            try {
                mBeanRegistration.preDeregister();
            }
            catch (Exception exception) {
                throw new MBeanRegistrationException(exception, "Pre-deregistration failed.");
            }
        }
        this.beans.remove(objectName);
        this.notify(objectName, "JMX.mbean.unregistered");
        if (mBeanRegistration != null) {
            mBeanRegistration.postDeregister();
        }
    }

    private void notify(ObjectName objectName, String string) {
        this.delegate.sendNotification(new MBeanServerNotification(string, (Object)DELEGATE_NAME, sequenceNumber.getAndIncrement(), objectName));
    }

    static {
        sequenceNumber = new AtomicLong(1L);
        try {
            DELEGATE_NAME = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw (Error)new InternalError("Failed to construct the delegate's object name.").initCause(malformedObjectNameException);
        }
    }

    private class ServerNotificationListener
    implements NotificationListener {
        Object bean;
        ObjectName name;
        NotificationListener listener;

        public ServerNotificationListener(Object object, ObjectName objectName, NotificationListener notificationListener) {
            this.bean = object;
            this.name = objectName;
            this.listener = notificationListener;
        }

        public void handleNotification(Notification notification, Object object) {
            if (notification.getSource() == this.bean) {
                notification.setSource(this.name);
            }
            this.listener.handleNotification(notification, object);
        }
    }

    private class ServerInfo {
        private ObjectInstance instance;
        private Object object;

        public ServerInfo(ObjectInstance objectInstance, Object object) {
            this.instance = objectInstance;
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }

        public ObjectInstance getInstance() {
            return this.instance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServerInputStream
    extends ObjectInputStream {
        private ClassLoader cl;

        public ServerInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException, StreamCorruptedException {
            super(inputStream);
            this.cl = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws ClassNotFoundException, IOException {
            try {
                return Class.forName(objectStreamClass.getName(), true, this.cl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.resolveClass(objectStreamClass);
            }
        }
    }

    private static class LazyListenersHolder {
        private static final Map<NotificationListener, NotificationListener> listeners = new ConcurrentHashMap<NotificationListener, NotificationListener>();

        private LazyListenersHolder() {
        }
    }
}

