/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.png;

import gnu.javax.imageio.png.PNGChunk;
import gnu.javax.imageio.png.PNGException;

public class PNGHeader
extends PNGChunk {
    private int width;
    private int height;
    private int depth;
    private int colorType;
    private int compression;
    private int filter;
    private int interlace;
    public static final int INTERLACE_NONE = 0;
    public static final int INTERLACE_ADAM7 = 1;
    public static final int GRAYSCALE = 0;
    public static final int RGB = 2;
    public static final int INDEXED = 3;
    public static final int GRAYSCALE_WITH_ALPHA = 4;
    public static final int RGB_WITH_ALPHA = 6;

    protected PNGHeader(int n, byte[] byArray, int n2) throws PNGException {
        super(n, byArray, n2);
        if (byArray.length < 13) {
            throw new PNGException("Unexpectedly short header chunk. (" + byArray.length + " bytes)");
        }
        this.width = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        this.height = (byArray[4] & 0xFF) << 24 | (byArray[5] & 0xFF) << 16 | (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
        this.depth = byArray[8] & 0xFF;
        this.colorType = byArray[9] & 0xFF;
        this.compression = byArray[10] & 0xFF;
        this.filter = byArray[11] & 0xFF;
        this.interlace = byArray[12] & 0xFF;
    }

    public PNGHeader(int n, int n2, int n3, int n4, boolean bl) {
        super(1229472850);
        this.data = new byte[13];
        this.width = n;
        this.height = n2;
        this.depth = n3;
        this.filter = 0;
        this.compression = 0;
        this.colorType = n4;
        this.interlace = bl ? 1 : 0;
        byte[] byArray = PNGHeader.getInt(n);
        byte[] byArray2 = PNGHeader.getInt(n2);
        this.data[0] = byArray[0];
        this.data[1] = byArray[1];
        this.data[2] = byArray[2];
        this.data[3] = byArray[3];
        this.data[4] = byArray2[0];
        this.data[5] = byArray2[1];
        this.data[6] = byArray2[2];
        this.data[7] = byArray2[3];
        this.data[8] = (byte)n3;
        this.data[9] = (byte)n4;
        this.data[10] = (byte)this.compression;
        this.data[11] = (byte)this.filter;
        this.data[12] = (byte)this.interlace;
    }

    public boolean isValidChunk() {
        if (!super.isValidChunk()) {
            return false;
        }
        if (this.width == 0 || this.height == 0) {
            return false;
        }
        if ((this.colorType & 0xFFFFFFF8) != 0 || this.colorType == 5 || this.colorType == 1) {
            return false;
        }
        if (this.depth != 1 && this.depth != 2 && this.depth != 4 && this.depth != 8 && this.depth != 16) {
            return false;
        }
        if (this.colorType == 3 && this.depth == 16) {
            return false;
        }
        if ((this.colorType == 2 || this.colorType == 4 || this.colorType == 6) && this.depth < 8) {
            return false;
        }
        if (this.compression != 0 || this.filter != 0) {
            return false;
        }
        return (this.interlace & 0xFFFFFFFE) == 0;
    }

    public boolean isIndexed() {
        return this.colorType == 3;
    }

    public boolean isGrayscale() {
        return this.colorType == 0 || this.colorType == 4;
    }

    public int getColorType() {
        return this.colorType;
    }

    public boolean isInterlaced() {
        return this.interlace != 0;
    }

    public int bytesPerPixel() {
        switch (this.colorType) {
            case 4: {
                return this.depth * 2 >> 3;
            }
            case 2: {
                return this.depth * 3 >> 3;
            }
            case 6: {
                return this.depth * 4 >> 3;
            }
        }
        int n = this.depth >> 3;
        if (n > 0) {
            return n;
        }
        return 1;
    }

    public int getScanlineStride() {
        long l = 0L;
        switch (this.colorType) {
            case 0: {
                l = this.width * this.depth;
                break;
            }
            case 2: {
                l = this.width * this.depth * 3;
                break;
            }
            case 3: {
                l = this.depth * this.width;
                break;
            }
            case 4: {
                l = this.depth * this.width * 2;
                break;
            }
            case 6: {
                l = this.depth * this.width * 4;
            }
        }
        if ((l & 7L) != 0L) {
            l += 8L - (l & 7L);
        }
        return (int)(l >> 3);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }

    public String toString() {
        return "Header Chunk. Image width:" + this.width + " height:" + this.height + " depth:" + this.depth + " color type:" + this.colorType + " compression type:" + this.compression + " filter type:" + this.filter + " interlace:" + this.interlace;
    }
}

