/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.png;

import gnu.javax.imageio.png.PNGData;
import gnu.javax.imageio.png.PNGException;
import gnu.javax.imageio.png.PNGFilter;
import gnu.javax.imageio.png.PNGHeader;
import gnu.javax.imageio.png.PNGICCProfile;
import gnu.javax.imageio.png.PNGPalette;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.Vector;
import java.util.zip.Deflater;

public class PNGEncoder {
    private static final int defaultChunkSize = 8192;
    private PNGHeader header;
    private PNGPalette palette;
    private int stride;
    private int bpp;
    private byte[] rawData;
    private PNGICCProfile profile;

    public PNGEncoder(BufferedImage bufferedImage) throws PNGException {
        int n;
        ColorModel colorModel = bufferedImage.getColorModel();
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int n4 = 0;
        boolean bl = false;
        if (colorModel instanceof IndexColorModel) {
            n = 3;
            int n5 = ((IndexColorModel)colorModel).getMapSize();
            if (n5 <= 2) {
                n4 = 1;
            } else if (n5 <= 4) {
                n4 = 2;
            } else if (n5 <= 16) {
                n4 = 4;
            } else if (n5 <= 256) {
                n4 = 8;
            } else {
                throw new PNGException("Depth must be <= 8 bits for indexed color.");
            }
            this.palette = new PNGPalette((IndexColorModel)colorModel);
        } else {
            ColorSpace colorSpace;
            ColorSpace colorSpace2 = colorModel.getColorSpace();
            n = colorSpace2 == (colorSpace = ColorSpace.getInstance(1003)) || bufferedImage.getType() == 10 || bufferedImage.getType() == 11 ? (colorModel.hasAlpha() ? 4 : 0) : (colorModel.hasAlpha() ? 6 : 2);
            int[] nArray = colorModel.getComponentSize();
            n4 = nArray[0];
            for (int i = 1; i < nArray.length; ++i) {
                if (nArray[i] <= n4) continue;
                n4 = nArray[i];
            }
            if (colorSpace2 != colorSpace && !colorSpace2.isCS_sRGB() && colorSpace2 instanceof ICC_ColorSpace) {
                this.profile = new PNGICCProfile(((ICC_ColorSpace)colorSpace2).getProfile());
            }
        }
        this.header = new PNGHeader(n2, n3, n4, n, bl);
        this.stride = this.header.getScanlineStride();
        this.bpp = this.header.bytesPerPixel();
        this.getRawData(bufferedImage);
    }

    public PNGHeader getHeader() {
        return this.header;
    }

    public PNGPalette getPalette() {
        return this.palette;
    }

    public PNGICCProfile getProfile() {
        return this.profile;
    }

    public Vector encodeImage() {
        PNGData pNGData;
        Object object;
        Deflater deflater = new Deflater();
        boolean bl = PNGFilter.useFilter(this.header);
        Object object2 = new byte[this.stride];
        byte[] byArray = new byte[this.rawData.length + this.header.getHeight()];
        byte by = 0;
        for (int i = 0; i < this.header.getHeight(); ++i) {
            object = new byte[this.stride];
            System.arraycopy(this.rawData, i * this.stride, object, 0, this.stride);
            if (bl && i > 0) {
                by = PNGFilter.chooseFilter((byte[])object, object2, this.bpp);
            }
            byte[] byArray2 = PNGFilter.filterScanline(by, (byte[])object, object2, this.bpp);
            byArray[i * (this.stride + 1)] = by;
            System.arraycopy(byArray2, 0, byArray, 1 + i * (this.stride + 1), this.stride);
            object2 = object;
        }
        deflater.setInput(byArray);
        deflater.finish();
        object = new Vector();
        do {
            pNGData = new PNGData(8192);
            pNGData.deflateToChunk(deflater);
            ((Vector)object).add(pNGData);
        } while (pNGData.chunkFull());
        pNGData.shrink();
        return object;
    }

    private void getRawData(BufferedImage bufferedImage) throws PNGException {
        int n;
        WritableRaster writableRaster = bufferedImage.getRaster();
        this.rawData = new byte[this.stride * this.header.getHeight()];
        if (this.header.isIndexed()) {
            DataBuffer dataBuffer = writableRaster.getDataBuffer();
            if (!(dataBuffer instanceof DataBufferByte)) {
                throw new PNGException("Unexpected DataBuffer for an IndexColorModel.");
            }
            byte[] byArray = ((DataBufferByte)dataBuffer).getData();
            for (int i = 0; i < this.header.getHeight(); ++i) {
                System.arraycopy(byArray, i * this.stride, this.rawData, i * this.stride, this.stride);
            }
            return;
        }
        if (this.header.getDepth() == 16) {
            DataBuffer dataBuffer = writableRaster.getDataBuffer();
            if (!(dataBuffer instanceof DataBufferUShort)) {
                throw new PNGException("Unexpected DataBuffer for 16-bit.");
            }
            short[] sArray = ((DataBufferUShort)dataBuffer).getData();
            for (int i = 0; i < this.header.getHeight(); ++i) {
                for (int j = 0; j < this.stride >> 1; ++j) {
                    this.rawData[j * 2 + i * this.stride] = (byte)((sArray[j + i * (this.stride >> 1)] & 0xFF00) >> 8);
                    this.rawData[j * 2 + i * this.stride + 1] = (byte)(sArray[j + i * (this.stride >> 1)] & 0xFF);
                }
            }
            return;
        }
        int n2 = this.header.getColorType() == 6 ? 4 : 3;
        int n3 = this.header.getWidth();
        int n4 = this.header.getHeight();
        int[] nArray = bufferedImage.getRGB(0, 0, n3, n4, null, 0, n3);
        for (n = 0; n < n3 * n4; ++n) {
            this.rawData[n * n2] = (byte)((nArray[n] & 0xFF0000) >> 16);
            this.rawData[n * n2 + 1] = (byte)((nArray[n] & 0xFF00) >> 8);
            this.rawData[n * n2 + 2] = (byte)(nArray[n] & 0xFF);
        }
        if (n2 == 4) {
            for (n = 0; n < n3 * n4; ++n) {
                this.rawData[n * n2 + 3] = (byte)((nArray[n] & 0xFF000000) >> 24);
            }
        }
    }
}

