/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.jpeg;

import gnu.javax.imageio.jpeg.DCT;
import gnu.javax.imageio.jpeg.HuffmanTable;
import gnu.javax.imageio.jpeg.JPEGComponent;
import gnu.javax.imageio.jpeg.JPEGException;
import gnu.javax.imageio.jpeg.JPEGFrame;
import gnu.javax.imageio.jpeg.JPEGImageInputStream;
import gnu.javax.imageio.jpeg.JPEGMarkerFoundException;
import gnu.javax.imageio.jpeg.YCbCr_ColorSpace;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGQTable;
import javax.imageio.stream.ImageInputStream;

public class JPEGDecoder {
    byte majorVersion;
    byte minorVersion;
    byte units;
    short Xdensity;
    short Ydensity;
    byte Xthumbnail;
    byte Ythumbnail;
    byte[] thumbnail;
    BufferedImage image;
    int width;
    int height;
    byte marker;
    public static final byte MAJOR_VERSION = 1;
    public static final byte MINOR_VERSION = 2;
    public static final short JFIF_FIXED_LENGTH = 16;
    public static final short JFXX_FIXED_LENGTH = 8;
    private JPEGImageInputStream jpegStream;
    ArrayList jpegFrames = new ArrayList();
    JPEGHuffmanTable[] dcTables = new JPEGHuffmanTable[4];
    JPEGHuffmanTable[] acTables = new JPEGHuffmanTable[4];
    JPEGQTable[] qTables = new JPEGQTable[4];

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public JPEGDecoder(ImageInputStream imageInputStream) throws IOException, JPEGException {
        this.jpegStream = new JPEGImageInputStream(imageInputStream);
        this.jpegStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        if (this.jpegStream.findNextMarker() != -40) {
            throw new JPEGException("Failed to find SOI marker.");
        }
        if (this.jpegStream.findNextMarker() != -32) {
            throw new JPEGException("Failed to find APP0 marker.");
        }
        short s = this.jpegStream.readShort();
        if (s < 16) {
            throw new JPEGException("Failed to find JFIF field.");
        }
        byte[] byArray = new byte[5];
        this.jpegStream.read(byArray);
        if (byArray[0] != 74 || byArray[1] != 70 || byArray[2] != 73 || byArray[3] != 70 || byArray[4] != 0) {
            throw new JPEGException("Failed to read JFIF identifier.");
        }
        this.majorVersion = this.jpegStream.readByte();
        this.minorVersion = this.jpegStream.readByte();
        if (this.majorVersion != 1 || this.majorVersion == 1 && this.minorVersion < 2) {
            throw new JPEGException("Unsupported JFIF version.");
        }
        this.units = this.jpegStream.readByte();
        if (this.units > 2) {
            throw new JPEGException("Units field is out of range.");
        }
        this.Xdensity = this.jpegStream.readShort();
        this.Ydensity = this.jpegStream.readShort();
        this.Xthumbnail = this.jpegStream.readByte();
        this.Ythumbnail = this.jpegStream.readByte();
        int n = 3 * this.Xthumbnail * this.Ythumbnail;
        if (s > 16 && n != s - 16) {
            throw new JPEGException("Invalid length, Xthumbnail or Ythumbnail field.");
        }
        if (n > 0) {
            this.thumbnail = new byte[n];
            if (this.jpegStream.read(this.thumbnail) != n) {
                throw new IOException("Failed to read thumbnail.");
            }
        }
    }

    public void decode() throws IOException {
        System.out.println("DECODE!!!");
        JPEGFrame jPEGFrame = null;
        short s = 0;
        byte by = this.jpegStream.findNextMarker();
        this.decodeJFIFExtension();
        while (true) {
            block1 : switch (by) {
                case -32: 
                case -31: 
                case -30: 
                case -29: 
                case -28: 
                case -27: 
                case -26: 
                case -25: 
                case -24: 
                case -23: 
                case -22: 
                case -21: 
                case -20: 
                case -19: 
                case -18: 
                case -17: {
                    this.jpegStream.skipBytes(this.jpegStream.readShort() - 2);
                    break;
                }
                case -64: {
                    int n4;
                    this.jpegFrames.add(new JPEGFrame());
                    jPEGFrame = (JPEGFrame)this.jpegFrames.get(this.jpegFrames.size() - 1);
                    this.jpegStream.readShort();
                    jPEGFrame.setPrecision(this.jpegStream.readByte());
                    jPEGFrame.setScanLines(this.jpegStream.readShort());
                    jPEGFrame.setSamplesPerLine(this.jpegStream.readShort());
                    jPEGFrame.setComponentCount(this.jpegStream.readByte());
                    if (jPEGFrame.getComponentCount() == 1) {
                        jPEGFrame.setColorMode((byte)1);
                    } else {
                        jPEGFrame.setColorMode((byte)3);
                    }
                    for (n4 = 0; n4 < jPEGFrame.getComponentCount(); ++n4) {
                        jPEGFrame.addComponent(this.jpegStream.readByte(), this.jpegStream.readByte(), this.jpegStream.readByte());
                    }
                    break;
                }
                case -62: {
                    int n4;
                    this.jpegFrames.add(new JPEGFrame());
                    jPEGFrame = (JPEGFrame)this.jpegFrames.get(this.jpegFrames.size() - 1);
                    this.jpegStream.readShort();
                    jPEGFrame.setPrecision(this.jpegStream.readByte());
                    jPEGFrame.setScanLines(this.jpegStream.readShort());
                    jPEGFrame.setSamplesPerLine(this.jpegStream.readShort());
                    jPEGFrame.setComponentCount(this.jpegStream.readByte());
                    if (jPEGFrame.getComponentCount() == 1) {
                        jPEGFrame.setColorMode((byte)1);
                    } else {
                        jPEGFrame.setColorMode((byte)3);
                    }
                    for (n4 = 0; n4 < jPEGFrame.getComponentCount(); ++n4) {
                        jPEGFrame.addComponent(this.jpegStream.readByte(), this.jpegStream.readByte(), this.jpegStream.readByte());
                    }
                    break;
                }
                case -60: {
                    int n6;
                    int n2;
                    Object[] objectArray;
                    byte by2;
                    int n3;
                    short s2;
                    int n4;
                    int n5 = n4 = this.jpegStream.readShort() - 2;
                    while (n5 > 0) {
                        s2 = this.jpegStream.readByte();
                        n3 = (byte)(s2 >> 4);
                        by2 = (byte)(s2 & 0xF);
                        objectArray = new short[16];
                        this.jpegStream.readFully((short[])objectArray, 0, objectArray.length);
                        n2 = 0;
                        for (int i = 0; i < 16; ++i) {
                            n2 += objectArray[i];
                        }
                        n5 -= n2 + 17;
                        short[] sArray = new short[n2];
                        for (n6 = 0; n6 < sArray.length; ++n6) {
                            sArray[n6] = this.jpegStream.readByte();
                        }
                        if (n3 == HuffmanTable.JPEG_DC_TABLE) {
                            this.dcTables[by2] = new JPEGHuffmanTable((short[])objectArray, sArray);
                            continue;
                        }
                        if (n3 != HuffmanTable.JPEG_AC_TABLE) continue;
                        this.acTables[by2] = new JPEGHuffmanTable((short[])objectArray, sArray);
                    }
                    break;
                }
                case -37: {
                    int n2;
                    Object[] objectArray;
                    byte by2;
                    int n3;
                    short s2 = (short)(this.jpegStream.readShort() - 2);
                    for (n3 = 0; n3 < s2 / 65; ++n3) {
                        by2 = this.jpegStream.readByte();
                        objectArray = new int[64];
                        if ((byte)(by2 >> 4) == 0) {
                            for (n2 = 0; n2 < 64; ++n2) {
                                objectArray[n2] = this.jpegStream.readByte();
                            }
                        } else if ((byte)(by2 >> 4) == 1) {
                            for (n2 = 0; n2 < 64; ++n2) {
                                objectArray[n2] = this.jpegStream.readShort();
                            }
                        }
                        this.qTables[by2 & 0xF] = new JPEGQTable((int[])objectArray);
                    }
                    break;
                }
                case -38: {
                    Object object;
                    int n;
                    int n2;
                    this.jpegStream.readShort();
                    int n3 = this.jpegStream.readByte();
                    byte[] byArray = new byte[n3];
                    for (n = 0; n < n3; ++n) {
                        n2 = this.jpegStream.readByte();
                        byte by3 = this.jpegStream.readByte();
                        jPEGFrame.setHuffmanTables((byte)n2, this.acTables[(byte)(by3 >> 4)], this.dcTables[(byte)(by3 & 0xF)]);
                        byArray[n] = n2;
                    }
                    n = this.jpegStream.readByte();
                    n2 = this.jpegStream.readByte();
                    byte by4 = this.jpegStream.readByte();
                    int n6 = 0;
                    int n7 = 0;
                    while (true) {
                        try {
                            while (true) {
                                for (int i = 0; i < n3; ++i) {
                                    JPEGComponent jPEGComponent = jPEGFrame.components.getComponentByID(byArray[i]);
                                    jPEGComponent.readComponentMCU(this.jpegStream);
                                }
                                ++n6;
                                ++n7;
                            }
                        }
                        catch (JPEGMarkerFoundException jPEGMarkerFoundException) {
                            if (by != -48 && by != -47 && by != -46 && by != -45 && by != -44 && by != -43 && by != -42 && by != -41) break block1;
                            for (int i = 0; i < n3; ++i) {
                                object = jPEGFrame.components.getComponentByID(byArray[i]);
                                if (i > 1) {
                                    ((JPEGComponent)object).padMCU(n7, s - n6);
                                }
                                ((JPEGComponent)object).resetInterval();
                            }
                            n7 += s - n6;
                            n6 = 0;
                            continue;
                        }
                        break;
                    }
                }
                case -35: {
                    this.jpegStream.skipBytes(2);
                    s = this.jpegStream.readShort();
                    break;
                }
                case -2: {
                    this.jpegStream.skipBytes(this.jpegStream.readShort() - 2);
                    break;
                }
                case -36: {
                    jPEGFrame.setScanLines(this.jpegStream.readShort());
                    break;
                }
                case -39: {
                    Object object;
                    if (this.jpegFrames.size() == 0) {
                        return;
                    }
                    if (this.jpegFrames.size() == 1) {
                        Object object2;
                        int n;
                        DCT dCT = new DCT();
                        WritableRaster writableRaster = Raster.createInterleavedRaster(0, jPEGFrame.width, jPEGFrame.height, jPEGFrame.getComponentCount(), new Point(0, 0));
                        for (n = 0; n < jPEGFrame.getComponentCount(); ++n) {
                            object2 = jPEGFrame.components.get(n);
                            ((JPEGComponent)object2).setQuantizationTable(this.qTables[((JPEGComponent)object2).quant_id].getTable());
                            ((JPEGComponent)object2).quantitizeData();
                            ((JPEGComponent)object2).idctData(dCT);
                        }
                        for (n = 0; n < jPEGFrame.getComponentCount(); ++n) {
                            object2 = jPEGFrame.components.get(n);
                            ((JPEGComponent)object2).scaleByFactors();
                            ((JPEGComponent)object2).writeData(writableRaster, n);
                            object2 = null;
                        }
                        if (jPEGFrame.getComponentCount() == 1) {
                            object = ColorSpace.getInstance(1003);
                            object2 = new ComponentColorModel((ColorSpace)object, false, false, 1, 0);
                            this.image = new BufferedImage((ColorModel)object2, writableRaster, false, new Hashtable());
                        } else if (jPEGFrame.getComponentCount() == 3) {
                            object = new ComponentColorModel(new YCbCr_ColorSpace(), false, false, 1, 0);
                            this.image = new BufferedImage((ColorModel)object, writableRaster, false, new Hashtable());
                        } else {
                            throw new JPEGException("Unsupported Color Mode: 4 Component Color Mode found.");
                        }
                        this.height = jPEGFrame.height;
                        this.width = jPEGFrame.width;
                        break;
                    }
                    throw new JPEGException("Unsupported Codec Type: Hierarchial JPEG");
                }
                case -63: {
                    throw new JPEGException("Unsupported Codec Type: Extended Sequential DCT JPEG's Not-Supported");
                }
                case -61: {
                    throw new JPEGException("Unsupported Codec Type: Lossless (sequential)");
                }
                case -59: {
                    throw new JPEGException("Unsupported Codec Type: Differential sequential DCT");
                }
                case -58: {
                    throw new JPEGException("Unsupported Codec Type: Differential progressive DCT");
                }
                case -57: {
                    throw new JPEGException("Unsupported Codec Type: Differential lossless");
                }
                case -55: 
                case -54: 
                case -53: 
                case -51: 
                case -50: 
                case -49: {
                    throw new JPEGException("Unsupported Codec Type: Arithmetic Coding Frame");
                }
            }
            by = this.jpegStream.findNextMarker();
        }
    }

    private void decodeJFIFExtension() throws IOException {
        if (this.marker == -32) {
            short s = this.jpegStream.readShort();
            if (s >= 8) {
                byte[] byArray = new byte[5];
                this.jpegStream.read(byArray);
                if (byArray[0] != 74 || byArray[1] != 70 || byArray[2] != 70 || byArray[3] != 70 || byArray[4] != 0) {
                    this.jpegStream.skipBytes(s - 7);
                } else {
                    byte by = this.jpegStream.readByte();
                    switch (by) {
                        case 16: {
                            this.jpegStream.skipBytes(s - 8);
                        }
                        case 17: {
                            this.jpegStream.skipBytes(s - 8);
                        }
                        case 19: {
                            this.jpegStream.skipBytes(s - 8);
                        }
                    }
                }
            } else {
                this.jpegStream.skipBytes(s - 2);
            }
            this.marker = this.jpegStream.findNextMarker();
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }
}

