/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.gif;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class GIFFile {
    private static final byte[] nsBlock = new byte[]{78, 69, 84, 83, 67, 65, 80, 69, 50, 46, 48};
    private static final int EXTENSION = 33;
    private static final int LOCAL = 44;
    private static final int TERMINATOR = 59;
    private static final int EXTENSION_COMMENT = 254;
    private static final int EXTENSION_GCONTROL = 249;
    private static final int EXTENSION_APPLICATION = 255;
    private static final int UNDRAW_OVERWRITE = 1;
    private static final int UNDRAW_RESTORE_BACKGROUND = 2;
    private static final int UNDRAW_RESTORE_PREVIOUS = 3;
    private int x;
    private int y;
    private int width;
    private int height;
    private int globalWidth;
    private int globalHeight;
    private byte bgIndex;
    private int nColors;
    private byte[] globalPalette;
    private boolean hasGlobalColorMap;
    private byte[] localPalette;
    private boolean interlaced;
    private boolean hasTransparency;
    private int undraw;
    private int transparentIndex;
    private byte[] raster;
    private byte[] compressedData;
    private int duration;
    private int dataBlockIndex;
    private String comment;
    private int remainingBits = 0;
    private int currentBits = 0;
    private boolean isLooped = false;
    private int loops;
    private Vector animationFrames;

    public GIFFile(InputStream inputStream) throws IOException, GIFException {
        if (!GIFFile.readSignature(inputStream)) {
            throw new GIFException("Invalid GIF signature.");
        }
        byte[] byArray = new byte[7];
        if (inputStream.read(byArray) != 7) {
            throw new IOException("Couldn't read global descriptor.");
        }
        this.globalWidth = (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        this.globalHeight = (byArray[3] & 0xFF) << 8 | byArray[2] & 0xFF;
        byte by = byArray[4];
        this.bgIndex = byArray[5];
        this.nColors = 1 << (by & 7) + 1;
        boolean bl = this.hasGlobalColorMap = (by & 0x80) != 0;
        if (this.hasGlobalColorMap) {
            this.globalPalette = new byte[this.nColors * 3];
            if (inputStream.read(this.globalPalette) != this.nColors * 3) {
                throw new IOException("Couldn't read color map.");
            }
        }
        int n = inputStream.read();
        while (n == 33) {
            this.readExtension(inputStream);
            n = inputStream.read();
        }
        if (n != 44) {
            throw new GIFException("Extension blocks not followed by a local descriptor (" + n + ")");
        }
        this.loadImage(inputStream);
        n = inputStream.read();
        if (n == 59) {
            return;
        }
        this.animationFrames = new Vector();
        try {
            while (n != 59) {
                this.animationFrames.add(new GIFFile(this, inputStream, n));
                n = inputStream.read();
            }
        }
        catch (IOException iOException) {
        }
        catch (GIFException gIFException) {
            // empty catch block
        }
    }

    private GIFFile(GIFFile gIFFile, InputStream inputStream, int n) throws IOException, GIFException {
        this.globalWidth = gIFFile.globalWidth;
        this.globalHeight = gIFFile.globalHeight;
        this.nColors = gIFFile.nColors;
        this.globalPalette = gIFFile.globalPalette;
        this.hasGlobalColorMap = gIFFile.hasGlobalColorMap;
        this.interlaced = gIFFile.interlaced;
        this.comment = gIFFile.comment;
        this.isLooped = gIFFile.isLooped;
        this.loops = gIFFile.loops;
        while (n == 33) {
            this.readExtension(inputStream);
            n = inputStream.read();
        }
        if (n != 44) {
            throw new GIFException("Extension blocks not followed by a local descriptor (" + n + ")");
        }
        this.loadImage(inputStream);
    }

    public static boolean readSignature(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[6];
        if (inputStream.read(byArray) != 6) {
            throw new IOException("Couldn't read signature.");
        }
        if (byArray[0] != 71 || byArray[1] != 73 || byArray[2] != 70 || byArray[3] != 56) {
            return false;
        }
        return (byArray[4] == 57 || byArray[4] == 55) && (byArray[5] == 97 || byArray[5] == 98);
    }

    private void loadImage(InputStream inputStream) throws IOException, GIFException {
        this.readLocal(inputStream);
        try {
            this.decodeRaster(inputStream);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new GIFException("Error decompressing image.");
        }
        if (this.interlaced) {
            this.deinterlace();
        }
        this.packPixels();
    }

    private void packPixels() {
        if (this.nColors != 2 && this.nColors != 4 && this.nColors != 16) {
            return;
        }
        int n = 1;
        int n2 = 8;
        if (this.nColors == 4) {
            n = 2;
            n2 = 4;
        } else if (this.nColors == 16) {
            n = 4;
            n2 = 2;
        }
        int n3 = this.width & n2 - 1;
        int n4 = n3 == 0 ? this.width / n2 : (this.width + n2 - n3) / n2;
        byte[] byArray = new byte[n4 * this.height];
        for (int i = 0; i < this.height; ++i) {
            int n5;
            for (n5 = 0; n5 < this.width - n2; n5 += n2) {
                for (int j = 0; j < n2; ++j) {
                    int n6 = i * n4 + n5 / n2;
                    byArray[n6] = (byte)(byArray[n6] | (byte)(this.raster[this.width * i + n5 + j] << 8 - n * (1 + j)));
                }
            }
            for (n5 = 0; n5 < n3; ++n5) {
                int n7 = i * n4 + n4 - 1;
                byArray[n7] = (byte)(byArray[n7] | (byte)(this.raster[this.width * i + this.width - n3 + n5] << n * (n3 - n5)));
            }
        }
        this.raster = byArray;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getNColors() {
        return this.nColors;
    }

    public boolean hasTransparency() {
        return this.hasTransparency;
    }

    public int getTransparentIndex() {
        return this.transparentIndex;
    }

    public String getComment() {
        return this.comment;
    }

    public int getDuration() {
        return this.duration;
    }

    private void deinterlace() {
        int n;
        byte[] byArray = new byte[this.width * this.height];
        int n2 = 0;
        for (n = 0; n < this.height + 7 >> 3; ++n) {
            System.arraycopy(this.raster, n2, byArray, this.width * n * 8, this.width);
            n2 += this.width;
        }
        for (n = 0; n < this.height + 3 >> 3; ++n) {
            System.arraycopy(this.raster, n2, byArray, this.width * (8 * n + 4), this.width);
            n2 += this.width;
        }
        for (n = 0; n < this.height >> 2; ++n) {
            System.arraycopy(this.raster, n2, byArray, this.width * (4 * n + 2), this.width);
            n2 += this.width;
        }
        for (n = 0; n < this.height >> 1; ++n) {
            System.arraycopy(this.raster, n2, byArray, this.width * (2 * n + 1), this.width);
            n2 += this.width;
        }
        this.raster = byArray;
    }

    private void readLocal(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[9];
        if (inputStream.read(byArray) != 9) {
            throw new IOException("Couldn't read local descriptor.");
        }
        this.x = (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        this.y = (byArray[3] & 0xFF) << 8 | byArray[2] & 0xFF;
        this.width = (byArray[5] & 0xFF) << 8 | byArray[4] & 0xFF;
        this.height = (byArray[7] & 0xFF) << 8 | byArray[6] & 0xFF;
        byte by = byArray[8];
        boolean bl = this.interlaced = (by & 0x40) != 0;
        if ((by & 0x80) != 0) {
            int n = 1 << (by & 7) + 1;
            if (!this.hasGlobalColorMap) {
                this.nColors = n;
            }
            this.localPalette = new byte[n * 3];
            if (inputStream.read(this.localPalette) != n * 3) {
                throw new IOException("Couldn't read color map.");
            }
        }
    }

    public byte[] getRawPalette() {
        return this.hasGlobalColorMap ? this.globalPalette : this.localPalette;
    }

    public GIFFile getImage(int n) {
        if (n == 0) {
            return this;
        }
        if (this.animationFrames == null) {
            throw new ArrayIndexOutOfBoundsException("Only one image in file");
        }
        return (GIFFile)this.animationFrames.elementAt(n - 1);
    }

    public byte[] getRawImage() {
        return this.raster;
    }

    public int nImages() {
        if (this.animationFrames != null) {
            return 1 + this.animationFrames.size();
        }
        return 1;
    }

    private void readExtension(InputStream inputStream) throws IOException, GIFException {
        int n = inputStream.read();
        byte[] byArray = this.readData(inputStream);
        switch (n) {
            case 254: {
                this.comment = new String(byArray, "8859_1");
                break;
            }
            case 249: {
                this.undraw = (byArray[0] & 0x1C) >> 2;
                if (this.undraw < 1 && this.undraw > 3) {
                    this.undraw = 1;
                }
                this.hasTransparency = (byArray[0] & 1) == 1;
                this.transparentIndex = byArray[3] & 0xFF;
                this.duration = (byArray[2] & 0xFF) << 8 | byArray[1] & 0xFF;
                break;
            }
            case 255: {
                boolean bl = true;
                for (int i = 0; i < nsBlock.length; ++i) {
                    if (nsBlock[i] == byArray[i]) continue;
                    bl = false;
                }
                if (!bl) break;
                this.isLooped = true;
                this.loops = (byArray[12] & 0xFF) << 8 | byArray[13] & 0xFF;
                break;
            }
        }
    }

    private byte[] readData(InputStream inputStream) throws IOException {
        byte[] byArray;
        Vector<byte[]> vector = new Vector<byte[]>();
        int n = 0;
        int n2 = inputStream.read();
        do {
            n += n2;
            byArray = new byte[n2];
            inputStream.read(byArray);
            vector.add(byArray);
        } while ((n2 = inputStream.read()) > 0);
        n2 = 0;
        byArray = new byte[n];
        for (int i = 0; i < vector.size(); ++i) {
            byte[] byArray2 = (byte[])vector.elementAt(i);
            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            n2 += byArray2.length;
        }
        return byArray;
    }

    private void decodeRaster(InputStream inputStream) throws IOException {
        int n;
        int n2 = inputStream.read();
        this.compressedData = this.readData(inputStream);
        this.dataBlockIndex = 0;
        int n3 = 0;
        int n4 = 1 << n2;
        int n5 = n4 + 1;
        this.raster = new byte[this.width * this.height];
        int n6 = n2 + 1;
        int n7 = this.getBits(n6);
        int n8 = n5 + 1;
        short[][] sArray = new short[4096][4];
        for (n = 0; n < this.nColors; n = (int)((short)(n + 1))) {
            sArray[n][0] = n;
            sArray[n][1] = -1;
            sArray[n][2] = n;
            sArray[n][3] = 1;
        }
        n7 = this.getBits(n6);
        this.raster[n3++] = (byte)sArray[n7][0];
        n = n7;
        n7 = this.getBits(n6);
        do {
            if (n7 == n4) {
                n6 = n2 + 1;
                n8 = n5 + 1;
                n7 = this.getBits(n6);
                this.raster[n3++] = (byte)sArray[n7][0];
                n = n7;
                continue;
            }
            sArray[n8][1] = (short)n;
            sArray[n8][2] = sArray[n][2];
            sArray[n8][3] = (short)(sArray[n][3] + 1);
            if (n7 < n8) {
                sArray[n8][0] = sArray[n7][2];
                n = n7;
            } else {
                sArray[n8][0] = sArray[n][2];
                n = n8;
            }
            int n9 = n;
            short s = sArray[n9][3];
            for (int i = s - 1; i >= 0; --i) {
                this.raster[n3 + i] = (byte)sArray[n9][0];
                n9 = sArray[n9][1];
            }
            n3 += s;
            if (n6 >= 12 || ++n8 < 1 << n6) continue;
            ++n6;
        } while ((n7 = this.getBits(n6)) != n5 && this.dataBlockIndex < this.compressedData.length);
        this.compressedData = null;
    }

    private int getBits(int n) {
        int n2;
        while (n > this.remainingBits) {
            n2 = (this.compressedData[this.dataBlockIndex++] & 0xFF) << this.remainingBits;
            this.currentBits |= n2;
            this.remainingBits += 8;
        }
        n2 = this.currentBits & (1 << n) - 1;
        this.currentBits >>= n;
        this.remainingBits -= n;
        return n2;
    }

    public static class GIFException
    extends Exception {
        public GIFException(String string) {
            super(string);
        }
    }
}

