/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPEncoder;
import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;

public class EncodeRLE8
extends BMPEncoder {
    protected BMPInfoHeader infoHeader;
    protected BMPFileHeader fileHeader;
    protected long offset;
    private static final byte ESCAPE = 0;
    private static final byte EOL = 0;
    private static final byte EOB = 1;
    private static final byte DELTA = 2;

    public EncodeRLE8(BMPFileHeader bMPFileHeader, BMPInfoHeader bMPInfoHeader) {
        this.fileHeader = bMPFileHeader;
        this.infoHeader = bMPInfoHeader;
        this.offset = 54L;
    }

    public void encode(ImageOutputStream imageOutputStream, IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        int n;
        int n2 = this.infoHeader.biWidth * this.infoHeader.biHeight - 1;
        int n3 = 1;
        int n4 = n = n2 - this.infoHeader.biWidth;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        try {
            int[] nArray = new int[this.infoHeader.biWidth * this.infoHeader.biHeight];
            PixelGrabber pixelGrabber = new PixelGrabber((BufferedImage)iIOImage.getRenderedImage(), 0, 0, this.infoHeader.biWidth, this.infoHeader.biHeight, nArray, 0, this.infoHeader.biWidth);
            pixelGrabber.grabPixels();
            for (int i = 0; i < n2; ++i) {
                int n5 = nArray[n];
                byteBuffer.put((byte)(n5 & 0xFF));
                if (n3 == this.infoHeader.biWidth) {
                    n3 = 1;
                    n4 = n = n4 - this.infoHeader.biWidth;
                } else {
                    ++n3;
                }
                ++n;
            }
            byteBuffer.flip();
            imageOutputStream.write(this.uncompress(this.infoHeader.biWidth, this.infoHeader.biHeight, byteBuffer));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] uncompress(int var1_1, int var2_2, ByteBuffer var3_3) throws IOException {
        var4_4 = new byte[2];
        var5_5 = new byte[var1_1 * var2_2];
        var6_6 = false;
        var7_7 = 0;
        var8_8 = 0;
        try {
            block13: while (true) {
                if (var7_7 + var8_8 * var1_1 >= var1_1 * var2_2) {
                    return var5_5;
                }
                try {
                    var3_3.get(var4_4);
                }
                catch (BufferUnderflowException var9_10) {
                    throw new IOException("Error reading compressed data.");
                }
                if (var4_4[0] == 0) {
                    switch (var4_4[1]) {
                        case 1: {
                            return var5_5;
                        }
                        case 0: {
                            var7_7 = 0;
                            ++var8_8;
                            continue block13;
                        }
                        case 2: {
                            try {
                                var3_3.get(var4_4);
                            }
                            catch (BufferUnderflowException var9_11) {
                                throw new IOException("Error reading compressed data.");
                            }
                            var9_9 = var4_4[0] & 255;
                            var10_13 = var4_4[1] & 255;
                            var7_7 += var9_9;
                            var8_8 += var10_13;
                            continue block13;
                        }
                    }
                    var12_15 = var11_14 = var4_4[1] & 255;
                    var11_14 += var11_14 & 1;
                    var13_16 = new byte[var11_14];
                    try {
                        var3_3.get(var13_16);
                    }
                    catch (BufferUnderflowException var14_17) {
                        throw new IOException("Error reading compressed data.");
                    }
                    System.arraycopy(var13_16, 0, var5_5, var7_7 + var1_1 * (var2_2 - var8_8 - 1), var12_15);
                    var7_7 += var12_15;
                    continue;
                }
                var9_9 = var4_4[0] & 255;
                var10_13 = 0;
                while (true) {
                    if (var10_13 < var9_9) ** break;
                    continue block13;
                    var5_5[(var2_2 - var8_8 - 1) * var1_1 + var7_7++] = var4_4[1];
                    ++var10_13;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException var9_12) {
            throw new BMPException("Invalid RLE data.");
        }
    }
}

