/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPDecoder;
import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class DecodeRLE4
extends BMPDecoder {
    private static final byte ESCAPE = 0;
    private static final byte EOL = 0;
    private static final byte EOB = 1;
    private static final byte DELTA = 2;

    public DecodeRLE4(BMPFileHeader bMPFileHeader, BMPInfoHeader bMPInfoHeader) {
        super(bMPFileHeader, bMPInfoHeader);
    }

    public BufferedImage decode(ImageInputStream imageInputStream) throws IOException, BMPException {
        IndexColorModel indexColorModel = this.readPalette(imageInputStream);
        this.skipToImage(imageInputStream);
        Dimension dimension = this.infoHeader.getSize();
        int n = (int)dimension.getHeight();
        int n2 = (int)dimension.getWidth();
        byte[] byArray = this.uncompress(n2, n, imageInputStream);
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(0, n2, n, 4);
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n2 * n, 0);
        WritableRaster writableRaster = Raster.createWritableRaster(multiPixelPackedSampleModel, dataBufferByte, null);
        return new BufferedImage(indexColorModel, writableRaster, false, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] uncompress(int n, int n2, ImageInputStream imageInputStream) throws BMPException, IOException {
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[n * n2 >> 1];
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        n += n & 1;
        n >>= 1;
        try {
            block7: while (true) {
                block21: {
                    int n5;
                    int n6;
                    block20: {
                        block19: {
                            byte[] byArray3;
                            int n7;
                            block18: {
                                block17: {
                                    if ((n3 >> 1) + n4 * n >= n * n2) {
                                        return byArray2;
                                    }
                                    if (imageInputStream.read(byArray) != 2) {
                                        throw new IOException("Error reading compressed data.");
                                    }
                                    if (byArray[0] != 0) break block17;
                                    switch (byArray[1]) {
                                        case 1: {
                                            return byArray2;
                                        }
                                        case 0: {
                                            n3 = 0;
                                            ++n4;
                                            continue block7;
                                        }
                                        case 2: {
                                            if (imageInputStream.read(byArray) != 2) {
                                                throw new IOException("Error reading compressed data.");
                                            }
                                            n6 = byArray[0] & 0xFF;
                                            n5 = byArray[1] & 0xFF;
                                            n3 += n6;
                                            n4 += n5;
                                            continue block7;
                                        }
                                    }
                                    int n8 = n7 = byArray[1] & 0xFF;
                                    n8 += n8 & 1;
                                    n8 >>= 1;
                                    n8 += n8 & 1;
                                    byArray3 = new byte[n8];
                                    if (imageInputStream.read(byArray3) != n8) {
                                        throw new IOException("Error reading compressed data.");
                                    }
                                    if ((n3 & 1) != 0) break block18;
                                    n7 += n7 & 1;
                                    System.arraycopy(byArray3, 0, byArray2, (n3 >> 1) + n * (n2 - n4 - 1), n7 >>= 1);
                                    break block19;
                                }
                                n6 = byArray[0] & 0xFF;
                                if ((n3 & 1) != 0) break block20;
                                n6 += n6 & 1;
                                n6 >>= 1;
                                for (n5 = 0; n5 < n6; ++n5) {
                                    byArray2[(n2 - n4 - 1) * n + n5 + (n3 >> 1)] = byArray[1];
                                }
                                break block21;
                            }
                            for (int i = 0; i < n7; ++i) {
                                if ((i & 1) == 0) {
                                    int n9 = (n3 + i >> 1) + n * (n2 - n4 - 1);
                                    byArray2[n9] = (byte)(byArray2[n9] | (byArray3[i >> 1] & 0xF0) >> 4);
                                    continue;
                                }
                                int n10 = (n3 + i >> 1) + n * (n2 - n4 - 1);
                                byArray2[n10] = (byte)(byArray2[n10] | (byArray3[i >> 1] & 0xF) << 4);
                            }
                        }
                        n3 += byArray[1] & 0xFF;
                        continue;
                    }
                    for (n5 = 0; n5 < n6; ++n5) {
                        if ((n5 & 1) == 0) {
                            int n11 = (n3 + n5 >> 1) + n * (n2 - n4 - 1);
                            byArray2[n11] = (byte)(byArray2[n11] | (byArray[1] & 0xF0) >> 4);
                            continue;
                        }
                        int n12 = (n3 + n5 >> 1) + n * (n2 - n4 - 1);
                        byArray2[n12] = (byte)(byArray2[n12] | (byArray[1] & 0xF) << 4);
                    }
                }
                n3 += byArray[0] & 0xFF;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BMPException("Invalid RLE data.");
        }
    }
}

