/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPDecoder;
import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class DecodeRGB4
extends BMPDecoder {
    public DecodeRGB4(BMPFileHeader bMPFileHeader, BMPInfoHeader bMPInfoHeader) {
        super(bMPFileHeader, bMPInfoHeader);
    }

    public BufferedImage decode(ImageInputStream imageInputStream) throws IOException, BMPException {
        Object object;
        IndexColorModel indexColorModel = this.readPalette(imageInputStream);
        this.skipToImage(imageInputStream);
        Dimension dimension = this.infoHeader.getSize();
        int n = (int)dimension.getHeight();
        int n2 = (int)dimension.getWidth();
        int n3 = n2 * n >> 1;
        int n4 = n2 + (n2 & 1) >> 1;
        int n5 = (n4 & 3) != 0 ? n4 + 4 - (n4 & 3) : n4;
        byte[] byArray = new byte[n4 * n];
        for (int i = n - 1; i >= 0; --i) {
            object = new byte[n5];
            if (imageInputStream.read((byte[])object) != n5) {
                throw new IOException("Couldn't read image data.");
            }
            for (int j = 0; j < n4; ++j) {
                byArray[j + i * n4] = object[j];
            }
        }
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(0, n2, n, 4);
        object = new DataBufferByte(byArray, n2 * n, 0);
        WritableRaster writableRaster = Raster.createWritableRaster(multiPixelPackedSampleModel, (DataBuffer)object, null);
        return new BufferedImage(indexColorModel, writableRaster, false, null);
    }
}

