/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPImageWriter;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;

public class BMPImageWriterSpi
extends ImageWriterSpi {
    static final String vendorName = "GNU";
    static final String version = "0.1";
    static final String writerClassName = "gnu.javax.imageio.bmp.BMPImageWriter";
    static final String[] names = new String[]{"bmp", "BMP", "Microsoft Windows BMP"};
    static final String[] suffixes = new String[]{".bmp", ".bm"};
    static final String[] MIMETypes = new String[]{"image/bmp", "image/x-windows-bmp"};
    static final String[] readerSpiNames = new String[]{"gnu.javax.imageio.bmp.BMPImageReaderSpi"};
    static final boolean supportsStandardStreamMetadataFormat = false;
    static final String nativeStreamMetadataFormatName = null;
    static final String nativeStreamMetadataFormatClassName = null;
    static final String[] extraStreamMetadataFormatNames = null;
    static final String[] extraStreamMetadataFormatClassNames = null;
    static final boolean supportsStandardImageMetadataFormat = false;
    static final String nativeImageMetadataFormatName = null;
    static final String nativeImageMetadataFormatClassName = null;
    static final String[] extraImageMetadataFormatNames = null;
    static final String[] extraImageMetadataFormatClassNames = null;
    private BMPImageWriter writerInstance;

    public BMPImageWriterSpi() {
        super(vendorName, version, names, suffixes, MIMETypes, writerClassName, STANDARD_OUTPUT_TYPE, readerSpiNames, false, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, false, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
    }

    public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
        if (imageTypeSpecifier == null) {
            return false;
        }
        BMPInfoHeader bMPInfoHeader = this.writerInstance.infoHeader;
        if (bMPInfoHeader != null) {
            int n = bMPInfoHeader.getCompression();
            int n2 = imageTypeSpecifier.getColorModel().getPixelSize();
            if (n == 2 && (n2 != 4 || n2 != 8) || n == 0 && (n2 != 1 || n2 != 4 || n2 != 8 || n2 != 16 || n2 != 24 || n2 != 32)) {
                return false;
            }
        }
        return true;
    }

    public ImageWriter createWriterInstance(Object object) {
        this.writerInstance = object != null && object instanceof ImageWriterSpi ? new BMPImageWriter((ImageWriterSpi)object) : new BMPImageWriter(this);
        return this.writerInstance;
    }

    public BMPImageWriter getWriterInstance() {
        if (this.writerInstance != null) {
            return this.writerInstance;
        }
        return (BMPImageWriter)this.createWriterInstance(null);
    }

    public String getDescription(Locale locale) {
        return "Microsoft BMP v3";
    }
}

