/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.srp;

import gnu.javax.crypto.mac.IMac;
import gnu.javax.crypto.mac.MacFactory;
import gnu.javax.crypto.sasl.srp.KDF;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.security.sasl.SaslException;

public final class IALG
implements Cloneable {
    private IMac hmac;

    private IALG(IMac iMac) {
        this.hmac = iMac;
    }

    static synchronized IALG getInstance(String string) throws SaslException {
        IMac iMac = MacFactory.getInstance(string);
        if (iMac == null) {
            throw new SaslException("getInstance()", new NoSuchAlgorithmException(string));
        }
        return new IALG(iMac);
    }

    public Object clone() throws CloneNotSupportedException {
        return new IALG((IMac)this.hmac.clone());
    }

    public void init(KDF kDF) throws SaslException {
        try {
            byte[] byArray = kDF.derive(this.hmac.macSize());
            HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
            hashMap.put("gnu.crypto.mac.key.material", byArray);
            this.hmac.init(hashMap);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SaslException("getInstance()", invalidKeyException);
        }
    }

    public void update(byte[] byArray) {
        this.hmac.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.hmac.update(byArray, n, n2);
    }

    public byte[] doFinal() {
        return this.hmac.digest();
    }

    public int length() {
        return this.hmac.macSize();
    }
}

