/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.plain;

import gnu.javax.crypto.sasl.IAuthInfoProvider;
import gnu.javax.crypto.sasl.NoSuchUserException;
import gnu.javax.crypto.sasl.plain.PasswordFile;
import gnu.javax.crypto.sasl.plain.PlainRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.sasl.AuthenticationException;

public class PlainAuthInfoProvider
implements IAuthInfoProvider,
PlainRegistry {
    private PasswordFile passwordFile = null;

    public void activate(Map map) throws AuthenticationException {
        try {
            String string;
            this.passwordFile = map == null ? new PasswordFile() : ((string = (String)map.get("gnu.crypto.sasl.plain.password.file")) == null ? new PasswordFile() : new PasswordFile(string));
        }
        catch (IOException iOException) {
            throw new AuthenticationException("activate()", iOException);
        }
    }

    public void passivate() throws AuthenticationException {
        this.passwordFile = null;
    }

    public boolean contains(String string) throws AuthenticationException {
        if (this.passwordFile == null) {
            throw new AuthenticationException("contains()", new IllegalStateException());
        }
        boolean bl = false;
        try {
            bl = this.passwordFile.contains(string);
        }
        catch (IOException iOException) {
            throw new AuthenticationException("contains()", iOException);
        }
        return bl;
    }

    public Map lookup(Map map) throws AuthenticationException {
        if (this.passwordFile == null) {
            throw new AuthenticationException("lookup()", new IllegalStateException());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String string = (String)map.get("gnu.crypto.sasl.username");
            if (string == null) {
                throw new NoSuchUserException("");
            }
            String[] stringArray = this.passwordFile.lookup(string);
            hashMap.put("gnu.crypto.sasl.username", stringArray[0]);
            hashMap.put("gnu.crypto.sasl.password", stringArray[1]);
            hashMap.put("plain.uid", stringArray[2]);
            hashMap.put("plain.gid", stringArray[3]);
            hashMap.put("plain.gecos", stringArray[4]);
            hashMap.put("plain.dir", stringArray[5]);
            hashMap.put("plain.shell", stringArray[6]);
        }
        catch (Exception exception) {
            if (exception instanceof AuthenticationException) {
                throw (AuthenticationException)exception;
            }
            throw new AuthenticationException("lookup()", exception);
        }
        return hashMap;
    }

    public void update(Map map) throws AuthenticationException {
        if (this.passwordFile == null) {
            throw new AuthenticationException("update()", new IllegalStateException());
        }
        try {
            String string = (String)map.get("gnu.crypto.sasl.username");
            String string2 = (String)map.get("gnu.crypto.sasl.password");
            String string3 = (String)map.get("plain.uid");
            String string4 = (String)map.get("plain.gid");
            String string5 = (String)map.get("plain.gecos");
            String string6 = (String)map.get("plain.dir");
            String string7 = (String)map.get("plain.shell");
            if (string3 == null || string4 == null || string5 == null || string6 == null || string7 == null) {
                this.passwordFile.changePasswd(string, string2);
            } else {
                String[] stringArray = new String[]{string3, string4, string5, string6, string7};
                this.passwordFile.add(string, string2, stringArray);
            }
        }
        catch (Exception exception) {
            if (exception instanceof AuthenticationException) {
                throw (AuthenticationException)exception;
            }
            throw new AuthenticationException("update()", exception);
        }
    }

    public Map getConfiguration(String string) throws AuthenticationException {
        throw new AuthenticationException("", new UnsupportedOperationException());
    }
}

