/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.crammd5;

import gnu.java.security.util.Util;
import gnu.javax.crypto.sasl.ClientMechanism;
import gnu.javax.crypto.sasl.crammd5.CramMD5Util;
import java.io.IOException;
import java.security.InvalidKeyException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthenticationException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class CramMD5Client
extends ClientMechanism
implements SaslClient {
    public CramMD5Client() {
        super("CRAM-MD5");
    }

    protected void initMechanism() throws SaslException {
    }

    protected void resetMechanism() throws SaslException {
    }

    public boolean hasInitialResponse() {
        return false;
    }

    public byte[] evaluateChallenge(byte[] byArray) throws SaslException {
        if (byArray == null) {
            throw new SaslException("null challenge");
        }
        try {
            char[] cArray;
            String string;
            Object object;
            String string2;
            if (!this.properties.containsKey("gnu.crypto.sasl.username") && !this.properties.containsKey("gnu.crypto.sasl.password")) {
                Callback[] callbackArray = new Callback[2];
                string2 = System.getProperty("user.name");
                object = string2 == null ? new NameCallback("username: ") : new NameCallback("username: ", string2);
                PasswordCallback passwordCallback = new PasswordCallback("password: ", false);
                callbackArray[0] = object;
                callbackArray[1] = passwordCallback;
                this.handler.handle(callbackArray);
                string = ((NameCallback)object).getName();
                cArray = passwordCallback.getPassword();
            } else {
                Callback[] callbackArray;
                if (this.properties.containsKey("gnu.crypto.sasl.username")) {
                    string = (String)this.properties.get("gnu.crypto.sasl.username");
                } else {
                    callbackArray = new Callback[1];
                    string2 = System.getProperty("user.name");
                    object = string2 == null ? new NameCallback("username: ") : new NameCallback("username: ", string2);
                    callbackArray[0] = object;
                    this.handler.handle(callbackArray);
                    string = ((NameCallback)object).getName();
                }
                if (this.properties.containsKey("gnu.crypto.sasl.password")) {
                    cArray = ((String)this.properties.get("gnu.crypto.sasl.password")).toCharArray();
                } else {
                    callbackArray = new Callback[1];
                    object = new PasswordCallback("password: ", false);
                    callbackArray[0] = object;
                    this.handler.handle(callbackArray);
                    cArray = ((PasswordCallback)object).getPassword();
                }
            }
            if (cArray == null) {
                throw new SaslException("null password supplied");
            }
            try {
                object = CramMD5Util.createHMac(cArray, byArray);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new AuthenticationException("evaluateChallenge()", invalidKeyException);
            }
            string2 = string + " " + Util.toString((byte[])object).toLowerCase();
            this.complete = true;
            return string2.getBytes("UTF-8");
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new AuthenticationException("evaluateChallenge()", unsupportedCallbackException);
        }
        catch (IOException iOException) {
            throw new AuthenticationException("evaluateChallenge()", iOException);
        }
    }

    protected String getNegotiatedQOP() {
        return "auth";
    }
}

