/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl;

import gnu.javax.crypto.sasl.AuthInfo;
import gnu.javax.crypto.sasl.IAuthInfoProvider;
import gnu.javax.crypto.sasl.IllegalMechanismStateException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;

public abstract class ServerMechanism
implements SaslServer {
    protected String mechanism;
    protected String protocol;
    protected String serverName;
    protected Map properties;
    protected CallbackHandler handler;
    protected boolean complete = false;
    protected String authorizationID;
    protected byte[] channelBinding;
    protected int state = -1;
    protected IAuthInfoProvider authenticator;

    protected ServerMechanism(String string) {
        this.mechanism = string;
        this.authenticator = AuthInfo.getProvider(string);
        this.state = -1;
    }

    protected abstract void initMechanism() throws SaslException;

    protected abstract void resetMechanism() throws SaslException;

    public abstract byte[] evaluateResponse(byte[] var1) throws SaslException;

    public boolean isComplete() {
        return this.complete;
    }

    public byte[] unwrap(byte[] byArray, int n, int n2) throws SaslException {
        if (!this.isComplete()) {
            throw new IllegalMechanismStateException();
        }
        return this.engineUnwrap(byArray, n, n2);
    }

    public byte[] wrap(byte[] byArray, int n, int n2) throws SaslException {
        if (!this.isComplete()) {
            throw new IllegalMechanismStateException();
        }
        return this.engineWrap(byArray, n, n2);
    }

    public String getMechanismName() {
        return this.mechanism;
    }

    public String getAuthorizationID() {
        return this.authorizationID;
    }

    public Object getNegotiatedProperty(String string) {
        if (!this.isComplete()) {
            throw new IllegalStateException();
        }
        if ("javax.security.sasl.qop".equals(string)) {
            return this.getNegotiatedQOP();
        }
        if ("javax.security.sasl.strength".equals(string)) {
            return this.getNegotiatedStrength();
        }
        if ("javax.security.sasl.server.authentication".equals(string)) {
            return this.getNegotiatedServerAuth();
        }
        if ("javax.security.sasl.maxbuffer".equals(string)) {
            return this.getNegotiatedMaxBuffer();
        }
        if ("javax.security.sasl.rawsendsize".equals(string)) {
            return this.getNegotiatedRawSendSize();
        }
        if ("javax.security.sasl.policy.noplaintext".equals(string)) {
            return this.getNegotiatedPolicyNoPlainText();
        }
        if ("javax.security.sasl.policy.noactive".equals(string)) {
            return this.getNegotiatedPolicyNoActive();
        }
        if ("javax.security.sasl.policy.nodictionary".equals(string)) {
            return this.getNegotiatedPolicyNoDictionary();
        }
        if ("javax.security.sasl.policy.noanonymous".equals(string)) {
            return this.getNegotiatedPolicyNoAnonymous();
        }
        if ("javax.security.sasl.policy.forward".equals(string)) {
            return this.getNegotiatedPolicyForwardSecrecy();
        }
        if ("javax.security.sasl.policy.credentials".equals(string)) {
            return this.getNegotiatedPolicyPassCredentials();
        }
        if ("javax.security.sasl.reuse".equals(string)) {
            return this.getReuse();
        }
        return null;
    }

    public void dispose() throws SaslException {
        this.reset();
    }

    protected String getNegotiatedQOP() {
        return "auth";
    }

    protected String getNegotiatedStrength() {
        return "low";
    }

    protected String getNegotiatedServerAuth() {
        return "false";
    }

    protected String getNegotiatedMaxBuffer() {
        return null;
    }

    protected String getNegotiatedPolicyNoPlainText() {
        return null;
    }

    protected String getNegotiatedPolicyNoActive() {
        return null;
    }

    protected String getNegotiatedPolicyNoDictionary() {
        return null;
    }

    protected String getNegotiatedPolicyNoAnonymous() {
        return null;
    }

    protected String getNegotiatedPolicyForwardSecrecy() {
        return null;
    }

    protected String getNegotiatedPolicyPassCredentials() {
        return null;
    }

    protected String getNegotiatedRawSendSize() {
        return String.valueOf(0x7FFFFFFB);
    }

    protected String getReuse() {
        return "false";
    }

    protected byte[] engineUnwrap(byte[] byArray, int n, int n2) throws SaslException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    protected byte[] engineWrap(byte[] byArray, int n, int n2) throws SaslException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public void init(Map map) throws SaslException {
        if (this.state != -1) {
            throw new IllegalMechanismStateException("init()");
        }
        if (this.properties == null) {
            this.properties = new HashMap();
        } else {
            this.properties.clear();
        }
        if (map != null) {
            this.protocol = (String)map.get("gnu.crypto.sasl.protocol");
            this.serverName = (String)map.get("gnu.crypto.sasl.server.name");
            this.handler = (CallbackHandler)map.get("gnu.crypto.sasl.callback.handler");
            this.channelBinding = (byte[])map.get("gnu.crypto.sasl.channel.binding");
            this.properties.putAll(map);
        } else {
            this.handler = null;
        }
        if (this.protocol == null) {
            this.protocol = "";
        }
        if (this.serverName == null) {
            this.serverName = "";
        }
        if (this.authenticator != null) {
            this.authenticator.activate(this.properties);
        }
        if (this.channelBinding == null) {
            this.channelBinding = new byte[0];
        }
        this.initMechanism();
        this.complete = false;
        this.state = 0;
    }

    public void reset() throws SaslException {
        this.resetMechanism();
        this.properties.clear();
        if (this.authenticator != null) {
            this.authenticator.passivate();
        }
        this.serverName = null;
        this.protocol = null;
        this.channelBinding = null;
        this.complete = false;
        this.state = -1;
    }
}

