/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.prng;

import gnu.java.security.Properties;
import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.prng.BasePRNG;
import gnu.java.security.prng.EntropySource;
import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.util.SimpleList;
import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class CSPRNG
extends BasePRNG {
    private static final Logger log = null;
    public static final String FILE_SOURCES = "gnu.crypto.prng.pool.files";
    public static final String URL_SOURCES = "gnu.crypto.prng.pool.urls";
    public static final String PROGRAM_SOURCES = "gnu.crypto.prng.pool.programs";
    public static final String OTHER_SOURCES = "gnu.crypto.prng.pool.other";
    public static final String BLOCKING = "gnu.crypto.prng.pool.blocking";
    private static final String FILES = "gnu.crypto.csprng.file.";
    private static final String URLS = "gnu.crypto.csprng.url.";
    private static final String PROGS = "gnu.crypto.csprng.program.";
    private static final String OTHER = "gnu.crypto.csprng.other.";
    private static final String BLOCK = "gnu.crypto.csprng.blocking";
    private static final int POOL_SIZE = 256;
    private static final int ALLOC_SIZE = 260;
    private static final int OUTPUT_SIZE = 128;
    private static final int X917_POOL_SIZE = 16;
    private static final String HASH_FUNCTION = "sha-160";
    private static final String CIPHER = "aes";
    private static final int MIX_COUNT = 10;
    private static final int X917_LIFETIME = 8192;
    private static final int SPINNER_COUNT = 8;
    private static final Spinner[] SPINNERS = new Spinner[8];
    private static final Thread[] SPINNER_THREADS = new Thread[8];
    private final IMessageDigest hash;
    private final IBlockCipher cipher;
    private int mixCount;
    private final byte[] pool = new byte[260];
    private double quality = 0.0;
    private int index;
    private byte[] x917pool = new byte[16];
    private int x917count = 0;
    private boolean x917init = false;
    private final List files;
    private final List urls;
    private final List progs;
    private final List other;
    private boolean blocking;
    private Poller poller;
    private Thread pollerThread;

    public CSPRNG() {
        super("CSPRNG");
        this.hash = HashFactory.getInstance(HASH_FUNCTION);
        this.cipher = CipherFactory.getInstance(CIPHER);
        this.buffer = new byte[128];
        this.ndx = 0;
        this.initialised = false;
        this.files = new LinkedList();
        this.urls = new LinkedList();
        this.progs = new LinkedList();
        this.other = new LinkedList();
    }

    public static IRandom getSystemInstance() throws ClassNotFoundException, MalformedURLException, NumberFormatException {
        CSPRNG cSPRNG = new CSPRNG();
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        hashMap.put(BLOCKING, Boolean.valueOf(CSPRNG.getProperty(BLOCK)));
        String string = null;
        LinkedList linkedList = new LinkedList();
        int n = 0;
        while ((string = CSPRNG.getProperty(FILES + n)) != null) {
            try {
                linkedList.add(CSPRNG.parseString(string.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n;
        }
        hashMap.put(FILE_SOURCES, linkedList);
        linkedList = new LinkedList();
        n = 0;
        while ((string = CSPRNG.getProperty(URLS + n)) != null) {
            try {
                linkedList.add(CSPRNG.parseURL(string.trim()));
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            ++n;
        }
        hashMap.put(URL_SOURCES, linkedList);
        linkedList = new LinkedList();
        n = 0;
        while ((string = CSPRNG.getProperty(PROGS + n)) != null) {
            try {
                linkedList.add(CSPRNG.parseString(string.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n;
        }
        hashMap.put(PROGRAM_SOURCES, linkedList);
        linkedList = new LinkedList();
        n = 0;
        while ((string = CSPRNG.getProperty(OTHER + n)) != null) {
            try {
                linkedList.add((EntropySource)Class.forName(string.trim()).newInstance());
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            ++n;
        }
        hashMap.put(OTHER_SOURCES, linkedList);
        cSPRNG.init(hashMap);
        return cSPRNG;
    }

    private static String getProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Properties.getProperty(string);
            }
        });
    }

    private static List parseString(String string) throws NumberFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (stringTokenizer.countTokens() != 4) {
            throw new IllegalArgumentException("malformed property");
        }
        Double d = new Double(stringTokenizer.nextToken());
        Integer n = new Integer(stringTokenizer.nextToken());
        Integer n2 = new Integer(stringTokenizer.nextToken());
        String string2 = stringTokenizer.nextToken();
        return new SimpleList(d, n, n2, string2);
    }

    private static List parseURL(String string) throws MalformedURLException, NumberFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (stringTokenizer.countTokens() != 4) {
            throw new IllegalArgumentException("malformed property");
        }
        Double d = new Double(stringTokenizer.nextToken());
        Integer n = new Integer(stringTokenizer.nextToken());
        Integer n2 = new Integer(stringTokenizer.nextToken());
        URL uRL = new URL(stringTokenizer.nextToken());
        return new SimpleList(d, n, n2, uRL);
    }

    public Object clone() {
        return new CSPRNG();
    }

    public void setup(Map map) {
        Object object;
        Integer n;
        Integer n2;
        Double d;
        List list2 = null;
        try {
            list2 = (List)map.get(FILE_SOURCES);
            if (list2 != null) {
                this.files.clear();
                for (Object object2 : list2) {
                    if (object2.size() != 4) {
                        throw new IllegalArgumentException("invalid file list");
                    }
                    d = (Double)object2.get(0);
                    n2 = (Integer)object2.get(1);
                    n = (Integer)object2.get(2);
                    object = (String)object2.get(3);
                    this.files.add(new SimpleList(d, n2, n, object));
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("invalid file list");
        }
        try {
            list2 = (List)map.get(URL_SOURCES);
            if (list2 != null) {
                this.urls.clear();
                for (Object object2 : list2) {
                    if (object2.size() != 4) {
                        throw new IllegalArgumentException("invalid URL list");
                    }
                    d = (Double)object2.get(0);
                    n2 = (Integer)object2.get(1);
                    n = (Integer)object2.get(2);
                    object = (URL)object2.get(3);
                    this.urls.add(new SimpleList(d, n2, n, object));
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("invalid URL list");
        }
        try {
            list2 = (List)map.get(PROGRAM_SOURCES);
            if (list2 != null) {
                this.progs.clear();
                for (Object object2 : list2) {
                    if (object2.size() != 4) {
                        throw new IllegalArgumentException("invalid program list");
                    }
                    d = (Double)object2.get(0);
                    n2 = (Integer)object2.get(1);
                    n = (Integer)object2.get(2);
                    object = (String)object2.get(3);
                    this.progs.add(new SimpleList(d, n2, n, object));
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("invalid program list");
        }
        try {
            list2 = (List)map.get(OTHER_SOURCES);
            if (list2 != null) {
                this.other.clear();
                for (Object object2 : list2) {
                    if (object2 == null) {
                        throw new NullPointerException("null source in source list");
                    }
                    this.other.add(object2);
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("invalid source list");
        }
        try {
            Boolean bl = (Boolean)map.get(BLOCKING);
            this.blocking = bl != null ? bl : true;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("invalid blocking parameter");
        }
        this.poller = new Poller(this.files, this.urls, this.progs, this.other, this);
        try {
            this.fillBlock();
        }
        catch (LimitReachedException limitReachedException) {
            throw new RuntimeException("bootstrapping CSPRNG failed");
        }
    }

    public void fillBlock() throws LimitReachedException {
        int n;
        Object object;
        if (this.getQuality() < 100.0) {
            this.slowPoll();
        }
        do {
            this.fastPoll();
            this.mixRandomPool();
        } while (this.mixCount < 10);
        if (!this.x917init || this.x917count >= 8192) {
            this.mixRandomPool(this.pool);
            object = new HashMap();
            byte[] byArray = new byte[32];
            System.arraycopy(this.pool, 0, byArray, 0, 32);
            this.cipher.reset();
            object.put("gnu.crypto.cipher.key.material", byArray);
            try {
                this.cipher.init((Map)object);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new Error(invalidKeyException.toString());
            }
            this.mixRandomPool(this.pool);
            this.generateX917(this.pool);
            this.mixRandomPool(this.pool);
            this.generateX917(this.pool);
            if (this.x917init) {
                this.quality = 0.0;
            }
            this.x917init = true;
            this.x917count = 0;
        }
        object = new byte[260];
        for (n = 0; n < 260; ++n) {
            object[n] = (byte)(this.pool[n] ^ 0xFF);
        }
        this.mixRandomPool();
        this.mixRandomPool((byte[])object);
        this.generateX917((byte[])object);
        for (n = 0; n < 128; ++n) {
            this.buffer[n] = (byte)(object[n] ^ object[n + 128]);
        }
        Arrays.fill((byte[])object, (byte)0);
    }

    public synchronized void addRandomBytes(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            int n4 = this.index++;
            this.pool[n4] = (byte)(this.pool[n4] ^ byArray[i]);
            if (this.index != this.pool.length) continue;
            this.mixRandomPool();
            this.index = 0;
        }
    }

    public synchronized void addRandomByte(byte by) {
        int n = this.index++;
        this.pool[n] = (byte)(this.pool[n] ^ by);
        if (this.index >= this.pool.length) {
            this.mixRandomPool();
            this.index = 0;
        }
    }

    synchronized void addQuality(double d) {
        if (this.quality < 100.0) {
            this.quality += d;
        }
    }

    synchronized double getQuality() {
        return this.quality;
    }

    private void mixRandomPool(byte[] byArray) {
        int n = this.hash.hashSize();
        for (int i = 0; i < byArray.length; i += n) {
            if (i == 0) {
                this.hash.update(byArray, byArray.length - n, n);
            } else {
                this.hash.update(byArray, i - n, n);
            }
            if (i + 64 < byArray.length) {
                this.hash.update(byArray, i, 64);
            } else {
                this.hash.update(byArray, i, byArray.length - i);
                this.hash.update(byArray, 0, 64 - (byArray.length - i));
            }
            byte[] byArray2 = this.hash.digest();
            System.arraycopy(byArray2, 0, byArray, i, n);
        }
    }

    private void mixRandomPool() {
        this.mixRandomPool(this.pool);
        ++this.mixCount;
    }

    private void generateX917(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; i += 16) {
            int n2 = Math.min(byArray.length - i, 16);
            for (int j = 0; j < n2; ++j) {
                int n3 = j;
                this.x917pool[n3] = (byte)(this.x917pool[n3] ^ this.pool[n + j]);
            }
            this.cipher.encryptBlock(this.x917pool, 0, this.x917pool, 0);
            System.arraycopy(this.x917pool, 0, byArray, n, n2);
            this.cipher.encryptBlock(this.x917pool, 0, this.x917pool, 0);
            n += n2;
            ++this.x917count;
        }
    }

    private void fastPoll() {
        Object object;
        byte by = 0;
        for (int i = 0; i < 8; ++i) {
            by = (byte)(by ^ CSPRNG.SPINNERS[i].counter);
        }
        this.addRandomByte(by);
        this.addRandomByte((byte)System.currentTimeMillis());
        this.addRandomByte((byte)Runtime.getRuntime().freeMemory());
        String string = Thread.currentThread().getName();
        if (string != null) {
            object = string.getBytes();
            this.addRandomBytes((byte[])object, 0, ((byte[])object).length);
        }
        object = new ByteArrayOutputStream(1024);
        PrintStream printStream = new PrintStream((OutputStream)object);
        Throwable throwable = new Throwable();
        throwable.printStackTrace(printStream);
        printStream.flush();
        byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
        this.addRandomBytes(byArray, 0, byArray.length);
    }

    private void slowPoll() throws LimitReachedException {
        if (this.pollerThread == null || !this.pollerThread.isAlive()) {
            boolean bl = false;
            this.pollerThread = new Thread(this.poller);
            this.pollerThread.setDaemon(true);
            this.pollerThread.setPriority(4);
            this.pollerThread.start();
            if (this.blocking) {
                try {
                    this.pollerThread.join();
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            }
            if (!bl && this.blocking && this.quality < 100.0) {
                throw new LimitReachedException("insufficient randomness was polled");
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.poller != null && this.pollerThread != null && this.pollerThread.isAlive()) {
            this.pollerThread.interrupt();
            this.poller.stopUpdating();
            this.pollerThread.interrupt();
        }
        Arrays.fill(this.pool, (byte)0);
        Arrays.fill(this.x917pool, (byte)0);
        Arrays.fill(this.buffer, (byte)0);
    }

    static {
        for (int i = 0; i < 8; ++i) {
            CSPRNG.SPINNERS[i] = new Spinner();
            CSPRNG.SPINNER_THREADS[i] = new Thread(CSPRNG.SPINNERS[i], "spinner-" + i);
            SPINNER_THREADS[i].setDaemon(true);
            SPINNER_THREADS[i].setPriority(1);
            SPINNER_THREADS[i].start();
        }
    }

    private final class Poller
    implements Runnable {
        private final List files;
        private final List urls;
        private final List progs;
        private final List other;
        private final CSPRNG pool;
        private boolean running;

        Poller(List list2, List list3, List list4, List list5, CSPRNG cSPRNG2) {
            this.files = Collections.unmodifiableList(list2);
            this.urls = Collections.unmodifiableList(list3);
            this.progs = Collections.unmodifiableList(list4);
            this.other = Collections.unmodifiableList(list5);
            this.pool = cSPRNG2;
        }

        public void run() {
            this.running = true;
            Iterator iterator = this.files.iterator();
            Iterator iterator2 = this.urls.iterator();
            Iterator iterator3 = this.progs.iterator();
            Iterator iterator4 = this.other.iterator();
            while (iterator.hasNext() || iterator2.hasNext() || iterator3.hasNext() || iterator4.hasNext()) {
                int n;
                Object object;
                Object object2;
                Object object3;
                int n2;
                int n3;
                double d;
                Object object4;
                if (this.pool.getQuality() >= 100.0 || !this.running) {
                    return;
                }
                if (iterator.hasNext()) {
                    try {
                        object4 = (List)iterator.next();
                        d = (Double)object4.get(0);
                        n3 = (Integer)object4.get(1);
                        n2 = (Integer)object4.get(2);
                        object3 = (String)object4.get(3);
                        object2 = new FileInputStream((String)object3);
                        object = new byte[n2];
                        if (n3 > 0) {
                            ((InputStream)object2).skip(n3);
                        }
                        if ((n = ((InputStream)object2).read((byte[])object)) >= 0) {
                            this.pool.addRandomBytes((byte[])object, 0, n);
                            this.pool.addQuality(d * ((double)n / (double)n2));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.pool.getQuality() >= 100.0 || !this.running) {
                    return;
                }
                if (iterator2.hasNext()) {
                    try {
                        object4 = (List)iterator2.next();
                        d = (Double)object4.get(0);
                        n3 = (Integer)object4.get(1);
                        n2 = (Integer)object4.get(2);
                        object3 = (URL)object4.get(3);
                        object2 = ((URL)object3).openStream();
                        object = new byte[n2];
                        if (n3 > 0) {
                            ((InputStream)object2).skip(n3);
                        }
                        if ((n = ((InputStream)object2).read((byte[])object)) >= 0) {
                            this.pool.addRandomBytes((byte[])object, 0, n);
                            this.pool.addQuality(d * ((double)n / (double)n2));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.pool.getQuality() >= 100.0 || !this.running) {
                    return;
                }
                object4 = null;
                if (iterator3.hasNext()) {
                    try {
                        int n4;
                        List list2 = (List)iterator3.next();
                        double d2 = (Double)list2.get(0);
                        n2 = (Integer)list2.get(1);
                        int n5 = (Integer)list2.get(2);
                        object2 = (String)list2.get(3);
                        object4 = null;
                        object4 = Runtime.getRuntime().exec((String)object2);
                        object = ((Process)object4).getInputStream();
                        byte[] byArray = new byte[n5];
                        if (n2 > 0) {
                            ((InputStream)object).skip(n2);
                        }
                        if ((n4 = ((InputStream)object).read(byArray)) >= 0) {
                            this.pool.addRandomBytes(byArray, 0, n4);
                            this.pool.addQuality(d2 * ((double)n4 / (double)n5));
                        }
                        ((Process)object4).destroy();
                        ((Process)object4).waitFor();
                    }
                    catch (Exception exception) {
                        try {
                            if (object4 != null) {
                                ((Process)object4).destroy();
                                ((Process)object4).waitFor();
                            }
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                }
                if (this.pool.getQuality() >= 100.0 || !this.running) {
                    return;
                }
                if (!iterator4.hasNext()) continue;
                try {
                    EntropySource entropySource = (EntropySource)iterator4.next();
                    byte[] byArray = entropySource.nextBytes();
                    if (this.pool == null) {
                        return;
                    }
                    this.pool.addRandomBytes(byArray, 0, byArray.length);
                    this.pool.addQuality(entropySource.quality());
                }
                catch (Exception exception) {}
            }
        }

        public void stopUpdating() {
            this.running = false;
        }
    }

    private static class Spinner
    implements Runnable {
        protected byte counter;

        private Spinner() {
        }

        public void run() {
            while (true) {
                this.counter = (byte)(this.counter + 1);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

