/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.pad;

import gnu.java.security.Registry;
import gnu.javax.crypto.pad.BasePad;
import gnu.javax.crypto.pad.IPad;
import gnu.javax.crypto.pad.ISO10126;
import gnu.javax.crypto.pad.PKCS1_V1_5;
import gnu.javax.crypto.pad.PKCS7;
import gnu.javax.crypto.pad.SSL3;
import gnu.javax.crypto.pad.TBC;
import gnu.javax.crypto.pad.TLS1;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class PadFactory
implements Registry {
    private static Set names;

    private PadFactory() {
    }

    public static final IPad getInstance(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim().toLowerCase()).endsWith("padding")) {
            string = string.substring(0, string.length() - "padding".length());
        }
        BasePad basePad = null;
        if (string.equals("pkcs7") || string.equals("pkcs5")) {
            basePad = new PKCS7();
        } else if (string.equals("tbc")) {
            basePad = new TBC();
        } else if (string.equals("eme-pkcs1-v1.5")) {
            basePad = new PKCS1_V1_5();
        } else if (string.equals("ssl3")) {
            basePad = new SSL3();
        } else if (string.equals("tls1")) {
            basePad = new TLS1();
        } else if (string.equals("iso10126")) {
            basePad = new ISO10126();
        }
        if (basePad != null && !basePad.selfTest()) {
            throw new InternalError(basePad.name());
        }
        return basePad;
    }

    public static final Set getNames() {
        if (names == null) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("pkcs5");
            hashSet.add("pkcs7");
            hashSet.add("tbc");
            hashSet.add("eme-pkcs1-v1.5");
            hashSet.add("ssl3");
            hashSet.add("tls1");
            hashSet.add("iso10126");
            names = Collections.unmodifiableSet(hashSet);
        }
        return names;
    }
}

