/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.pad;

import gnu.java.security.sig.rsa.EME_PKCS1_V1_5;
import gnu.java.security.util.PRNG;
import gnu.javax.crypto.pad.BasePad;
import gnu.javax.crypto.pad.WrongPaddingException;
import java.util.logging.Logger;

public class PKCS1_V1_5
extends BasePad {
    private static final Logger log = null;
    private EME_PKCS1_V1_5 codec;

    PKCS1_V1_5() {
        super("eme-pkcs1-v1.5");
    }

    public void setup() {
        this.codec = EME_PKCS1_V1_5.getInstance(this.blockSize);
    }

    public byte[] pad(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        byte[] byArray3 = this.codec.encode(byArray2);
        byte[] byArray4 = new byte[this.blockSize - n2];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
        return byArray4;
    }

    public int unpad(byte[] byArray, int n, int n2) throws WrongPaddingException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        int n3 = n2 - this.codec.decode(byArray2).length;
        return n3;
    }

    public boolean selfTest() {
        int[] nArray = new int[]{16, 20, 32, 48, 64};
        byte[] byArray = new byte[nArray[nArray.length - 1]];
        PRNG.getInstance().nextBytes(byArray);
        byte[] byArray2 = new byte[1024];
        for (int i = 256; i < 1025; i += 256) {
            this.init(i);
            for (int j = 0; j < nArray.length; ++j) {
                int n = nArray[j];
                byte[] byArray3 = this.pad(byArray, 0, n);
                if (n + byArray3.length != this.blockSize) {
                    return false;
                }
                System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
                System.arraycopy(byArray, 0, byArray2, byArray3.length, n);
                try {
                    if (byArray3.length == this.unpad(byArray2, 0, this.blockSize)) continue;
                    return false;
                }
                catch (WrongPaddingException wrongPaddingException) {
                    return false;
                }
            }
            this.reset();
        }
        return true;
    }
}

