/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mode;

import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.mac.IMac;
import gnu.javax.crypto.mac.MacFactory;
import gnu.javax.crypto.mode.IAuthenticatedMode;
import gnu.javax.crypto.mode.IMode;
import gnu.javax.crypto.mode.ModeFactory;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EAX
implements IAuthenticatedMode {
    private int tagSize;
    private IMac nonceOmac;
    private IMac headerOmac;
    private IMac msgOmac;
    private IMode ctr;
    private int state;
    private boolean init;
    private int cipherBlockSize;
    private IBlockCipher cipher;
    private byte[] t_n;
    private static boolean valid = false;

    public EAX(IBlockCipher iBlockCipher, int n) {
        this.cipher = iBlockCipher;
        this.cipherBlockSize = n;
        String string = iBlockCipher.name();
        int n2 = string.indexOf(45);
        if (n2 >= 0) {
            string = string.substring(0, n2);
        }
        String string2 = "omac-" + string;
        this.nonceOmac = MacFactory.getInstance(string2);
        this.headerOmac = MacFactory.getInstance(string2);
        this.msgOmac = MacFactory.getInstance(string2);
        this.ctr = ModeFactory.getInstance("ctr", iBlockCipher, n);
        this.t_n = new byte[n];
        this.init = false;
    }

    public Object clone() {
        return new EAX((IBlockCipher)this.cipher.clone(), this.cipherBlockSize);
    }

    public String name() {
        return "eax(" + this.cipher.name() + ")";
    }

    public int defaultBlockSize() {
        return this.ctr.defaultBlockSize();
    }

    public int defaultKeySize() {
        return this.ctr.defaultKeySize();
    }

    public Iterator blockSizes() {
        return this.ctr.blockSizes();
    }

    public Iterator keySizes() {
        return this.ctr.keySizes();
    }

    public void init(Map map) throws InvalidKeyException {
        Integer n;
        byte[] byArray = (byte[])map.get("gnu.crypto.mode.iv");
        if (byArray == null) {
            throw new IllegalArgumentException("no nonce provided");
        }
        byte[] byArray2 = (byte[])map.get("gnu.crypto.cipher.key.material");
        if (byArray2 == null) {
            throw new IllegalArgumentException("no key provided");
        }
        Arrays.fill(this.t_n, (byte)0);
        this.nonceOmac.reset();
        this.nonceOmac.init(Collections.singletonMap("gnu.crypto.mac.key.material", byArray2));
        this.nonceOmac.update(this.t_n, 0, this.t_n.length);
        this.nonceOmac.update(byArray, 0, byArray.length);
        byte[] byArray3 = this.nonceOmac.digest();
        this.nonceOmac.reset();
        this.nonceOmac.update(this.t_n, 0, this.t_n.length);
        this.nonceOmac.update(byArray, 0, byArray.length);
        this.t_n[this.t_n.length - 1] = 1;
        this.headerOmac.reset();
        this.headerOmac.init(Collections.singletonMap("gnu.crypto.mac.key.material", byArray2));
        this.headerOmac.update(this.t_n, 0, this.t_n.length);
        this.t_n[this.t_n.length - 1] = 2;
        this.msgOmac.reset();
        this.msgOmac.init(Collections.singletonMap("gnu.crypto.mac.key.material", byArray2));
        this.msgOmac.update(this.t_n, 0, this.t_n.length);
        Integer n2 = (Integer)map.get("gnu.crypto.mode.block.size");
        if (n2 == null) {
            n2 = this.cipherBlockSize;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("gnu.crypto.cipher.key.material", byArray2);
        hashMap.put("gnu.crypto.mode.iv", byArray3);
        hashMap.put("gnu.crypto.mode.state", 1);
        hashMap.put("gnu.crypto.mode.block.size", n2);
        this.ctr.reset();
        this.ctr.init(hashMap);
        Integer n3 = (Integer)map.get("gnu.crypto.mode.state");
        if (n3 != null) {
            this.state = n3;
            if (this.state != 1 && this.state != 2) {
                throw new IllegalArgumentException("invalid state");
            }
        } else {
            this.state = 1;
        }
        this.tagSize = (n = (Integer)map.get("gnu.crypto.mac.truncated.size")) != null ? n : this.cipherBlockSize;
        if (this.tagSize < 0 || this.tagSize > this.cipherBlockSize) {
            throw new IllegalArgumentException("tag size out of range");
        }
        this.init = true;
    }

    public int currentBlockSize() {
        return this.ctr.currentBlockSize();
    }

    public void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (!this.init) {
            throw new IllegalStateException("not initialized");
        }
        if (this.state != 1) {
            throw new IllegalStateException("not encrypting");
        }
        this.ctr.update(byArray, n, byArray2, n2);
        this.msgOmac.update(byArray2, n2, this.ctr.currentBlockSize());
    }

    public void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (!this.init) {
            throw new IllegalStateException("not initialized");
        }
        if (this.state != 2) {
            throw new IllegalStateException("not decrypting");
        }
        this.msgOmac.update(byArray, n, this.ctr.currentBlockSize());
        this.ctr.update(byArray, n, byArray2, n2);
    }

    public void update(byte[] byArray, int n, byte[] byArray2, int n2) {
        switch (this.state) {
            case 1: {
                this.encryptBlock(byArray, n, byArray2, n2);
                break;
            }
            case 2: {
                this.decryptBlock(byArray, n, byArray2, n2);
                break;
            }
            default: {
                throw new IllegalStateException("impossible state " + this.state);
            }
        }
    }

    public void reset() {
        this.nonceOmac.reset();
        this.headerOmac.reset();
        this.msgOmac.reset();
        this.ctr.reset();
    }

    public boolean selfTest() {
        return true;
    }

    public int macSize() {
        return this.tagSize;
    }

    public byte[] digest() {
        byte[] byArray = new byte[this.tagSize];
        this.digest(byArray, 0);
        return byArray;
    }

    public void digest(byte[] byArray, int n) {
        if (n < 0 || n + this.tagSize > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        byte[] byArray2 = this.nonceOmac.digest();
        byte[] byArray3 = this.headerOmac.digest();
        byte[] byArray4 = this.msgOmac.digest();
        for (int i = 0; i < this.tagSize; ++i) {
            byArray[n + i] = (byte)(byArray2[i] ^ byArray3[i] ^ byArray4[i]);
        }
        this.reset();
    }

    public void update(byte by) {
        if (!this.init) {
            throw new IllegalStateException("not initialized");
        }
        this.headerOmac.update(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        if (!this.init) {
            throw new IllegalStateException("not initialized");
        }
        this.headerOmac.update(byArray, n, n2);
    }
}

