/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mode;

import gnu.java.security.util.Sequence;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.mode.BaseMode;
import java.util.Arrays;
import java.util.Iterator;

public class CTR
extends BaseMode
implements Cloneable {
    private int off;
    private byte[] counter;
    private byte[] enc;

    CTR(IBlockCipher iBlockCipher, int n) {
        super("ctr", iBlockCipher, n);
    }

    private CTR(CTR cTR) {
        this((IBlockCipher)cTR.cipher.clone(), cTR.cipherBlockSize);
    }

    public Object clone() {
        return new CTR(this);
    }

    public void setup() {
        if (this.modeBlockSize > this.cipherBlockSize) {
            throw new IllegalArgumentException("mode size exceeds cipher block size");
        }
        this.off = 0;
        this.counter = new byte[this.cipherBlockSize];
        int n = this.cipherBlockSize - 1;
        int n2 = this.iv.length - 1;
        while (n >= 0 && n2 >= 0) {
            this.counter[n--] = this.iv[n2--];
        }
        this.enc = new byte[this.cipherBlockSize];
        this.cipher.encryptBlock(this.counter, 0, this.enc, 0);
    }

    public void teardown() {
        if (this.counter != null) {
            Arrays.fill(this.counter, (byte)0);
        }
        if (this.enc != null) {
            Arrays.fill(this.enc, (byte)0);
        }
    }

    public void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.ctr(byArray, n, byArray2, n2);
    }

    public void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.ctr(byArray, n, byArray2, n2);
    }

    public Iterator blockSizes() {
        return new Sequence(1, this.cipherBlockSize).iterator();
    }

    private void ctr(byte[] byArray, int n, byte[] byArray2, int n2) {
        for (int i = 0; i < this.modeBlockSize; ++i) {
            int n3;
            byArray2[n2++] = (byte)(byArray[n++] ^ this.enc[this.off++]);
            if (this.off != this.cipherBlockSize) continue;
            for (n3 = this.cipherBlockSize - 1; n3 >= 0; --n3) {
                int n4 = n3;
                this.counter[n4] = (byte)(this.counter[n4] + 1);
                if ((this.counter[n3] & 0xFF) != 0) break;
            }
            if (n3 == 0) {
                int n5 = this.cipherBlockSize - 1;
                this.counter[n5] = (byte)(this.counter[n5] + 1);
            }
            this.off = 0;
            this.cipher.encryptBlock(this.counter, 0, this.enc, 0);
        }
    }
}

