/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mac;

import gnu.java.security.Registry;
import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.mac.BaseMac;
import gnu.javax.crypto.mac.HMacFactory;
import gnu.javax.crypto.mac.IMac;
import gnu.javax.crypto.mac.OMAC;
import gnu.javax.crypto.mac.TMMH16;
import gnu.javax.crypto.mac.UHash32;
import gnu.javax.crypto.mac.UMac32;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MacFactory
implements Registry {
    private static Set names;

    private MacFactory() {
    }

    public static IMac getInstance(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        if ((string = string.toLowerCase()).startsWith("hmac-")) {
            return HMacFactory.getInstance(string);
        }
        if (string.startsWith("omac-")) {
            IBlockCipher iBlockCipher = CipherFactory.getInstance(string = string.substring("omac-".length()));
            if (iBlockCipher == null) {
                return null;
            }
            return new OMAC(iBlockCipher);
        }
        BaseMac baseMac = null;
        if (string.equalsIgnoreCase("uhash32")) {
            baseMac = new UHash32();
        } else if (string.equalsIgnoreCase("umac32")) {
            baseMac = new UMac32();
        } else if (string.equalsIgnoreCase("tmmh16")) {
            baseMac = new TMMH16();
        }
        if (baseMac != null && !baseMac.selfTest()) {
            throw new InternalError(baseMac.name());
        }
        return baseMac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Set getNames() {
        Class<MacFactory> clazz = MacFactory.class;
        synchronized (MacFactory.class) {
            if (names == null) {
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.addAll(HMacFactory.getNames());
                hashSet.add("uhash32");
                hashSet.add("umac32");
                hashSet.add("tmmh16");
                Iterator iterator = CipherFactory.getNames().iterator();
                while (iterator.hasNext()) {
                    hashSet.add("omac-" + iterator.next());
                }
                names = Collections.unmodifiableSet(hashSet);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return names;
        }
    }
}

