/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.javax.crypto.keyring.AuthenticatedEntry;
import gnu.javax.crypto.keyring.BinaryDataEntry;
import gnu.javax.crypto.keyring.CertPathEntry;
import gnu.javax.crypto.keyring.CertificateEntry;
import gnu.javax.crypto.keyring.CompressedEntry;
import gnu.javax.crypto.keyring.EncryptedEntry;
import gnu.javax.crypto.keyring.Entry;
import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.MaskableEnvelopeEntry;
import gnu.javax.crypto.keyring.PasswordAuthenticatedEntry;
import gnu.javax.crypto.keyring.PasswordEncryptedEntry;
import gnu.javax.crypto.keyring.PrimitiveEntry;
import gnu.javax.crypto.keyring.PrivateKeyEntry;
import gnu.javax.crypto.keyring.Properties;
import gnu.javax.crypto.keyring.PublicKeyEntry;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public abstract class EnvelopeEntry
extends Entry {
    private static final Logger log = null;
    protected EnvelopeEntry containingEnvelope;
    protected List entries = new LinkedList();

    public EnvelopeEntry(int n, Properties properties) {
        super(n, properties);
        if (this.properties.get("alias-list") != null) {
            this.properties.remove("alias-list");
        }
    }

    protected EnvelopeEntry(int n) {
        super(n);
    }

    public void add(Entry entry) {
        if (!this.containsEntry(entry)) {
            if (entry instanceof EnvelopeEntry) {
                ((EnvelopeEntry)entry).setContainingEnvelope(this);
            }
            this.entries.add(entry);
            this.makeAliasList();
        }
    }

    public boolean containsAlias(String string) {
        String string2 = this.getAliasList();
        boolean bl = false;
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            while (stringTokenizer.hasMoreTokens()) {
                if (!stringTokenizer.nextToken().equals(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean containsEntry(Entry entry) {
        if (entry instanceof EnvelopeEntry) {
            return this.entries.contains(entry);
        }
        if (entry instanceof PrimitiveEntry) {
            for (Entry entry2 : this.entries) {
                if (entry2.equals(entry)) {
                    return true;
                }
                if (!(entry2 instanceof EnvelopeEntry) || !((EnvelopeEntry)entry2).containsEntry(entry)) continue;
                return true;
            }
        }
        return false;
    }

    public List getEntries() {
        return new ArrayList(this.entries);
    }

    public List get(String string) {
        LinkedList linkedList = new LinkedList();
        for (Entry entry : this.entries) {
            Entry entry2;
            if (entry instanceof EnvelopeEntry) {
                MaskableEnvelopeEntry maskableEnvelopeEntry;
                entry2 = (EnvelopeEntry)entry;
                if (!((EnvelopeEntry)entry2).containsAlias(string)) continue;
                if (entry2 instanceof MaskableEnvelopeEntry && (maskableEnvelopeEntry = (MaskableEnvelopeEntry)entry2).isMasked()) {
                    linkedList.add(maskableEnvelopeEntry);
                    continue;
                }
                linkedList.addAll(((EnvelopeEntry)entry2).get(string));
                continue;
            }
            if (!(entry instanceof PrimitiveEntry) || !((PrimitiveEntry)(entry2 = (PrimitiveEntry)entry)).getAlias().equals(string)) continue;
            linkedList.add(entry);
        }
        return linkedList;
    }

    public String getAliasList() {
        String string = this.properties.get("alias-list");
        if (string == null) {
            return "";
        }
        return string;
    }

    public boolean remove(Entry entry) {
        boolean bl = false;
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry2 = (Entry)iterator.next();
            if (entry2 instanceof EnvelopeEntry) {
                if (entry2 == entry) {
                    iterator.remove();
                    bl = true;
                    break;
                }
                if (!((EnvelopeEntry)entry2).remove(entry)) continue;
                bl = true;
                break;
            }
            if (!(entry2 instanceof PrimitiveEntry) || !((PrimitiveEntry)entry2).equals(entry)) continue;
            iterator.remove();
            bl = true;
            break;
        }
        if (bl) {
            this.payload = null;
            this.makeAliasList();
        }
        return bl;
    }

    public boolean remove(String string) {
        boolean bl = false;
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry;
            Entry entry2 = (Entry)iterator.next();
            if (entry2 instanceof EnvelopeEntry) {
                entry = (EnvelopeEntry)entry2;
                bl = ((EnvelopeEntry)entry).remove(string) || bl;
                continue;
            }
            if (!(entry2 instanceof PrimitiveEntry) || !((PrimitiveEntry)(entry = (PrimitiveEntry)entry2)).getAlias().equals(string)) continue;
            iterator.remove();
            bl = true;
        }
        if (bl) {
            this.payload = null;
            this.makeAliasList();
        }
        return bl;
    }

    public String toString() {
        return "Envelope{" + super.toString() + ", entries=" + this.entries + "}";
    }

    protected void encodePayload() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            ((Entry)iterator.next()).encode(dataOutputStream);
        }
    }

    protected void setContainingEnvelope(EnvelopeEntry envelopeEntry) {
        if (this.containingEnvelope != null) {
            throw new IllegalArgumentException("envelopes may not be shared");
        }
        this.containingEnvelope = envelopeEntry;
    }

    protected void decodeEnvelope(DataInputStream dataInputStream) throws IOException {
        int n;
        this.entries.clear();
        block13: while (true) {
            n = dataInputStream.read();
            switch (n) {
                case 0: {
                    this.add(EncryptedEntry.decode(dataInputStream));
                    continue block13;
                }
                case 1: {
                    this.add(PasswordEncryptedEntry.decode(dataInputStream));
                    continue block13;
                }
                case 3: {
                    this.add(PasswordAuthenticatedEntry.decode(dataInputStream));
                    continue block13;
                }
                case 2: {
                    this.add(AuthenticatedEntry.decode(dataInputStream));
                    continue block13;
                }
                case 4: {
                    this.add(CompressedEntry.decode(dataInputStream));
                    continue block13;
                }
                case 5: {
                    this.add(CertificateEntry.decode(dataInputStream));
                    continue block13;
                }
                case 6: {
                    this.add(PublicKeyEntry.decode(dataInputStream));
                    continue block13;
                }
                case 7: {
                    this.add(PrivateKeyEntry.decode(dataInputStream));
                    continue block13;
                }
                case 8: {
                    this.add(CertPathEntry.decode(dataInputStream));
                    continue block13;
                }
                case 9: {
                    this.add(BinaryDataEntry.decode(dataInputStream));
                    continue block13;
                }
                case -1: {
                    return;
                }
            }
            break;
        }
        throw new MalformedKeyringException("unknown type " + n);
    }

    private void makeAliasList() {
        if (!this.entries.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            Object object = this.entries.iterator();
            while (object.hasNext()) {
                Entry entry = (Entry)object.next();
                String string = null;
                if (entry instanceof EnvelopeEntry) {
                    string = ((EnvelopeEntry)entry).getAliasList();
                } else if (entry instanceof PrimitiveEntry) {
                    string = ((PrimitiveEntry)entry).getAlias();
                }
                if (string == null || (string = string.trim()).trim().length() <= 0) continue;
                stringBuilder.append(string);
                if (!object.hasNext()) continue;
                stringBuilder.append(';');
            }
            object = stringBuilder.toString();
            this.properties.put("alias-list", (String)object);
            if (this.containingEnvelope != null) {
                this.containingEnvelope.makeAliasList();
            }
        }
    }
}

