/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.javax.crypto.keyring.Properties;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Logger;

public abstract class Entry {
    private static final Logger log = null;
    private static final String[] TYPES = new String[]{"Encrypted", "PasswordEncrypted", "Authenticated", "PasswordAuthenticated", "Compressed", "Certificate", "PublicKey", "PrivateKey", "CertPath", "BinaryData"};
    protected int type;
    protected Properties properties;
    protected byte[] payload;

    protected Entry(int n, Properties properties) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("invalid packet type");
        }
        if (properties == null) {
            throw new IllegalArgumentException("no properties");
        }
        this.type = n;
        this.properties = (Properties)properties.clone();
    }

    protected Entry(int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("invalid packet type");
        }
        this.type = n;
        this.properties = new Properties();
    }

    public Properties getProperties() {
        return (Properties)this.properties.clone();
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            return null;
        }
        return (byte[])this.payload.clone();
    }

    public void encode(DataOutputStream dataOutputStream) throws IOException {
        if (this.payload == null) {
            this.encodePayload();
        }
        if (dataOutputStream == null) {
            return;
        }
        dataOutputStream.write(this.type);
        this.properties.encode(dataOutputStream);
        dataOutputStream.writeInt(this.payload.length);
        dataOutputStream.write(this.payload);
    }

    public String toString() {
        return "Entry{" + "type=" + TYPES[this.type] + ", properties=" + this.properties + ", payload=" + (this.payload == null ? "-" : "byte[" + this.payload.length + "]") + "}";
    }

    protected void defaultDecode(DataInputStream dataInputStream) throws IOException {
        this.properties = new Properties();
        this.properties.decode(dataInputStream);
        int n = dataInputStream.readInt();
        if (n < 0) {
            throw new IOException("corrupt length");
        }
        this.payload = new byte[n];
        dataInputStream.readFully(this.payload);
    }

    protected abstract void encodePayload() throws IOException;
}

